/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.beans;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import top.onceio.core.db.dao.Cnd;
import top.onceio.core.db.dao.Dao;
import top.onceio.core.db.tbl.OI18n;
import top.onceio.core.exception.Failed;
import top.onceio.core.util.OUtils;

public class GlobalExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(GlobalExceptionHandler.class);
    Dao<OI18n> dao;

    public Map<String, Object> failedHandler(Locale locale, Failed failed) throws Exception {
        String lang;
        String defaultFromat = failed.getFormat();
        String string = lang = locale == null ? null : locale.getLanguage();
        if (lang != null && !lang.equals(Locale.getDefault().getLanguage())) {
            String key = "msg/" + lang + "_" + OUtils.encodeMD5(failed.getFormat());
            Cnd<OI18n> cnd = new Cnd<OI18n>(OI18n.class);
            cnd.eq().setOid(key);
            OI18n i18n = this.dao.fetch(null, cnd);
            if (i18n != null) {
                defaultFromat = i18n.getName();
            }
        }
        String msg = String.format(defaultFromat, failed.getArgs());
        LOGGER.error((Object)String.format("ERROR: %s", msg));
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (failed.getData() != null) {
            result.put("data", failed.getData());
        }
        switch (failed.getLevel()) {
            case 3: {
                result.put("error", msg);
                break;
            }
            case 2: {
                result.put("warnning", msg);
                break;
            }
            case 1: {
                result.put("msg", msg);
            }
        }
        return result;
    }

    public Map<String, String> defaultErrorHandler(Exception e) throws Exception {
        LOGGER.error((Object)String.format("ERROR: %s", e.getMessage()));
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("error", e.getMessage());
        return result;
    }
}

