/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.cache.impl;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import top.onceio.core.cache.Cache;

public class FIFOMemoryCache
implements Cache {
    private Map<Object, SoftReference<Object>> objs;
    private LinkedList<Object> keys;
    private String name;
    private int size;
    private int length;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public FIFOMemoryCache(int size) {
        this.size = size;
        this.length = 0;
        if (this.objs == null) {
            this.objs = new HashMap<Object, SoftReference<Object>>(size);
        }
        if (this.keys == null) {
            this.keys = new LinkedList();
        }
    }

    @Override
    public <T> T get(Object key, Class<T> type) {
        SoftReference<Object> sf = this.objs.get(key);
        if (sf == null) {
            return null;
        }
        Object obj = sf.get();
        return (T)obj;
    }

    @Override
    public void put(Object key, Object value) {
        if (!this.objs.containsKey(key)) {
            ++this.length;
            this.keys.add(key);
            if (this.length >= this.size) {
                Object oldKey = this.keys.removeFirst();
                this.objs.remove(oldKey);
            }
        } else {
            this.keys.remove(key);
            this.keys.add(key);
        }
        this.objs.put(key, new SoftReference<Object>(value));
    }

    @Override
    public void evict(Object key) {
        --this.length;
        this.objs.remove(key);
        this.keys.add(key);
    }

    @Override
    public void clear() {
        this.length = 0;
        this.objs.clear();
        this.keys.clear();
    }
}

