/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.aop.proxies;

import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodProxy;
import top.onceio.core.aop.ProxyAction;
import top.onceio.core.aop.annotation.Aop;
import top.onceio.core.aop.annotation.Transactional;
import top.onceio.core.beans.BeansEden;
import top.onceio.core.db.jdbc.JdbcHelper;

@Aop(order="tran")
public class TransactionalProxy
extends ProxyAction {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = null;
        Transactional trans = method.getAnnotation(Transactional.class);
        if (trans == null) return proxy.invokeSuper(obj, args);
        JdbcHelper jdbcHelper = BeansEden.get().load(JdbcHelper.class);
        boolean created = jdbcHelper.beginTransaction(trans.isolation(), trans.readOnly());
        try {
            result = proxy.invokeSuper(obj, args);
            if (!created) return result;
            jdbcHelper.commit();
            return result;
        }
        catch (Exception e) {
            if (!created) throw e;
            jdbcHelper.rollback();
            throw e;
        }
    }
}

