/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.dao.impl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import top.onceio.core.db.annotation.ConstraintType;
import top.onceio.core.db.dao.Cnd;
import top.onceio.core.db.dao.DDLDao;
import top.onceio.core.db.dao.IdGenerator;
import top.onceio.core.db.dao.Page;
import top.onceio.core.db.dao.TransDao;
import top.onceio.core.db.dao.impl.TblIdNameVal;
import top.onceio.core.db.dao.tpl.SelectTpl;
import top.onceio.core.db.dao.tpl.UpdateTpl;
import top.onceio.core.db.jdbc.JdbcHelper;
import top.onceio.core.db.meta.ColumnMeta;
import top.onceio.core.db.meta.ConstraintMeta;
import top.onceio.core.db.meta.TableMeta;
import top.onceio.core.db.tbl.OEntity;
import top.onceio.core.db.tbl.OTableMeta;
import top.onceio.core.exception.Failed;
import top.onceio.core.exception.VolidateFailed;
import top.onceio.core.util.IDGenerator;
import top.onceio.core.util.OAssert;
import top.onceio.core.util.OUtils;

public class DaoHelper
implements DDLDao,
TransDao {
    private static final Logger LOGGER = Logger.getLogger(DaoHelper.class);
    private JdbcHelper jdbcHelper;
    private Map<String, TableMeta> tableToTableMeta;
    private IdGenerator idGenerator;
    private List<Class<? extends OEntity>> entities;

    public DaoHelper() {
    }

    public DaoHelper(JdbcHelper jdbcHelper, IdGenerator idGenerator, List<Class<? extends OEntity>> entitys) {
        this.init(jdbcHelper, idGenerator, entitys);
    }

    public boolean exist(Class<?> tbl) {
        Long cnt = 0L;
        try {
            cnt = (Long)this.jdbcHelper.queryForObject(String.format("SELECT count(*) FROM %s", tbl.getSimpleName().toLowerCase()));
        }
        catch (Failed e) {
            cnt = -1L;
        }
        return cnt != null && cnt >= 0L;
    }

    public void init(JdbcHelper jdbcHelper, IdGenerator idGenerator, List<Class<? extends OEntity>> entities) {
        List<String> sqls;
        this.jdbcHelper = jdbcHelper;
        this.idGenerator = idGenerator;
        this.tableToTableMeta = new HashMap<String, TableMeta>();
        if (!this.exist(OTableMeta.class) && (sqls = this.createOrUpdate(OTableMeta.class)) != null && !sqls.isEmpty()) {
            jdbcHelper.batchExec(sqls.toArray(new String[0]));
        }
        TableMeta tm = TableMeta.createBy(OTableMeta.class);
        this.tableToTableMeta.put(tm.getTable().toLowerCase(), tm);
        Cnd<OTableMeta> cnd = new Cnd<OTableMeta>(OTableMeta.class);
        cnd.setPage(1);
        cnd.setPagesize(Integer.MAX_VALUE);
        Page<OTableMeta> page = this.find(OTableMeta.class, cnd);
        for (OTableMeta oTableMeta : page.getData()) {
            if (oTableMeta.getName().equals(OTableMeta.class.getSimpleName().toLowerCase())) continue;
            TableMeta tableMeta = OUtils.createFromJson(oTableMeta.getVal(), TableMeta.class);
            tableMeta.getFieldConstraint();
            tableMeta.freshConstraintMetaTable();
            tableMeta.freshNameToField();
            this.tableToTableMeta.put(tableMeta.getTable().toLowerCase(), tableMeta);
        }
        if (entities != null) {
            this.entities = entities;
            HashMap<String, List<String>> tblSqls = new HashMap<String, List<String>>();
            for (Class<? extends OEntity> clazz : entities) {
                List<String> sqls2 = this.createOrUpdate(clazz);
                if (sqls2 == null) continue;
                if (!sqls2.isEmpty()) {
                    tblSqls.put(clazz.getSimpleName().toLowerCase(), sqls2);
                }
                Cnd<OTableMeta> cndMeta = new Cnd<OTableMeta>(OTableMeta.class);
                cndMeta.eq().setName(clazz.getSimpleName().toLowerCase());
                TableMeta tblMeta = TableMeta.createBy(clazz);
                OTableMeta ootm = this.fetch(OTableMeta.class, null, cndMeta);
                this.save(ootm, tblMeta.getTable(), OUtils.toJson(tblMeta));
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String tbl : tblSqls.keySet()) {
                this.sorted(tbl, arrayList);
            }
            ArrayList arrayList2 = new ArrayList();
            for (String tbl : arrayList) {
                List list = (List)tblSqls.get(tbl);
                if (list == null || list.isEmpty()) continue;
                arrayList2.addAll(list);
            }
            if (!arrayList2.isEmpty()) {
                jdbcHelper.batchExec(arrayList2.toArray(new String[0]));
            }
        }
    }

    private void sorted(String tbl, List<String> order) {
        if (!order.contains(tbl)) {
            TableMeta tblMeta = this.tableToTableMeta.get(tbl.toLowerCase());
            if (tblMeta != null) {
                for (ConstraintMeta cm : tblMeta.getFieldConstraint()) {
                    if (!cm.getType().equals((Object)ConstraintType.FOREGIN_KEY)) continue;
                    this.sorted(cm.getRefTable(), order);
                }
            }
            order.add(tbl);
        }
    }

    public List<Class<? extends OEntity>> getEntities() {
        return this.entities;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public JdbcHelper getJdbcHelper() {
        return this.jdbcHelper;
    }

    public void setJdbcHelper(JdbcHelper jdbcHelper) {
        this.jdbcHelper = jdbcHelper;
    }

    public Map<String, TableMeta> getTableToTableMata() {
        return this.tableToTableMeta;
    }

    public void setTableToTableMata(Map<String, TableMeta> tableToTableMeta) {
        this.tableToTableMeta = tableToTableMeta;
    }

    private void save(OTableMeta ootm, String name, String val) {
        if (ootm == null) {
            ootm = new OTableMeta();
            ootm.setId(IDGenerator.randomID());
            ootm.setName(name);
            ootm.setVal(val);
            ootm.setCreatetime(System.currentTimeMillis());
            this.insert(ootm);
        } else {
            ootm.setVal(val);
            this.update(ootm);
        }
    }

    @Override
    public <E extends OEntity> List<String> createOrUpdate(Class<E> tbl) {
        TableMeta old = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        if (old == null) {
            old = TableMeta.createBy(tbl);
            List<String> sqls = old.createTableSql();
            this.tableToTableMeta.put(old.getTable().toLowerCase(), old);
            return sqls;
        }
        TableMeta tm = TableMeta.createBy(tbl);
        if (!old.equals(tm)) {
            List<String> sqls = old.upgradeTo(tm);
            this.tableToTableMeta.put(tm.getTable().toLowerCase(), tm);
            return sqls;
        }
        return null;
    }

    @Override
    public <E extends OEntity> boolean drop(Class<E> tbl) {
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        if (tm == null) {
            return false;
        }
        String sql = String.format("DROP TABLE IF EXISTS %s;", tbl.getSimpleName().toLowerCase());
        this.jdbcHelper.batchUpdate(sql);
        return true;
    }

    @Override
    public int[] batchUpdate(String ... sql) {
        return this.jdbcHelper.batchExec(sql);
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> batchArgs) {
        return this.jdbcHelper.batchUpdate(sql, batchArgs);
    }

    private static <E extends OEntity> E createBy(Class<E> tbl, TableMeta tm, ResultSet rs) throws SQLException {
        OEntity row = null;
        try {
            row = (OEntity)tbl.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            OAssert.warnning("%s InstantiationException", tbl);
        }
        if (row != null) {
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String colName = rsmd.getColumnName(i);
                ColumnMeta cm = tm.getColumnMetaByName(colName);
                if (cm != null) {
                    try {
                        Object val = rs.getObject(colName);
                        cm.getField().set(row, val);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                row.put(colName, rs.getObject(i));
            }
            return (E)row;
        }
        return (E)row;
    }

    @Override
    public List<Object[]> call(String sql, Object[] args) {
        return this.jdbcHelper.call(sql, args);
    }

    @Override
    public void beginTransaction(int level, boolean readOnly) {
        this.jdbcHelper.beginTransaction(level, readOnly);
    }

    @Override
    public Savepoint setSavepoint() {
        return this.jdbcHelper.setSavepoint();
    }

    @Override
    public void rollback() {
        this.jdbcHelper.rollback();
    }

    @Override
    public void rollback(Savepoint sp) {
        this.jdbcHelper.rollback(sp);
    }

    @Override
    public void commit() {
        this.jdbcHelper.commit();
    }

    public <E extends OEntity> E get(Class<E> tbl, Long id) {
        Cnd<E> cnd = new Cnd<E>(tbl);
        cnd.setPage(1);
        cnd.setPagesize(1);
        ((OEntity)cnd.eq()).setId(id);
        Page<E> page = this.findByTpl(tbl, null, cnd);
        if (page.getData().size() == 1) {
            return (E)((OEntity)page.getData().get(0));
        }
        return null;
    }

    public <E extends OEntity> E insert(E entity) {
        OAssert.warnning(entity != null, "\u4e0d\u53ef\u4ee5\u63d2\u5165null", new Object[0]);
        Class<?> tbl = entity.getClass();
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", tbl.getSimpleName());
        this.validate(tm, entity, false);
        TblIdNameVal<OEntity> idNameVal = new TblIdNameVal<OEntity>(tm.getColumnMetas(), Arrays.asList(entity));
        if (idNameVal.getIdAt(0) == null) {
            Long id = this.idGenerator.next(tbl);
            idNameVal.setIdAt(0, id);
            entity.setId(id);
        }
        idNameVal.dropAllNullColumns();
        List<Object> vals = idNameVal.getIdValsList().get(0);
        List<String> names = idNameVal.getIdNames();
        String stub = OUtils.genStub("?", ",", names.size());
        String sql = String.format("INSERT INTO %s(%s) VALUES(%s);", tm.getTable(), String.join((CharSequence)",", names), stub);
        this.jdbcHelper.update(sql, vals.toArray());
        return entity;
    }

    private void validate(TableMeta tm, Object obj, boolean ignoreNull) {
        for (ColumnMeta cm : tm.getColumnMetas()) {
            VolidateFailed vf;
            if (cm.getName().equals("id") || cm.getName().equals("rm")) continue;
            Object val = null;
            try {
                val = cm.getField().get(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.info((Object)e.getMessage());
            }
            if (!cm.isNullable() && val == null && !ignoreNull) {
                vf = VolidateFailed.createError("%s cannot be null", cm.getName());
                vf.put(cm.getName(), "cannot be null");
                vf.throwSelf();
                continue;
            }
            if (val == null || cm.getPattern().equals("") || !val.toString().matches(cm.getPattern())) continue;
            vf = VolidateFailed.createError("%s does not matches %s", cm.getName(), cm.getPattern());
            vf.put(cm.getName(), cm.getPattern());
            vf.throwSelf();
        }
    }

    public <E extends OEntity> int batchInsert(List<E> entities) {
        if (entities == null || entities.isEmpty()) {
            return 0;
        }
        Class<?> tbl = ((OEntity)entities.get(0)).getClass();
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", tbl.getSimpleName());
        for (OEntity entity : entities) {
            this.validate(tm, entity, false);
            if (entity.getId() != null) continue;
            Long id = this.idGenerator.next(tbl);
            entity.setId(id);
        }
        TblIdNameVal<E> idNameVal = new TblIdNameVal<E>(tm.getColumnMetas(), entities);
        idNameVal.dropAllNullColumns();
        List<String> names = idNameVal.getIdNames();
        List<List<Object>> valsList = idNameVal.getIdValsList();
        String stub = OUtils.genStub("?", ",", names.size());
        String sql = String.format("INSERT INTO %s(%s) VALUES(%s);", tm.getTable(), String.join((CharSequence)",", names), stub);
        ArrayList<Object[]> vals = new ArrayList<Object[]>(valsList.size());
        for (int i = 0; i < valsList.size(); ++i) {
            vals.add(valsList.get(i).toArray());
        }
        int[] cnts = this.jdbcHelper.batchUpdate(sql, vals);
        int cnt = 0;
        for (int c : cnts) {
            cnt += c;
        }
        return cnt;
    }

    private <E extends OEntity> int update(E entity, boolean ignoreNull) {
        OAssert.warnning(entity != null, "\u4e0d\u53ef\u4ee5\u63d2\u5165null", new Object[0]);
        Class<?> tbl = entity.getClass();
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        this.validate(tm, entity, ignoreNull);
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", tbl.getSimpleName());
        TblIdNameVal<OEntity> idNameVal = new TblIdNameVal<OEntity>(tm.getColumnMetas(), Arrays.asList(entity));
        Object id = idNameVal.getIdAt(0);
        OAssert.err(id != null, "Long \u4e0d\u80fd\u4e3aNULL", new Object[0]);
        idNameVal.dropColumns("rm");
        if (ignoreNull) {
            idNameVal.dropAllNullColumns();
        }
        List<String> names = idNameVal.getNames();
        List<Object> vals = idNameVal.getValsList().get(0);
        String sql = String.format("UPDATE %s SET %s=? WHERE id=? AND rm = false;", tm.getTable(), String.join((CharSequence)"=?,", names));
        vals.add(id);
        return this.jdbcHelper.update(sql, vals.toArray());
    }

    public <E extends OEntity> int update(E entity) {
        return this.update(entity, false);
    }

    public <E extends OEntity> int updateIgnoreNull(E entity) {
        return this.update(entity, true);
    }

    public <E extends OEntity> int updateByTpl(Class<E> tbl, UpdateTpl<E> tpl) {
        OAssert.warnning(tpl.getId() != null && tpl != null, "Are you sure to update a null value?", new Object[0]);
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", tbl.getSimpleName());
        String setTpl = tpl.getSetTpl();
        ArrayList<Object> vals = new ArrayList<Object>(tpl.getArgs().size() + 1);
        vals.addAll(tpl.getArgs());
        vals.add(tpl.getId());
        String sql = String.format("UPDATE %s SET %s WHERE id=? AND rm=false;", tm.getTable(), setTpl);
        return this.jdbcHelper.update(sql, vals.toArray());
    }

    public <E extends OEntity> int updateByTplCnd(Class<E> tbl, UpdateTpl<E> tpl, Cnd<E> cnd) {
        OAssert.warnning(tpl != null, "Are you sure to update a null value?", new Object[0]);
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", tbl.getSimpleName());
        ArrayList<Object> vals = new ArrayList<Object>();
        vals.addAll(tpl.getArgs());
        ArrayList<Object> sqlArgs = new ArrayList<Object>();
        String cndSql = cnd.whereSql(sqlArgs);
        if (cndSql.isEmpty()) {
            OAssert.warnning("\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        }
        vals.addAll(sqlArgs);
        String sql = String.format("UPDATE %s SET %s WHERE (%s) AND rm=false;", tm.getTable(), tpl.getSetTpl(), cndSql);
        return this.jdbcHelper.update(sql, vals.toArray());
    }

    public <E extends OEntity> int removeById(Class<E> tbl, Long id) {
        if (id == null) {
            return 0;
        }
        OAssert.warnning(id != null, "Long\u4e0d\u80fd\u4e3anull", new Object[0]);
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", tbl.getSimpleName());
        String sql = String.format("UPDATE %s SET rm=true WHERE id=?", tm.getTable());
        return this.jdbcHelper.update(sql, new Object[]{id});
    }

    public <E> int removeByIds(Class<E> tbl, List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        String stub = OUtils.genStub("?", ",", ids.size());
        String sql = String.format("UPDATE %s SET rm=true WHERE rm = false AND id IN (%s)", tm.getTable(), stub);
        LOGGER.debug((Object)sql);
        return this.jdbcHelper.update(sql, ids.toArray());
    }

    public <E extends OEntity> int remove(Class<E> tbl, Cnd<E> cnd) {
        if (cnd == null) {
            return 0;
        }
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        ArrayList<Object> sqlArgs = new ArrayList<Object>();
        String whereCnd = cnd.whereSql(sqlArgs);
        String sql = String.format("UPDATE %s SET rm=true WHERE %s", tm.getTable(), whereCnd);
        return this.jdbcHelper.update(sql, sqlArgs.toArray());
    }

    public <E extends OEntity> int recovery(Class<E> tbl, Cnd<E> cnd) {
        if (cnd == null) {
            return 0;
        }
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        ArrayList<Object> sqlArgs = new ArrayList<Object>();
        String whereCnd = cnd.whereSql(sqlArgs);
        String sql = String.format("UPDATE %s SET rm=false WHERE rm=true AND %s", tm.getTable(), whereCnd);
        if (whereCnd.equals("")) {
            sql = String.format("UPDATE %s SET rm=false WHERE rm=true", tm.getTable());
        }
        return this.jdbcHelper.update(sql, sqlArgs.toArray());
    }

    public <E> int deleteById(Class<E> tbl, Long id) {
        if (id == null) {
            return 0;
        }
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        String sql = String.format("DELETE FROM %s WHERE id=? AND rm=true", tm.getTable());
        return this.jdbcHelper.update(sql, new Object[]{id});
    }

    public <E> int deleteByIds(Class<E> tbl, List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        String stub = OUtils.genStub("?", ",", ids.size());
        String sql = String.format("DELETE FROM %s WHERE (rm=true) AND id IN (%s) ", tm.getTable(), stub);
        return this.jdbcHelper.update(sql, ids.toArray());
    }

    public <E extends OEntity> int delete(Class<E> tbl, Cnd<E> cnd) {
        if (cnd == null) {
            return 0;
        }
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        ArrayList<Object> sqlArgs = new ArrayList<Object>();
        ((OEntity)cnd.and().eq()).setRm(true);
        String whereCnd = cnd.whereSql(sqlArgs);
        String sql = String.format("DELETE FROM %s WHERE %s;", tm.getTable(), whereCnd);
        return this.jdbcHelper.update(sql, sqlArgs.toArray());
    }

    public <E extends OEntity> long count(Class<E> tbl) {
        return this.count(tbl, null, new Cnd<E>(tbl));
    }

    public <E extends OEntity> long count(Class<E> tbl, Cnd<E> cnd) {
        return this.count(tbl, null, cnd);
    }

    public <E extends OEntity> long count(Class<E> tbl, SelectTpl<E> tpl, Cnd<E> cnd) {
        TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", tbl.getSimpleName());
        ArrayList<Object> sqlArgs = new ArrayList<Object>();
        String sql = cnd.countSql(tm, tpl, sqlArgs);
        LOGGER.debug((Object)sql);
        return (Long)this.jdbcHelper.queryForObject(sql, sqlArgs.toArray(new Object[0]));
    }

    public <E extends OEntity> Page<E> find(Class<E> tbl, Cnd<E> cnd) {
        return this.findByTpl(tbl, null, cnd);
    }

    public <E extends OEntity> Page<E> findByTpl(final Class<E> tbl, SelectTpl<E> tpl, Cnd<E> cnd) {
        final TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", tbl.getSimpleName());
        Page page = new Page();
        if (cnd.getPage() == null || cnd.getPage() <= 0) {
            page.setPage(cnd.getPage());
            if (cnd.getPage() == null || cnd.getPage() == 0) {
                cnd.setPage(1);
                page.setPage(1);
            } else {
                cnd.setPage(Math.abs(cnd.getPage()));
            }
            page.setTotal(this.count(tbl, tpl, cnd));
        }
        if (cnd.getPagesize() == null) {
            cnd.setPagesize(20);
            page.setPagesize(20);
        } else if (cnd.getPagesize() > 1000) {
            cnd.setPagesize(1000);
            page.setPagesize(1000);
        }
        if (page.getTotal() == null || page.getTotal() > 0L) {
            ArrayList<Object> sqlArgs = new ArrayList<Object>();
            String sql = cnd.pageSql(tm, tpl, sqlArgs);
            LOGGER.debug((Object)sql);
            final ArrayList data = new ArrayList();
            this.jdbcHelper.query(sql, sqlArgs.toArray(), new Consumer<ResultSet>(){

                @Override
                public void accept(ResultSet rs) {
                    OEntity row = null;
                    try {
                        row = DaoHelper.createBy(tbl, tm, rs);
                        data.add(row);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        Failed.throwError(e.getMessage(), new Object[0]);
                    }
                }
            });
            page.setData(data);
        }
        return page;
    }

    public <E extends OEntity> E fetch(Class<E> tbl, SelectTpl<E> tpl, Cnd<E> cnd) {
        if (cnd == null) {
            cnd = new Cnd<E>(tbl);
        }
        cnd.setPage(1);
        cnd.setPagesize(1);
        Page<E> page = this.findByTpl(tbl, tpl, cnd);
        if (page.getData().size() > 0) {
            return (E)((OEntity)page.getData().get(0));
        }
        return null;
    }

    public <E extends OEntity> void download(final Class<E> tbl, SelectTpl<E> tpl, Cnd<E> cnd, final Consumer<E> consumer) {
        final TableMeta tm = this.tableToTableMeta.get(tbl.getSimpleName().toLowerCase());
        if (tm == null) {
            return;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuffer sql = cnd.wholeSql(tm, tpl, args);
        this.jdbcHelper.query(sql.toString(), args.toArray(new Object[0]), new Consumer<ResultSet>(){

            @Override
            public void accept(ResultSet rs) {
                OEntity row = null;
                try {
                    row = DaoHelper.createBy(tbl, tm, rs);
                    consumer.accept(row);
                }
                catch (SQLException e) {
                    Failed.throwError(e.getMessage(), new Object[0]);
                }
            }
        });
    }

    public <E extends OEntity> List<E> findByIds(Class<E> tbl, List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList();
        }
        Cnd<E> cnd = new Cnd<E>(tbl);
        cnd.setPage(1);
        cnd.setPagesize(ids.size());
        ((OEntity)cnd.in(ids.toArray(new Object[0]))).setId(null);
        Page<E> page = this.findByTpl(tbl, null, cnd);
        return page.getData();
    }
}

