/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.meta;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import top.onceio.OnceIO;
import top.onceio.core.db.annotation.Col;
import top.onceio.core.db.annotation.Constraint;
import top.onceio.core.db.annotation.ConstraintType;
import top.onceio.core.db.annotation.Tbl;
import top.onceio.core.db.annotation.TblView;
import top.onceio.core.db.meta.ColumnMeta;
import top.onceio.core.db.meta.ConstraintMeta;
import top.onceio.core.db.meta.DDEngine;
import top.onceio.core.util.OAssert;
import top.onceio.core.util.OReflectUtil;
import top.onceio.core.util.OUtils;

public class TableMeta {
    private static final Logger LOGGER = Logger.getLogger(TableMeta.class);
    String table;
    String extend;
    String entityName;
    ConstraintMeta primaryKey;
    transient List<ConstraintMeta> fieldConstraint = new ArrayList<ConstraintMeta>(0);
    List<ConstraintMeta> constraints;
    List<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>(0);
    transient Map<String, ColumnMeta> nameToColumnMeta = new HashMap<String, ColumnMeta>();
    transient DDEngine engine;
    transient Class<?> entity;

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
        this.freshConstraintMetaTable();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entity) {
        this.entityName = entity;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public List<ColumnMeta> getColumnMetas() {
        return this.columnMetas;
    }

    public ConstraintMeta getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(ConstraintMeta primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        ConstraintMeta pk = new ConstraintMeta();
        pk.setTable(this.table);
        pk.setName(String.format("pk_%s_%s", pk.table, primaryKey));
        pk.setColumns(Arrays.asList(primaryKey));
        pk.setType(ConstraintType.PRIMARY_KEY);
        pk.setUsing("BTREE");
        this.primaryKey = pk;
    }

    public List<ConstraintMeta> getFieldConstraint() {
        return this.fieldConstraint;
    }

    public void setFieldConstraint(List<ConstraintMeta> fieldConstraint) {
        this.fieldConstraint = fieldConstraint;
    }

    public List<ConstraintMeta> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<ConstraintMeta> constraints) {
        this.constraints = constraints;
    }

    public ColumnMeta getColumnMetaByName(String colName) {
        for (String name : this.nameToColumnMeta.keySet()) {
            if (!name.equalsIgnoreCase(colName)) continue;
            return this.nameToColumnMeta.get(name);
        }
        return null;
    }

    public void setColumnMetas(List<ColumnMeta> columnMetas) {
        this.columnMetas = columnMetas;
        this.nameToColumnMeta = new HashMap<String, ColumnMeta>(columnMetas.size());
        this.fieldConstraint = new ArrayList<ConstraintMeta>(columnMetas.size());
        for (ColumnMeta cm : columnMetas) {
            this.nameToColumnMeta.put(cm.name, cm);
        }
    }

    public DDEngine getEngine() {
        return this.engine;
    }

    public Class<?> getEntity() {
        return this.entity;
    }

    public void freshNameToField() {
        try {
            Class<?> tblEntity = OnceIO.getClassLoader().loadClass(this.entityName);
            this.entity = tblEntity;
            ArrayList classes = new ArrayList();
            Class<?> clazz = tblEntity;
            while (!clazz.equals(Object.class)) {
                classes.add(0, clazz);
                clazz = clazz.getSuperclass();
            }
            HashSet<String> missed = new HashSet<String>(this.nameToColumnMeta.keySet());
            for (Class clazz2 : classes) {
                for (Field field : clazz2.getDeclaredFields()) {
                    ColumnMeta cm = this.nameToColumnMeta.get(field.getName());
                    if (cm == null) continue;
                    field.setAccessible(true);
                    cm.setField(field);
                    if (field.getType().equals(field.getGenericType())) {
                        cm.setJavaBaseType(field.getType());
                    } else {
                        Class<?> jbt = OReflectUtil.searchGenType(clazz2, (Class)classes.get(classes.size() - 1), field.getGenericType());
                        cm.setJavaBaseType(jbt);
                    }
                    missed.remove(field.getName());
                }
            }
            if (!missed.isEmpty()) {
                LOGGER.warn((Object)String.format("\u4ee5\u4e0b\u5b57\u6bb5\u6ca1\u6709\u52a0\u8f7d\u5230Field %s", OUtils.toJson(missed)));
            }
        }
        catch (ClassNotFoundException e) {
            OAssert.fatal("\u65e0\u6cd5\u52a0\u8f7d %s", this.entityName);
        }
    }

    public void freshConstraintMetaTable() {
        if (this.columnMetas != null && !this.columnMetas.isEmpty()) {
            this.nameToColumnMeta.clear();
            this.fieldConstraint = new ArrayList<ConstraintMeta>(this.columnMetas.size());
            for (ColumnMeta cm : this.columnMetas) {
                ArrayList<String> cols;
                ConstraintMeta cnsMeta;
                if (cm.unique) {
                    cnsMeta = new ConstraintMeta();
                    cols = new ArrayList<String>();
                    cols.add(cm.getName());
                    cnsMeta.setColumns(new ArrayList<String>(cols));
                    cnsMeta.setTable(this.getTable());
                    cnsMeta.setName("un_" + cnsMeta.getTable() + "_" + cm.name);
                    cnsMeta.setUsing(cm.using);
                    cnsMeta.setType(ConstraintType.UNIQUE);
                    this.fieldConstraint.add(cnsMeta);
                } else if (cm.useFK && cm.refTable != null) {
                    cnsMeta = new ConstraintMeta();
                    cols = new ArrayList();
                    cols.add(cm.getName());
                    cnsMeta.setColumns(new ArrayList<String>(cols));
                    cnsMeta.setTable(this.getTable());
                    cnsMeta.setName("fk_" + cnsMeta.getTable() + "_" + cm.name);
                    cnsMeta.setUsing(cm.using);
                    cnsMeta.setType(ConstraintType.FOREGIN_KEY);
                    cnsMeta.setRefTable(cm.refTable);
                    this.fieldConstraint.add(cnsMeta);
                }
                this.nameToColumnMeta.put(cm.getName(), cm);
            }
            if (this.extend != null && !"".equals(this.extend)) {
                ConstraintMeta cnsMeta = new ConstraintMeta();
                ArrayList<String> cols = new ArrayList<String>();
                cols.add("id");
                cnsMeta.setColumns(new ArrayList<String>(cols));
                cnsMeta.setTable(this.getTable());
                cnsMeta.setName("fk_" + cnsMeta.getTable() + "_id");
                cnsMeta.setUsing("btree");
                cnsMeta.setType(ConstraintType.FOREGIN_KEY);
                cnsMeta.setRefTable(this.extend);
                this.fieldConstraint.add(cnsMeta);
            }
        }
    }

    private List<String> alterColumnSql(List<ColumnMeta> columnMetas) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (ColumnMeta ocm : columnMetas) {
            sqls.add(String.format("ALTER TABLE %s ALTER %s %s%s;", this.table, ocm.name, ocm.type, ocm.nullable ? "" : " not null"));
        }
        return sqls;
    }

    private List<String> addColumnSql(List<ColumnMeta> columnMetas) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (ColumnMeta ocm : columnMetas) {
            sqls.add(String.format("ALTER TABLE %s ADD %s %s%s;", this.table, ocm.name, ocm.type, ocm.nullable ? "" : " not null"));
        }
        return sqls;
    }

    public List<String> createTableSql() {
        ArrayList<String> sqls = new ArrayList<String>();
        if (this.engine == null) {
            StringBuffer tbl = new StringBuffer();
            tbl.append(String.format("CREATE TABLE %s (", this.table));
            for (ColumnMeta cm : this.columnMetas) {
                tbl.append(String.format("%s %s%s,", cm.name, cm.type, cm.nullable ? "" : " not null"));
            }
            tbl.delete(tbl.length() - 1, tbl.length());
            tbl.append(");");
            sqls.add(tbl.toString());
            if (this.primaryKey != null) {
                sqls.add(this.primaryKey.addSql());
            }
            sqls.addAll(ConstraintMeta.addConstraintSql(this.fieldConstraint));
        }
        return sqls;
    }

    public List<String> upgradeTo(TableMeta other) {
        if (!this.table.equals(other.table)) {
            return null;
        }
        ArrayList<String> sqls = new ArrayList<String>();
        List<ColumnMeta> otherColumn = other.columnMetas;
        ArrayList<ColumnMeta> newColumns = new ArrayList<ColumnMeta>();
        ArrayList<ConstraintMeta> dropIndexs = new ArrayList<ConstraintMeta>();
        ArrayList<ConstraintMeta> dropForeignKeys = new ArrayList<ConstraintMeta>();
        ArrayList<ColumnMeta> alterColumns = new ArrayList<ColumnMeta>();
        ArrayList<ConstraintMeta> addForeignKeys = new ArrayList<ConstraintMeta>();
        for (ColumnMeta ocm : otherColumn) {
            ColumnMeta cm = this.nameToColumnMeta.get(ocm.name);
            if (cm == null) {
                newColumns.add(ocm);
                continue;
            }
            if (cm.unique && !ocm.unique) {
                ConstraintMeta constraintMeta = new ConstraintMeta();
                constraintMeta.setColumns(Arrays.asList(ocm.getName()));
                constraintMeta.setTable(this.table);
                constraintMeta.setType(ConstraintType.UNIQUE);
                constraintMeta.setUsing(ocm.getUsing());
                dropIndexs.add(constraintMeta);
            }
            if (cm.useFK && !ocm.useFK) {
                ConstraintMeta constraintMeta = new ConstraintMeta();
                constraintMeta.setColumns(Arrays.asList(cm.getName()));
                constraintMeta.setTable(this.table);
                constraintMeta.setType(ConstraintType.FOREGIN_KEY);
                constraintMeta.setRefTable(cm.getRefTable());
                constraintMeta.setUsing(cm.getUsing());
                dropForeignKeys.add(constraintMeta);
            }
            if (!cm.type.equals(ocm.type) || cm.nullable != ocm.nullable) {
                alterColumns.add(ocm);
            }
            if (cm.useFK || !ocm.useFK || !ocm.useFK || ocm.refTable == null) continue;
            ConstraintMeta constraintMeta = new ConstraintMeta();
            constraintMeta.setColumns(Arrays.asList(cm.getName()));
            constraintMeta.setTable(this.table);
            constraintMeta.setType(ConstraintType.FOREGIN_KEY);
            constraintMeta.setRefTable(cm.getRefTable());
            constraintMeta.setUsing(cm.getUsing());
            addForeignKeys.add(constraintMeta);
        }
        HashSet<String> oldConstraintSet = new HashSet<String>();
        HashSet<String> currentSet = new HashSet<String>();
        for (ConstraintMeta constraintMeta : this.fieldConstraint) {
            oldConstraintSet.add(String.join((CharSequence)",", constraintMeta.columns));
        }
        ArrayList<ConstraintMeta> addUniqueConstraint = new ArrayList<ConstraintMeta>();
        for (ConstraintMeta tuple : other.fieldConstraint) {
            currentSet.add(String.join((CharSequence)",", tuple.columns));
            if (oldConstraintSet.contains(String.join((CharSequence)",", tuple.columns))) continue;
            addUniqueConstraint.add(tuple);
        }
        ArrayList<ConstraintMeta> arrayList = new ArrayList<ConstraintMeta>();
        for (ConstraintMeta tuple : this.fieldConstraint) {
            if (currentSet.contains(String.join((CharSequence)",", tuple.columns))) continue;
            arrayList.add(tuple);
        }
        if (this.primaryKey != null && !this.primaryKey.equals(other.primaryKey)) {
            sqls.add(this.primaryKey.dropSql());
        }
        if (other.primaryKey != null && !other.primaryKey.equals(this.primaryKey)) {
            sqls.add(other.primaryKey.addSql());
        }
        sqls.addAll(this.addColumnSql(newColumns));
        sqls.addAll(ConstraintMeta.dropConstraintSql(dropIndexs));
        sqls.addAll(ConstraintMeta.dropConstraintSql(dropForeignKeys));
        sqls.addAll(this.alterColumnSql(alterColumns));
        sqls.addAll(ConstraintMeta.addConstraintSql(addForeignKeys));
        sqls.addAll(ConstraintMeta.dropConstraintSql(arrayList));
        sqls.addAll(ConstraintMeta.addConstraintSql(addUniqueConstraint));
        return sqls;
    }

    public static TableMeta createBy(Class<?> entity) {
        TableMeta tm = new TableMeta();
        tm.table = entity.getSimpleName().toLowerCase();
        tm.entityName = entity.getName();
        tm.entity = entity;
        Tbl tbl = entity.getAnnotation(Tbl.class);
        TblView tblView = entity.getAnnotation(TblView.class);
        if (tbl != null) {
            ArrayList<ConstraintMeta> constraints = new ArrayList<ConstraintMeta>();
            for (Constraint constraint : tbl.constraints()) {
                Field[] cm = new ConstraintMeta();
                constraints.add((ConstraintMeta)cm);
                cm.setColumns(Arrays.asList(constraint.colNames()));
                cm.setTable(tm.getTable());
                cm.setType(constraint.type());
                cm.setUsing(constraint.using());
            }
            tm.setConstraints(constraints);
            if (!tbl.extend().equals(Void.TYPE)) {
                tm.setExtend(tbl.extend().getSimpleName().toLowerCase());
            }
        }
        ArrayList classes = new ArrayList();
        Class<?> clazz = entity;
        while (!clazz.equals(Object.class)) {
            classes.add(0, clazz);
            clazz = clazz.getSuperclass();
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        ArrayList<String> colOrder = new ArrayList<String>();
        for (Class clazz2 : classes) {
            for (Field field : clazz2.getDeclaredFields()) {
                int index;
                Col col = field.getAnnotation(Col.class);
                if (col == null) continue;
                ColumnMeta cm = new ColumnMeta();
                cm.setName(field.getName());
                if (field.getName().equals("id")) {
                    cm.setPrimaryKey(true);
                }
                cm.setNullable(col.nullable());
                cm.setPattern(col.pattern());
                if (col.colDef().equals("")) {
                    Class<?> javaBaseType = cm.getJavaBaseType();
                    if (javaBaseType == null) {
                        if (field.getType() == Object.class) {
                            javaBaseType = OReflectUtil.searchGenType(clazz2, (Class)classes.get(classes.size() - 1), field.getGenericType());
                            cm.setJavaBaseType(javaBaseType);
                        } else {
                            javaBaseType = field.getType();
                            cm.setJavaBaseType(javaBaseType);
                        }
                    }
                    String type = TableMeta.transType(clazz2, entity, javaBaseType, col);
                    cm.setType(type);
                } else {
                    cm.setType(col.colDef());
                }
                cm.setUnique(col.unique());
                cm.setUsing(col.using());
                if (col.ref() != Void.TYPE) {
                    cm.setUseFK(col.useFK());
                    cm.setRefTable(col.ref().getSimpleName().toLowerCase());
                }
                if ((index = colOrder.indexOf(cm.getName())) < 0) {
                    colOrder.add(cm.getName());
                    columnMetas.add(cm);
                    continue;
                }
                columnMetas.set(index, cm);
            }
        }
        tm.setColumnMetas(columnMetas);
        tm.setPrimaryKey("id");
        tm.freshNameToField();
        tm.freshConstraintMetaTable();
        if (tblView != null && classes.size() >= 3) {
            if (classes.size() >= 3) {
                DDEngine dDEngine;
                String mainClazz = ((Class)classes.get(1)).getSimpleName().toLowerCase();
                tm.engine = dDEngine = new DDEngine();
                HashMap pathToColumns = new HashMap();
                for (ColumnMeta cm : tm.getColumnMetas()) {
                    Col col = cm.getField().getAnnotation(Col.class);
                    String pathName = col.refBy();
                    int sp = pathName.lastIndexOf(46);
                    String path = null;
                    String name = null;
                    if (sp >= 0) {
                        path = mainClazz + "." + pathName.substring(0, sp);
                        name = pathName.substring(sp + 1);
                    } else if (pathName.equals("")) {
                        path = mainClazz;
                        name = "";
                    } else {
                        OAssert.warnning("\u4e0d\u5408\u6cd5\u7684\u5f15\u7528", path);
                    }
                    ArrayList<String> vals = (ArrayList<String>)pathToColumns.get(path);
                    if (vals == null) {
                        vals = new ArrayList<String>();
                        pathToColumns.put(path, vals);
                    }
                    if (path.equals("")) {
                        vals.add(cm.getName());
                        continue;
                    }
                    vals.add(name + " " + cm.getName());
                }
                for (String path : pathToColumns.keySet()) {
                    dDEngine.append(String.format("%s{%s}", path, String.join((CharSequence)",", (Iterable)pathToColumns.get(path))));
                }
                dDEngine.build();
            } else {
                OAssert.warnning("Tbl\u5fc5\u987b\u7ee7\u627f\u4e00\u4e2aTbl", tm.getEntityName());
                return null;
            }
        }
        return tm;
    }

    private static String transType(Class<?> forefather, Class<?> clazz, Class<?> type, Col col) {
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return "bigint";
        }
        if (type.equals(String.class)) {
            return String.format("varchar(%d)", col.size());
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return "integer";
        }
        if (type.equals(BigDecimal.class)) {
            return String.format("decimal(%d,%d)", col.precision(), col.scale());
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return "smallint";
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return "float";
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return "double precision";
        }
        OAssert.fatal("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b:%s", type);
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnMetas == null ? 0 : this.columnMetas.hashCode());
        result = 31 * result + (this.constraints == null ? 0 : this.constraints.hashCode());
        result = 31 * result + (this.entityName == null ? 0 : this.entityName.hashCode());
        result = 31 * result + (this.extend == null ? 0 : this.extend.hashCode());
        result = 31 * result + (this.fieldConstraint == null ? 0 : this.fieldConstraint.hashCode());
        result = 31 * result + (this.primaryKey == null ? 0 : this.primaryKey.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableMeta other = (TableMeta)obj;
        if (this.columnMetas == null ? other.columnMetas != null : !this.columnMetas.equals(other.columnMetas)) {
            return false;
        }
        if (this.constraints == null ? other.constraints != null : !this.constraints.equals(other.constraints)) {
            return false;
        }
        if (this.entityName == null ? other.entityName != null : !this.entityName.equals(other.entityName)) {
            return false;
        }
        if (this.extend == null ? other.extend != null : !this.extend.equals(other.extend)) {
            return false;
        }
        if (this.fieldConstraint == null ? other.fieldConstraint != null : !this.fieldConstraint.equals(other.fieldConstraint)) {
            return false;
        }
        if (this.primaryKey == null ? other.primaryKey != null : !this.primaryKey.equals(other.primaryKey)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }
}

