/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.beans;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.apache.log4j.Logger;
import top.onceio.core.annotation.Config;
import top.onceio.core.annotation.Def;
import top.onceio.core.annotation.Definer;
import top.onceio.core.annotation.I18nCfg;
import top.onceio.core.annotation.I18nCfgBrief;
import top.onceio.core.annotation.I18nMsg;
import top.onceio.core.annotation.OnCreate;
import top.onceio.core.annotation.OnDestroy;
import top.onceio.core.annotation.Using;
import top.onceio.core.aop.AopProxy;
import top.onceio.core.aop.ProxyAction;
import top.onceio.core.aop.ProxyChain;
import top.onceio.core.aop.annotation.Aop;
import top.onceio.core.aop.annotation.CacheEvict;
import top.onceio.core.aop.annotation.CachePut;
import top.onceio.core.aop.annotation.Cacheable;
import top.onceio.core.aop.annotation.Transactional;
import top.onceio.core.aop.proxies.CacheEvictProxy;
import top.onceio.core.aop.proxies.CachePutProxy;
import top.onceio.core.aop.proxies.CacheableProxy;
import top.onceio.core.aop.proxies.TransactionalProxy;
import top.onceio.core.beans.ApiMethod;
import top.onceio.core.beans.ApiResover;
import top.onceio.core.beans.OI18nHolder;
import top.onceio.core.db.annotation.Tbl;
import top.onceio.core.db.annotation.TblView;
import top.onceio.core.db.dao.DaoHolder;
import top.onceio.core.db.dao.IdGenerator;
import top.onceio.core.db.dao.impl.DaoHelper;
import top.onceio.core.db.dao.tpl.Cnd;
import top.onceio.core.db.dao.tpl.SelectTpl;
import top.onceio.core.db.jdbc.JdbcHelper;
import top.onceio.core.db.tbl.OEntity;
import top.onceio.core.db.tbl.OI18n;
import top.onceio.core.exception.Failed;
import top.onceio.core.mvc.annocations.Api;
import top.onceio.core.mvc.annocations.AutoApi;
import top.onceio.core.util.AnnotationScanner;
import top.onceio.core.util.IDGenerator;
import top.onceio.core.util.JsonConfLoader;
import top.onceio.core.util.OAssert;
import top.onceio.core.util.OReflectUtil;
import top.onceio.core.util.OUtils;

public class BeansEden {
    private static final Logger LOGGER = Logger.getLogger(BeansEden.class);
    private Map<String, Object> nameToBean = new ConcurrentHashMap<String, Object>();
    private ApiResover apiResover = new ApiResover();
    private AnnotationScanner scanner = new AnnotationScanner(Api.class, AutoApi.class, Definer.class, Def.class, Using.class, Tbl.class, TblView.class, I18nMsg.class, I18nCfg.class, Aop.class);
    private static BeansEden instance = null;
    private Map<String, List<Class<?>>> patternToAopClass = new HashMap();
    private JsonConfLoader conf = null;

    private BeansEden() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeansEden get() {
        Class<BeansEden> clazz = BeansEden.class;
        synchronized (BeansEden.class) {
            if (instance == null) {
                instance = new BeansEden();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addAnnotation(Class<?> ... annotations) {
        this.scanner.getFilter().addAll(Arrays.asList(annotations));
    }

    public Set<Class<?>> getClassByAnnotation(Class<?> annotation) {
        return this.scanner.getClasses(annotation);
    }

    public List<Class<? extends OEntity>> matchTblTblView() {
        LinkedList<Class<? extends OEntity>> entities = new LinkedList<Class<? extends OEntity>>();
        for (Class<?> clazz : this.scanner.getClasses(Tbl.class)) {
            if (!OEntity.class.isAssignableFrom(clazz)) continue;
            entities.add(clazz);
        }
        for (Class<?> clazz : this.scanner.getClasses(TblView.class)) {
            if (!OEntity.class.isAssignableFrom(clazz)) continue;
            entities.add(clazz);
        }
        return entities;
    }

    private IdGenerator createIdGenerator() {
        return new IdGenerator(){

            @Override
            public Long next(Class<?> entityClass) {
                return IDGenerator.randomID();
            }
        };
    }

    private JdbcHelper createJdbcHelper(DataSource ds) {
        JdbcHelper jdbcHelper = new JdbcHelper();
        jdbcHelper.setDataSource(ds);
        return jdbcHelper;
    }

    private DaoHelper createDaoHelper(JdbcHelper jdbcHelper, IdGenerator idGenerator, List<Class<? extends OEntity>> entities) {
        DaoHelper daoHelper = new DaoHelper();
        daoHelper.init(jdbcHelper, idGenerator, entities);
        return daoHelper;
    }

    private void loadConfig(Class<?> clazz, Object bean, Field field) {
        block6: {
            Config cnfAnn = field.getAnnotation(Config.class);
            if (cnfAnn != null) {
                Class<?> fieldType = field.getType();
                String val = this.conf.getConf().get(cnfAnn.value()).getAsString();
                if (val != null) {
                    try {
                        if (OReflectUtil.isBaseType(fieldType)) {
                            field.set(bean, OReflectUtil.strToBaseType(fieldType, val));
                            break block6;
                        }
                        LOGGER.error((Object)String.format("\u5c5e\u6027\u4e0d\u652f\u6301\u8be5\u7c7b\u578b\uff1a%s", fieldType.getName()));
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    LOGGER.error((Object)String.format("\u627e\u4e0d\u5230\u5c5e\u6027\uff1a%s", cnfAnn.value()));
                }
            }
        }
    }

    private void loadConfig(Class<?> clazz, Object bean) {
        if (clazz != null && bean != null) {
            for (Field field : clazz.getFields()) {
                this.loadConfig(clazz, bean, field);
            }
        }
    }

    private void loadDefiner() {
        Set<Class<?>> definers = this.scanner.getClasses(Definer.class);
        for (Class<?> defClazz : definers) {
            try {
                Object def = defClazz.newInstance();
                this.loadConfig(defClazz, def);
                for (Method method : defClazz.getMethods()) {
                    Def defAnn = method.getAnnotation(Def.class);
                    if (defAnn == null) continue;
                    if (method.getParameterTypes().length == 0) {
                        Class<?> beanType = method.getReturnType();
                        if (!beanType.equals(Void.TYPE)) {
                            String beanName = defAnn.value();
                            try {
                                Object bean = method.invoke(def, new Object[0]);
                                this.store(beanType, beanName, bean);
                            }
                            catch (IllegalArgumentException | InvocationTargetException e) {
                                LOGGER.warn((Object)("Def \u751f\u6210Bean\u5931\u8d25 " + e.getMessage()));
                            }
                            continue;
                        }
                        LOGGER.warn((Object)"Def \u4f5c\u7528\u5728\u8fd4\u56de\u503c\u4e0a");
                        continue;
                    }
                    LOGGER.warn((Object)"Def \u4e0d\u652f\u6301\u5e26\u53c2\u6570\u7684\u6784\u9020\u51fd\u6570");
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void loadDefined() {
        Set<Class<?>> definers = this.scanner.getClasses(Def.class);
        for (Class<?> defClazz : definers) {
            try {
                Object bean = defClazz.newInstance();
                Def defAnn = defClazz.getAnnotation(Def.class);
                String beanName = defAnn.value();
                this.store(defClazz, beanName, bean);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void loadApiAutoApi() {
        Set<Class<?>> definers = this.scanner.getClasses(Api.class, AutoApi.class);
        for (Class<?> defClazz : definers) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("load Api: " + defClazz.getName()));
            }
            try {
                AopProxy cglibProxy = new AopProxy();
                Enhancer enhancer = new Enhancer();
                enhancer.setSuperclass(defClazz);
                enhancer.setCallback((Callback)cglibProxy);
                Object bean = enhancer.create();
                this.store(defClazz, null, bean);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void linkBeans() {
        for (Object bean : new HashSet<Object>(this.nameToBean.values())) {
            OReflectUtil.tracebackSuperclass(bean.getClass(), Object.class, clazz -> {
                for (Field field : clazz.getDeclaredFields()) {
                    this.loadConfig((Class<?>)clazz, bean, field);
                    Using usingAnn = field.getAnnotation(Using.class);
                    if (usingAnn == null) continue;
                    Class<?> fieldType = field.getType();
                    field.setAccessible(true);
                    Object fieldBean = this.load(fieldType, usingAnn.value());
                    if (fieldBean != null) {
                        try {
                            field.set(bean, fieldBean);
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    LOGGER.error((Object)String.format("\u627e\u4e0d\u5230 %s:%s", fieldType.getName(), usingAnn.value()));
                }
            });
        }
    }

    private void executeOnCreate(Object bean, Method method) {
        OnCreate onCreateAnn = method.getAnnotation(OnCreate.class);
        if (onCreateAnn != null) {
            if (method.getParameterCount() == 0) {
                try {
                    method.invoke(bean, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            } else {
                LOGGER.error((Object)String.format("\u521d\u59cb\u5316\u51fd\u6570%s,\u4e0d\u5e94\u8be5\u6709\u53c2\u6570", method.getName()));
            }
        }
    }

    private void checkOnDestroy(Object bean, Method method) {
        OnDestroy onDestroyAnn = method.getAnnotation(OnDestroy.class);
        if (onDestroyAnn != null && method.getParameterCount() != 0) {
            LOGGER.error((Object)String.format("\u521d\u59cb\u5316\u51fd\u6570%s,\u4e0d\u5e94\u8be5\u6709\u53c2\u6570", method.getName()));
        }
    }

    private void resoveApi(Class<?> clazz, Api fatherApi, Api methodApi, Object bean, Method method) {
        String api = null;
        api = fatherApi.value().startsWith("/") ? fatherApi.value() + methodApi.value() : "/" + fatherApi.value() + methodApi.value();
        ApiMethod[] apiMethods = methodApi.method();
        if (apiMethods.length == 0) {
            apiMethods = fatherApi.method();
        }
        if (apiMethods.length == 0) {
            LOGGER.error((Object)"Api\u7684\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ApiMethod apiMethod : apiMethods) {
            this.apiResover.push(apiMethod, api, bean, method);
        }
    }

    private void resoveAutoApi(Class<?> clazz, AutoApi autoApi, Api methodApi, Object bean, Method method, String methodName) {
        String api = "/" + autoApi.value().getSimpleName().toLowerCase();
        if (methodName != null && !methodName.equals("") && !methodName.equals("/")) {
            api = api + methodName;
        }
        for (ApiMethod apiMethod : methodApi.method()) {
            this.apiResover.push(apiMethod, api, bean, method);
        }
    }

    private void resoveBeanMethod() {
        for (Object bean : new HashSet<Object>(this.nameToBean.values())) {
            Api methodApi;
            Class<?> clazz = bean.getClass();
            if (clazz.getName().contains("$$EnhancerByCGLIB$$")) {
                clazz = clazz.getSuperclass();
            }
            Api fatherApi = clazz.getAnnotation(Api.class);
            AutoApi autoApi = clazz.getAnnotation(AutoApi.class);
            HashSet<String> ignoreMethods = new HashSet<String>();
            for (Method method : clazz.getDeclaredMethods()) {
                this.executeOnCreate(bean, method);
                this.checkOnDestroy(bean, method);
                methodApi = method.getAnnotation(Api.class);
                if (fatherApi != null && methodApi != null) {
                    this.resoveApi(clazz, fatherApi, methodApi, bean, method);
                }
                if (autoApi != null && methodApi != null) {
                    ignoreMethods.add(method.getName() + method.getParameterTypes().hashCode());
                    if (!methodApi.value().equals("")) {
                        this.resoveAutoApi(clazz, autoApi, methodApi, bean, method, methodApi.value());
                    } else {
                        this.resoveAutoApi(clazz, autoApi, methodApi, bean, method, "/" + method.getName());
                    }
                }
                this.resovleMethodAop(clazz, method);
            }
            if (autoApi == null || !DaoHolder.class.isAssignableFrom(clazz)) continue;
            for (Method method : DaoHolder.class.getDeclaredMethods()) {
                methodApi = method.getAnnotation(Api.class);
                if (methodApi == null || ignoreMethods.contains(method.getName() + method.getParameterTypes().hashCode())) continue;
                if (!methodApi.value().equals("")) {
                    this.resoveAutoApi(clazz, autoApi, methodApi, bean, method, methodApi.value());
                    continue;
                }
                this.resoveAutoApi(clazz, autoApi, methodApi, bean, method, "/" + method.getName());
            }
        }
        this.apiResover.build();
    }

    private void resovleAop() {
        for (Class<?> clazz : this.scanner.getClasses(Aop.class)) {
            Aop aop = clazz.getAnnotation(Aop.class);
            String[] patterns = aop.pattern();
            if (patterns.length == 0) {
                patterns = aop.value();
            }
            for (String pattern : patterns) {
                List<Class<?>> aopClasses = this.patternToAopClass.get(pattern);
                if (aopClasses == null) {
                    aopClasses = new ArrayList();
                    this.patternToAopClass.put(pattern, aopClasses);
                }
                aopClasses.add(clazz);
            }
        }
    }

    private void resovleMethodAop(Class<?> clazz, Method method) {
        ProxyChain aopChain;
        Transactional tran;
        CacheEvict cacheEvict;
        CachePut cachePut;
        String func = clazz.getName() + "." + method.getName();
        HashSet aopClazz = new HashSet();
        for (Map.Entry<String, List<Class<?>>> entry : this.patternToAopClass.entrySet()) {
            if (!func.matches(entry.getKey())) continue;
            aopClazz.addAll((Collection)entry.getValue());
        }
        Cacheable cacheable = method.getAnnotation(Cacheable.class);
        if (cacheable != null) {
            aopClazz.add(CacheableProxy.class);
        }
        if ((cachePut = method.getAnnotation(CachePut.class)) != null) {
            aopClazz.add(CachePutProxy.class);
        }
        if ((cacheEvict = method.getAnnotation(CacheEvict.class)) != null) {
            aopClazz.add(CacheEvictProxy.class);
        }
        if ((tran = method.getAnnotation(Transactional.class)) != null) {
            aopClazz.add(TransactionalProxy.class);
        }
        if (!aopClazz.isEmpty() && (aopChain = AopProxy.get(method)) == null) {
            aopChain = new ProxyChain();
            AopProxy.push(method, aopChain);
            List<Class<?>> sorted = this.sortAopClass(aopClazz);
            for (int i = 0; i < sorted.size(); ++i) {
                try {
                    ProxyAction action = (ProxyAction)sorted.get(i).newInstance();
                    aopChain.append(action);
                    continue;
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<Class<?>> sortAopClass(Set<Class<?>> collections) {
        ArrayList list = new ArrayList(collections);
        Collections.sort(list, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> o1, Class<?> o2) {
                Aop aop1 = o1.getAnnotation(Aop.class);
                Aop aop2 = o2.getAnnotation(Aop.class);
                return aop1.order().compareTo(aop2.order());
            }
        });
        return list;
    }

    private void loadDefaultBeans() {
        DaoHelper daoHelper;
        JdbcHelper jdbcHelper;
        DataSource ds = this.load(DataSource.class, null);
        OAssert.err(ds != null, "dataSource cannot be null", new Object[0]);
        IdGenerator idGenerator = this.load(IdGenerator.class, null);
        if (idGenerator == null) {
            idGenerator = this.createIdGenerator();
            this.store(IdGenerator.class, null, idGenerator);
        }
        if ((jdbcHelper = this.load(JdbcHelper.class, null)) == null) {
            jdbcHelper = this.createJdbcHelper(ds);
            this.store(JdbcHelper.class, null, jdbcHelper);
        }
        if ((daoHelper = this.load(DaoHelper.class, null)) == null) {
            daoHelper = this.createDaoHelper(jdbcHelper, idGenerator, this.matchTblTblView());
            this.store(DaoHelper.class, null, daoHelper);
        } else if (daoHelper.getEntities() == null) {
            daoHelper.init(jdbcHelper, idGenerator, this.matchTblTblView());
        }
    }

    public void resovle(String[] confDir, String[] packages) {
        this.conf = JsonConfLoader.loadConf(confDir);
        this.scanner.scanPackages(packages);
        this.scanner.putClass(Tbl.class, OI18n.class);
        this.scanner.putClass(AutoApi.class, OI18nHolder.class);
        this.nameToBean.putAll(this.conf.resovleBeans());
        this.resovleAop();
        this.loadDefiner();
        this.loadDefaultBeans();
        this.loadDefined();
        this.loadApiAutoApi();
        this.linkBeans();
        this.resoveBeanMethod();
        this.init();
    }

    public <T> void store(Class<T> clazz, String beanName, Object bean) {
        OAssert.err(bean != null, "%s:%s can not be null!", clazz.getName(), beanName);
        if (beanName == null || beanName.equals("")) {
            Class<?>[] classArray;
            int n;
            int n2;
            Def def = clazz.getAnnotation(Def.class);
            if (def != null && def.nameByInterface() && (n2 = 0) < (n = (classArray = clazz.getInterfaces()).length)) {
                Class<?> iter = classArray[n2];
                beanName = iter.getName();
                this.nameToBean.put(beanName, bean);
            }
            beanName = clazz.getName();
        }
        this.nameToBean.put(beanName, bean);
        LOGGER.debug((Object)("store beanName=" + beanName));
    }

    public <T> T load(Class<T> clazz) {
        return this.load(clazz, null);
    }

    public <T> T load(Class<T> clazz, String beanName) {
        Object v = null;
        v = beanName == null || beanName.equals("") ? this.nameToBean.get(clazz.getName()) : this.nameToBean.get(beanName);
        if (v != null) {
            return (T)v;
        }
        return null;
    }

    public <T> void erase(Class<T> clazz, String beanName) {
        T bean = this.load(clazz, beanName);
        if (bean != null) {
            for (Method method : clazz.getMethods()) {
                OnDestroy onDestroyAnn = method.getAnnotation(OnDestroy.class);
                if (onDestroyAnn == null) continue;
                if (method.getParameterCount() == 0) {
                    try {
                        method.invoke(bean, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                LOGGER.error((Object)String.format("\u6784\u9020%s,\u4e0d\u5e94\u8be5\u6709\u53c2\u6570", method.getName()));
            }
        } else {
            LOGGER.error((Object)String.format("\u627e\u4e0d\u5230Bean\u5bf9\u8c61\uff1a  %s:%s", clazz.getName(), beanName));
        }
    }

    public void init() {
        this.annlysisI18nMsg();
        this.annlysisConst();
    }

    private void annlysisI18nMsg() {
        OI18nHolder dao = this.load(OI18nHolder.class);
        Set<Class<?>> classes = this.scanner.getClasses(I18nMsg.class);
        if (classes == null) {
            return;
        }
        ArrayList<OI18n> i18ns = new ArrayList<OI18n>();
        for (Class<?> clazz : classes) {
            I18nMsg group = clazz.getAnnotation(I18nMsg.class);
            for (Field field : clazz.getFields()) {
                field.setAccessible(true);
                try {
                    String name = field.get(null).toString();
                    String key = "msg/" + group.value() + "_" + OUtils.encodeMD5(name);
                    Cnd<OI18n> cnd = new Cnd<OI18n>(OI18n.class);
                    cnd.eq().setOid(key);
                    OI18n i18n = (OI18n)dao.fetch((SelectTpl)null, cnd);
                    if (i18n != null) continue;
                    i18n = new OI18n();
                    i18n.setOid(key);
                    i18n.setName(name);
                    i18ns.add(i18n);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Failed.throwError(e.getMessage(), new Object[0]);
                }
            }
        }
        dao.batchInsert(i18ns);
    }

    private void annlysisConst() {
        OI18nHolder dao = this.load(OI18nHolder.class);
        Set<Class<?>> classes = this.scanner.getClasses(I18nCfg.class);
        if (classes == null) {
            return;
        }
        ArrayList<OI18n> i18ns = new ArrayList<OI18n>();
        for (Class<?> clazz : classes) {
            I18nCfg group = clazz.getAnnotation(I18nCfg.class);
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                I18nCfgBrief cons = field.getAnnotation(I18nCfgBrief.class);
                try {
                    String fieldname = field.getName();
                    String val = field.get(null).toString();
                    String key = "const/" + group.value() + "_" + clazz.getSimpleName() + "_" + fieldname;
                    String name = cons.value();
                    Cnd<OI18n> cnd = new Cnd<OI18n>(OI18n.class);
                    cnd.eq().setOid(key);
                    OI18n i18n = (OI18n)dao.fetch((SelectTpl)null, cnd);
                    if (i18n == null) {
                        i18n = new OI18n();
                        i18n.setOid(key);
                        i18n.setName(name);
                        i18n.setVal(val);
                        LOGGER.debug((Object)("add: " + i18n));
                        i18ns.add(i18n);
                        continue;
                    }
                    if (!val.equals(i18n.getVal())) {
                        field.set(null, OReflectUtil.strToBaseType(field.getType(), i18n.getVal()));
                        LOGGER.debug((Object)("reload: " + i18n));
                    }
                    if (i18n.getName().equals(name)) continue;
                    i18n.setName(name);
                    dao.insert(i18n);
                    LOGGER.debug((Object)("update: " + i18n));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                    Failed.throwError(e.getMessage(), new Object[0]);
                }
            }
        }
        dao.batchInsert(i18ns);
    }

    public ApiResover getApiResover() {
        return this.apiResover;
    }
}

