/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.dao.impl;

import java.util.ArrayList;
import java.util.List;
import top.onceio.core.db.meta.ColumnMeta;
import top.onceio.core.util.OAssert;

public class TblIdNameVal<E> {
    List<Object> ids;
    List<String> names;
    List<List<Object>> valsList;

    public TblIdNameVal(List<ColumnMeta> columnMetas, List<E> entities) {
        this.ids = new ArrayList<Object>(columnMetas.size());
        this.names = new ArrayList<String>(columnMetas.size());
        this.valsList = new ArrayList<List<Object>>(entities.size());
        boolean hasNames = false;
        for (E entity : entities) {
            if (entity == null) continue;
            ArrayList<Object> vals = new ArrayList<Object>(columnMetas.size());
            this.valsList.add(vals);
            for (ColumnMeta cm : columnMetas) {
                if (!hasNames && !cm.isPrimaryKey()) {
                    this.names.add(cm.getName());
                }
                try {
                    Object val = cm.getField().get(entity);
                    if (cm.isPrimaryKey()) {
                        this.ids.add(val);
                        continue;
                    }
                    vals.add(val);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    OAssert.warnning("%s.%s \u8bbf\u95ee\u5f02\u5e38:%s", entity.getClass().getSimpleName(), cm.getName(), e.getMessage());
                }
            }
            hasNames = true;
        }
    }

    public Object getIdAt(int index) {
        return this.ids.get(0);
    }

    public Object setIdAt(int index, Object val) {
        return this.ids.set(index, val);
    }

    public List<String> getNames() {
        return this.names;
    }

    public List<String> getIdNames() {
        ArrayList<String> idNames = new ArrayList<String>();
        idNames.add("id");
        idNames.addAll(this.names);
        return idNames;
    }

    public List<List<Object>> getValsList() {
        return this.valsList;
    }

    public List<List<Object>> getIdValsList() {
        ArrayList<List<Object>> idValsList = new ArrayList<List<Object>>();
        for (int i = 0; i < this.ids.size(); ++i) {
            Object id = this.ids.get(i);
            List<Object> row = this.valsList.get(i);
            ArrayList<Object> idRow = new ArrayList<Object>(row.size() + 1);
            idRow.add(id);
            idRow.addAll(row);
            idValsList.add(idRow);
        }
        return idValsList;
    }

    public void dropAllNullColumns() {
        ArrayList<Integer> nullColumnsIndex = new ArrayList<Integer>();
        Integer i = this.names.size() - 1;
        while (i >= 0) {
            block4: {
                for (List<Object> row : this.valsList) {
                    if (row.get(i) == null) continue;
                    break block4;
                }
                nullColumnsIndex.add(i);
            }
            Integer n = i;
            i = i - 1;
            Integer n2 = i;
        }
        for (Integer j : nullColumnsIndex) {
            this.names.remove(j);
            for (List list : this.valsList) {
                list.remove(j);
            }
        }
    }

    public void dropColumns(String colName) {
        int rm = -1;
        for (int i = 0; i < this.names.size(); ++i) {
            if (!this.names.get(i).equals(colName)) continue;
            rm = i;
            break;
        }
        if (rm >= 0) {
            this.names.remove(rm);
            for (List<Object> row : this.valsList) {
                row.remove(rm);
            }
        }
    }
}

