/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import top.onceio.core.db.meta.DDMeta;
import top.onceio.core.util.OAssert;
import top.onceio.core.util.Tuple3;

public class DDEngine {
    public Map<String, DDMeta> pathToMeta = new HashMap<String, DDMeta>();
    public Map<String, DDMeta> aliasToMeta = new HashMap<String, DDMeta>();
    public Map<String, DDMeta> columnToMeta = new HashMap<String, DDMeta>();
    public Map<String, Map<String, String>> relMap = new HashMap<String, Map<String, String>>();

    public DDEngine append(String resultSet) {
        String[] sets;
        for (String set : sets = resultSet.split(";")) {
            String[] tbl_columns = set.split("\\{|\\}");
            if (tbl_columns.length >= 2) {
                String path = tbl_columns[0].trim();
                String[] columns = tbl_columns[1].split(",");
                DDMeta meta = new DDMeta();
                meta.setPath(path);
                meta.setColumnMapping(Arrays.asList(columns));
                this.pathToMeta.put(path, meta);
                continue;
            }
            OAssert.warnning("%s -> %s \u4e0d\u5408\u6cd5", resultSet, set);
        }
        return this;
    }

    private String tranAlias(int id) {
        return "T" + id;
    }

    public void build() {
        DDMeta meta;
        this.supplyDDMeta();
        ArrayList<String> paths = new ArrayList<String>(this.pathToMeta.keySet());
        Collections.sort(paths);
        int id = 0;
        for (String path : paths) {
            meta = this.pathToMeta.get(path);
            meta.setName(this.tranAlias(id));
            ++id;
        }
        for (String path : paths) {
            meta = this.pathToMeta.get(path);
            this.resoveDDMeta(meta);
        }
        for (DDMeta meta2 : this.pathToMeta.values()) {
            this.aliasToMeta.put(meta2.getName(), meta2);
            for (String col : meta2.getColumns()) {
                this.columnToMeta.put(col, meta2);
            }
        }
    }

    private void supplyDDMeta() {
        ArrayList<String> keys = new ArrayList<String>(this.pathToMeta.keySet());
        Collections.sort(keys);
        for (String path : keys) {
            String[] pathArr = path.split("-");
            String lastTbl = null;
            for (int i = 0; i < pathArr.length; ++i) {
                String curTbl = pathArr[i];
                String tbl = curTbl.replaceAll("\\..*", "");
                if (tbl.equals(lastTbl)) {
                    ArrayList<String> plist = new ArrayList<String>();
                    for (int t = 0; t < i; ++t) {
                        plist.add(pathArr[t]);
                    }
                    plist.add(tbl);
                    String pkName = pathArr[i - 1].replaceAll(".*\\.", "");
                    String npath = String.join((CharSequence)"-", plist);
                    if (!this.pathToMeta.containsKey(npath)) {
                        DDMeta nmeta = new DDMeta();
                        nmeta.setPath(npath);
                        nmeta.setPkName(pkName);
                        this.pathToMeta.put(npath, nmeta);
                    }
                }
                lastTbl = tbl;
            }
        }
    }

    private Tuple3<String, String, String> splitPath(String path) {
        Tuple3<String, String, String> result = new Tuple3<String, String, String>();
        int sep = path.lastIndexOf(45);
        if (sep < 0) {
            result.a = path;
        } else {
            String rel = path.substring(0, sep);
            int rSep = rel.lastIndexOf(46);
            result.a = path.substring(0, rSep);
            result.b = path.substring(sep + 1);
            result.c = path.substring(rSep + 1, sep);
        }
        return result;
    }

    private void resoveDDMeta(DDMeta meta) {
        Tuple3<String, String, String> tbls = this.splitPath(meta.getPath());
        if (tbls.a != null && tbls.b == null) {
            meta.setTable((String)tbls.a);
            return;
        }
        meta.setTable(((String)tbls.b).replaceAll("\\..*", ""));
        DDMeta metaA = this.pathToMeta.get(tbls.a);
        if (meta.getPkName() != null) {
            tbls = this.splitPath((String)tbls.a);
            metaA = this.pathToMeta.get(tbls.a);
        }
        if (metaA != null) {
            String rel = String.format("%s.%s = %s.%s", metaA.getName(), tbls.c, meta.getName(), meta.getPkName() == null ? "id" : meta.getPkName());
            this.saveRelation(rel, meta, metaA);
        } else {
            OAssert.fatal("\u4e0d\u53ef\u80fd,%s \u5bf9\u5230\u9519\u8bef", meta.getPath());
        }
    }

    private void saveRelation(String relation, DDMeta a, DDMeta b) {
        Map<String, String> mappingA = this.relMap.get(a.getName());
        if (mappingA == null) {
            mappingA = new HashMap<String, String>();
            this.relMap.put(a.getName(), mappingA);
        }
        mappingA.put(b.getName(), relation);
        Map<String, String> mappingB = this.relMap.get(b.getName());
        if (mappingB == null) {
            mappingB = new HashMap<String, String>();
            this.relMap.put(b.getName(), mappingB);
        }
        mappingB.put(a.getName(), relation);
    }

    public boolean search(Set<DDMeta> spoor, List<DDMeta> path, DDMeta src, DDMeta dest) {
        if (spoor.contains(src)) {
            return false;
        }
        Map<String, String> map = this.relMap.get(src.getName());
        if (map == null) {
            return false;
        }
        path.add(src);
        spoor.add(src);
        if (map.containsKey(dest.getName()) || src.getName().equals(dest.getName())) {
            path.add(dest);
            return true;
        }
        for (String subSrc : map.keySet()) {
            DDMeta subMeta = this.aliasToMeta.get(subSrc);
            if (!this.search(spoor, path, subMeta, dest)) continue;
            return true;
        }
        return false;
    }

    public String genericJoinSqlByParams(String mainPath, Set<String> select, Set<String> params) {
        Object meta;
        DDMeta mainMeta = this.pathToMeta.get(mainPath);
        if (mainMeta == null) {
            OAssert.warnning("%s \u4e0d\u5b58\u5728", mainPath);
        }
        HashSet<Object> set = new HashSet<Object>();
        if (params != null && !params.isEmpty()) {
            for (String column : params) {
                meta = this.columnToMeta.get(column);
                if (meta != null) {
                    set.add(meta);
                    continue;
                }
                OAssert.warnning("\u5217 %s \u4e0d\u5b58\u5728", column);
            }
        }
        if (select != null && !select.isEmpty()) {
            for (String column : select) {
                meta = this.columnToMeta.get(column);
                if (meta != null) {
                    set.add(meta);
                    continue;
                }
                OAssert.warnning("\u5217 %s \u4e0d\u5b58\u5728", column);
            }
        }
        HashSet<DDMeta> depends = new HashSet<DDMeta>();
        ArrayList<String> dependNamePaths = new ArrayList<String>();
        meta = set.iterator();
        while (meta.hasNext()) {
            HashSet<DDMeta> spoor = new HashSet<DDMeta>();
            ArrayList<DDMeta> path = new ArrayList<DDMeta>();
            DDMeta meta2 = (DDMeta)meta.next();
            if (this.search(spoor, path, meta2, mainMeta)) {
                depends.addAll(path);
                StringBuffer namepath = new StringBuffer();
                for (int i = path.size() - 1; i >= 0; --i) {
                    namepath.append(((DDMeta)path.get(i)).getName() + "-");
                }
                dependNamePaths.add(namepath.toString());
                continue;
            }
            OAssert.warnning("\u5173\u7cfb\u4e00\u5b9a\u6709\u9519\u8bef\uff0c\u65e0\u6cd5\u63a8\u5bfc %s -> %s", meta2, mainPath);
        }
        Collections.sort(dependNamePaths);
        depends.add(mainMeta);
        StringBuffer sql = new StringBuffer("");
        sql.append(String.format("%s %s", mainMeta.getTable(), mainMeta.getName()));
        if (dependNamePaths != null && !dependNamePaths.isEmpty()) {
            HashSet<String> spoor = new HashSet<String>();
            spoor.add(mainMeta.getName());
            for (String dnp : dependNamePaths) {
                String[] deps = dnp.split("-");
                String depend = deps[0];
                for (int i = 1; i < deps.length; ++i) {
                    DDMeta meta3 = this.aliasToMeta.get(deps[i]);
                    if (spoor.contains(meta3.getName())) continue;
                    spoor.add(meta3.getName());
                    DDMeta dependMeta = this.aliasToMeta.get(depend);
                    String rel = this.relMap.get(meta3.getName()).get(dependMeta.getName());
                    sql.append(String.format("\nLEFT JOIN %s %s on %s", meta3.getTable(), meta3.getName(), rel));
                    depend = deps[i];
                }
            }
        }
        return sql.toString();
    }

    public Map<String, String> getColumnToOrigin() {
        HashMap<String, String> tokens = new HashMap<String, String>();
        for (String col : this.columnToMeta.keySet()) {
            DDMeta meta = this.columnToMeta.get(col);
            tokens.put(col, meta.getName() + "." + meta.getColumnToOrigin().get(col));
        }
        return tokens;
    }
}

