/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import top.onceio.core.util.OAssert;

public class OReflectUtil {
    private static Map<Class<?>, Map<String, Method>> clsSetter = new HashMap();

    public static Class<?> searchGenType(Class<?> forefather, Class<?> entity, Type fieldType) {
        ArrayList classes = new ArrayList();
        Integer typeIndex = null;
        Class<?> clazz = entity;
        while (!clazz.equals(forefather)) {
            classes.add(0, clazz);
            clazz = clazz.getSuperclass();
        }
        classes.add(0, forefather);
        Class father = (Class)classes.get(0);
        for (int i = 1; i < classes.size(); ++i) {
            Class son = (Class)classes.get(i);
            TypeVariable<Class<T>>[] param = father.getTypeParameters();
            Type types = son.getGenericSuperclass();
            Type[] genericTypes = null;
            if (types instanceof ParameterizedType) {
                genericTypes = ((ParameterizedType)types).getActualTypeArguments();
            }
            for (int pi = 0; pi < param.length; ++pi) {
                if (!fieldType.equals(param[pi])) continue;
                if (genericTypes != null) {
                    fieldType = genericTypes[pi];
                    typeIndex = pi;
                    Class<?> javaBaseType = OReflectUtil.tranBaseType(fieldType);
                    if (javaBaseType == null) break;
                    return javaBaseType;
                }
                typeIndex = pi;
                fieldType = null;
                break;
            }
            if (fieldType != null) {
                for (TypeVariable t : son.getTypeParameters()) {
                    if (fieldType == null || !fieldType.equals(t)) continue;
                    fieldType = t;
                    Class<?> javaBaseType = OReflectUtil.tranBaseType(fieldType);
                    if (javaBaseType != null) {
                        return javaBaseType;
                    }
                    break;
                }
            } else if (typeIndex != null) {
                fieldType = son.getTypeParameters()[typeIndex];
                Class<?> javaBaseType = OReflectUtil.tranBaseType(fieldType);
                if (javaBaseType != null) {
                    return javaBaseType;
                }
            } else {
                return null;
            }
            father = son;
        }
        return null;
    }

    public static <T> T strToBaseType(Class<T> type, String val) {
        if (val == null) {
            return null;
        }
        if (type.equals(String.class)) {
            return (T)val;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return (T)Integer.valueOf(val);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return (T)Long.valueOf(val);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return (T)Boolean.valueOf(val);
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return (T)Byte.valueOf(val);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return (T)Short.valueOf(val);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return (T)Double.valueOf(val);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return (T)Float.valueOf(val);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)BigDecimal.valueOf(Double.valueOf(val));
        }
        if (type.equals(Date.class)) {
            return (T)Date.valueOf(val);
        }
        return null;
    }

    public static boolean isBaseType(Type type) {
        if (type == String.class || type == Character.class || type == Character.TYPE) {
            return true;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return true;
        }
        if (type == Long.class || type == Long.TYPE) {
            return true;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return true;
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return true;
        }
        if (type == Short.class || type == Short.TYPE) {
            return true;
        }
        if (type == Float.class || type == Float.TYPE) {
            return true;
        }
        if (type == Double.class || type == Double.TYPE) {
            return true;
        }
        if (type == BigDecimal.class) {
            return true;
        }
        return type == Date.class;
    }

    public static Class<?> tranBaseType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    public static boolean isNumber(Object obj) {
        return obj instanceof Number;
    }

    public static boolean isCharacter(Object obj) {
        return obj instanceof String || obj instanceof Character;
    }

    public static Method getSetMethod(Class<?> cls, String fieldName) {
        Map<String, Method> setter = clsSetter.get(cls);
        if (setter == null) {
            setter = new HashMap<String, Method>();
            clsSetter.put(cls, setter);
            for (Method m : cls.getMethods()) {
                if (!m.getName().startsWith("set") || m.getParameterCount() != 1) continue;
                setter.put(m.getName(), m);
            }
        }
        int mask = -33;
        char c = (char)(fieldName.charAt(0) & mask);
        String methodName = "set" + c + fieldName.substring(1);
        return setter.get(methodName);
    }

    public static void tracebackSuperclass(Class<?> clazz, Class<?> superclass, Consumer<Class<?>> consumer) {
        if (!superclass.isAssignableFrom(clazz)) {
            OAssert.err("%s is not assignable from %s", clazz.getName(), superclass.getName());
        }
        ArrayList classes = new ArrayList();
        for (Class<?> cls = clazz; cls != superclass; cls = cls.getSuperclass()) {
            classes.add(0, cls);
        }
        for (Class clazz2 : classes) {
            consumer.accept(clazz2);
        }
    }
}

