/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import top.onceio.core.db.meta.IndexMeta;
import top.onceio.core.db.meta.TableMeta;
import top.onceio.core.db.model.BaseTable;

public class SqlPlanBuilder {
    public static int DROP = 0;
    public static int CREATE = 1;
    public static int ALTER = 2;
    public static int COMMENT = 3;
    Map<TableMeta, List<String>[]> plan = new HashMap<TableMeta, List<String>[]>();

    private List<String>[] createArray() {
        List[] arr = new List[4];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new ArrayList();
        }
        return arr;
    }

    public SqlPlanBuilder append(int option, TableMeta meta, String sql) {
        List<String>[] arr = this.plan.get(meta);
        if (arr == null) {
            arr = this.createArray();
            this.plan.put(meta, arr);
        }
        arr[option].add(sql);
        return this;
    }

    public SqlPlanBuilder append(int option, TableMeta meta, List<String> sql) {
        List<String>[] arr = this.plan.get(meta);
        if (arr == null) {
            arr = this.createArray();
            this.plan.put(meta, arr);
        }
        arr[option].addAll(sql);
        return this;
    }

    public SqlPlanBuilder append(SqlPlanBuilder otherPlan) {
        otherPlan.plan.forEach((k, v) -> {
            for (int i = 0; i < ((List[])v).length; ++i) {
                this.append(i, (TableMeta)k, v[i]);
            }
        });
        return this;
    }

    private void sortedAdd(Map<String, TableMeta> nameToMeta, List<TableMeta> order, BaseTable def) {
        TableMeta meta = nameToMeta.get(def.getName());
        if (order.contains(meta)) {
            return;
        }
        List<BaseTable<?>> refs = def.getRefs();
        for (BaseTable<?> ref : refs) {
            this.sortedAdd(nameToMeta, order, ref);
        }
        order.add(meta);
    }

    private void sortedAdd(Map<String, TableMeta> nameToMeta, List<TableMeta> order, TableMeta meta) {
        if (order.contains(meta)) {
            return;
        }
        if (meta.getViewDef() != null) {
            this.sortedAdd(nameToMeta, order, meta.getViewDef());
        } else {
            ArrayList<IndexMeta> all = new ArrayList<IndexMeta>();
            all.add(meta.getPrimaryKey());
            all.addAll(meta.getFieldConstraint());
            all.addAll(meta.getIndexes());
            for (IndexMeta indexMeta : all) {
                if (indexMeta.refTable == null) continue;
                this.sortedAdd(nameToMeta, order, nameToMeta.get(indexMeta.refTable));
            }
            order.add(meta);
        }
    }

    public List<String> build(Map<String, TableMeta> nameToMeta) {
        ArrayList<String> sql = new ArrayList<String>();
        ArrayList<TableMeta> order = new ArrayList<TableMeta>();
        for (TableMeta meta : this.plan.keySet()) {
            this.sortedAdd(nameToMeta, order, meta);
        }
        for (TableMeta meta : order) {
            List<String>[] v = this.plan.get(meta);
            if (v == null) continue;
            for (int i = 0; i < v.length; ++i) {
                sql.addAll(v[i]);
            }
        }
        return sql;
    }
}

