/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.meta;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import top.onceio.core.db.annotation.Col;
import top.onceio.core.db.annotation.Index;
import top.onceio.core.db.annotation.IndexType;
import top.onceio.core.db.annotation.Tbl;
import top.onceio.core.db.annotation.TblType;
import top.onceio.core.db.meta.ColumnMeta;
import top.onceio.core.db.meta.IndexMeta;
import top.onceio.core.db.meta.SqlPlanBuilder;
import top.onceio.core.db.model.BaseTable;
import top.onceio.core.db.model.DefView;
import top.onceio.core.exception.VolidateFailed;
import top.onceio.core.util.OAssert;
import top.onceio.core.util.OReflectUtil;
import top.onceio.core.util.OUtils;

public class TableMeta {
    private static final Logger LOGGER = Logger.getLogger(TableMeta.class);
    String table;
    IndexMeta primaryKey;
    BaseTable viewDef;
    TblType type;
    transient List<IndexMeta> fieldConstraint = new ArrayList<IndexMeta>(0);
    List<IndexMeta> indexes = new ArrayList<IndexMeta>();
    List<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>(0);
    transient Map<String, ColumnMeta> nameToColumnMeta = new HashMap<String, ColumnMeta>();
    transient Class<?> entity;
    public static final Map<Class<?>, TableMeta> tableCache = new HashMap();

    public String name() {
        return this.table;
    }

    public static String getTableName(Class<?> clazz) {
        Tbl tbl;
        String defaultName = clazz.getSimpleName().replaceAll("([A-Z])", "_$1").toLowerCase();
        if (defaultName.startsWith("_")) {
            defaultName = defaultName.substring(1);
        }
        if ((tbl = clazz.getAnnotation(Tbl.class)) != null && !tbl.name().equals("")) {
            return tbl.name().toLowerCase().replace("public.", "");
        }
        return defaultName;
    }

    public static String getColumnName(Field field) {
        String defaultName = field.getName().replaceAll("([A-Z])", "_$1").toLowerCase();
        Col col = field.getAnnotation(Col.class);
        if (col != null && !"".equals(col.name())) {
            return col.name();
        }
        return defaultName;
    }

    public static TableMeta createBy(Class<?> entity) {
        TableMeta tm = new TableMeta();
        tm.entity = entity;
        Tbl tbl = entity.getAnnotation(Tbl.class);
        tm.table = TableMeta.getTableName(entity);
        tm.type = tbl.type();
        if (tbl.type().equals((Object)TblType.TABLE)) {
            ArrayList<IndexMeta> constraints = new ArrayList<IndexMeta>();
            for (Index index : tbl.indexes()) {
                IndexMeta cm = new IndexMeta();
                constraints.add(cm);
                cm.setColumns(Arrays.asList(index.columns()));
                cm.setTable(tm.getTable());
                if (index.unique()) {
                    cm.setType(IndexType.UNIQUE_INDEX);
                } else {
                    cm.setType(IndexType.INDEX);
                }
                cm.setUsing(index.using());
            }
            tm.setIndexes(constraints);
        } else if (DefView.class.isAssignableFrom(entity)) {
            try {
                DefView view = (DefView)entity.newInstance();
                tm.viewDef = view.def();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        ArrayList classes = new ArrayList();
        Class<?> clazz = entity;
        while (!clazz.equals(Object.class)) {
            classes.add(0, clazz);
            clazz = clazz.getSuperclass();
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        ArrayList<String> colOrder = new ArrayList<String>();
        for (Class clazz2 : classes) {
            for (Field field : clazz2.getDeclaredFields()) {
                int index;
                Col col = field.getAnnotation(Col.class);
                if (col == null) continue;
                ColumnMeta cm = new ColumnMeta();
                cm.setName(TableMeta.getColumnName(field));
                cm.setUnique(col.unique());
                cm.setUsing(col.using());
                cm.setDefaultValue(col.defaultValue());
                cm.setComment(col.comment());
                cm.setNullable(col.nullable());
                if (TableMeta.getColumnName(field).equals("id")) {
                    tm.setPrimaryKey("id");
                    cm.setPrimaryKey(true);
                    cm.setUnique(true);
                    cm.setNullable(false);
                }
                cm.setPattern(col.pattern());
                if (col.type().equals("")) {
                    Class<?> javaBaseType = cm.getJavaBaseType();
                    if (javaBaseType == null) {
                        if (field.getType() == Object.class) {
                            javaBaseType = OReflectUtil.searchGenType(clazz2, (Class)classes.get(classes.size() - 1), field.getGenericType());
                            cm.setJavaBaseType(javaBaseType);
                        } else {
                            javaBaseType = field.getType();
                            cm.setJavaBaseType(javaBaseType);
                        }
                    }
                    String type = TableMeta.transType(javaBaseType, col);
                    cm.setType(type);
                } else {
                    cm.setType(col.type().toLowerCase());
                }
                if (col.ref() != Void.TYPE) {
                    cm.setUseFK(col.useFK());
                    String table = TableMeta.getTableName(col.ref());
                    cm.setRefTable(table);
                }
                if ((index = colOrder.indexOf(cm.getName())) < 0) {
                    colOrder.add(cm.getName());
                    columnMetas.add(cm);
                    continue;
                }
                columnMetas.set(index, cm);
            }
        }
        tm.setColumnMetas(columnMetas);
        tm.freshNameToField(entity);
        tm.freshConstraintMetaTable();
        tableCache.put(entity, tm);
        return tm;
    }

    public static String transType(Class<?> type, Col col) {
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return "int8";
        }
        if (type.equals(String.class)) {
            return String.format("varchar(%d)", col.size());
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return "int4";
        }
        if (type.equals(BigDecimal.class)) {
            return String.format("numeric(%d,%d)", col.precision(), col.scale());
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return "bool";
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return "int2";
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return "float4";
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return "float8";
        }
        if (type.equals(Timestamp.class)) {
            return "timestamptz";
        }
        OAssert.fatal("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b:%s", type);
        return null;
    }

    public static Class<?> parseType(String udtName, int size, int i) {
        if (udtName.equals("bool")) {
            return Boolean.TYPE;
        }
        if (udtName.equals("int2")) {
            return Short.TYPE;
        }
        if (udtName.equals("int4")) {
            return Integer.TYPE;
        }
        if (udtName.equals("int8")) {
            return Long.TYPE;
        }
        if (udtName.equals("float4")) {
            return Float.TYPE;
        }
        if (udtName.equals("float8")) {
            return Double.TYPE;
        }
        if (udtName.equals("numeric")) {
            return BigDecimal.class;
        }
        if (udtName.equals("varchar")) {
            return String.class;
        }
        if (udtName.equals("text")) {
            return String.class;
        }
        if (udtName.equals("timestamptz") || udtName.equals("timestamp")) {
            return Timestamp.class;
        }
        if (udtName.equals("time") || udtName.equals("date")) {
            return Date.class;
        }
        return Object.class;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
        this.freshConstraintMetaTable();
    }

    public List<ColumnMeta> getColumnMetas() {
        return this.columnMetas;
    }

    public BaseTable getViewDef() {
        return this.viewDef;
    }

    public IndexMeta getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(IndexMeta primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        IndexMeta pk = new IndexMeta();
        pk.setTable(this.table);
        pk.setName(String.format("%s%s_%s", "pk_", pk.table.replace('.', '_'), primaryKey));
        pk.setColumns(Arrays.asList(primaryKey));
        pk.setType(IndexType.PRIMARY_KEY);
        pk.setUsing("BTREE");
        this.primaryKey = pk;
    }

    public List<IndexMeta> getFieldConstraint() {
        return this.fieldConstraint;
    }

    public void setFieldConstraint(List<IndexMeta> fieldConstraint) {
        this.fieldConstraint = fieldConstraint;
    }

    public List<IndexMeta> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<IndexMeta> indexes) {
        this.indexes = indexes;
    }

    public ColumnMeta getColumnMetaByName(String colName) {
        for (String name : this.nameToColumnMeta.keySet()) {
            if (!name.equalsIgnoreCase(colName)) continue;
            return this.nameToColumnMeta.get(name);
        }
        return null;
    }

    public void setColumnMetas(List<ColumnMeta> columnMetas) {
        this.columnMetas = columnMetas;
        this.nameToColumnMeta = new HashMap<String, ColumnMeta>(columnMetas.size());
        this.fieldConstraint = new ArrayList<IndexMeta>(columnMetas.size());
        for (ColumnMeta cm : columnMetas) {
            this.nameToColumnMeta.put(cm.name, cm);
        }
    }

    public void freshNameToField(Class<?> tblEntity) {
        ArrayList classes = new ArrayList();
        Class<?> clazz = tblEntity;
        while (!clazz.equals(Object.class)) {
            classes.add(0, clazz);
            clazz = clazz.getSuperclass();
        }
        HashSet<String> missed = new HashSet<String>(this.nameToColumnMeta.keySet());
        for (Class clazz2 : classes) {
            for (Field field : clazz2.getDeclaredFields()) {
                ColumnMeta cm = this.nameToColumnMeta.get(TableMeta.getColumnName(field));
                if (cm == null) continue;
                field.setAccessible(true);
                cm.setField(field);
                if (field.getType().equals(field.getGenericType())) {
                    cm.setJavaBaseType(field.getType());
                } else {
                    Class<?> jbt = OReflectUtil.searchGenType(clazz2, (Class)classes.get(classes.size() - 1), field.getGenericType());
                    cm.setJavaBaseType(jbt);
                }
                missed.remove(TableMeta.getColumnName(field));
            }
        }
        if (!missed.isEmpty()) {
            LOGGER.warn((Object)String.format("\u4ee5\u4e0b\u5b57\u6bb5\u6ca1\u6709\u52a0\u8f7d\u5230Field %s", OUtils.toJson(missed)));
        }
    }

    public void freshConstraintMetaTable() {
        if (this.columnMetas != null && !this.columnMetas.isEmpty()) {
            this.nameToColumnMeta.clear();
            this.fieldConstraint = new ArrayList<IndexMeta>(this.columnMetas.size());
            for (ColumnMeta cm : this.columnMetas) {
                ArrayList<String> cols;
                IndexMeta cnsMeta;
                if (cm.unique) {
                    cnsMeta = new IndexMeta();
                    cols = new ArrayList<String>();
                    cols.add(cm.getName());
                    cnsMeta.setColumns(new ArrayList<String>(cols));
                    cnsMeta.setTable(this.getTable());
                    cnsMeta.setName("un_" + cnsMeta.getTable() + "_" + cm.name);
                    cnsMeta.setUsing(cm.using);
                    cnsMeta.setType(IndexType.UNIQUE_FIELD);
                    this.fieldConstraint.add(cnsMeta);
                } else if (cm.useFK && cm.refTable != null) {
                    cnsMeta = new IndexMeta();
                    cols = new ArrayList();
                    cols.add(cm.getName());
                    cnsMeta.setColumns(new ArrayList<String>(cols));
                    cnsMeta.setTable(this.getTable());
                    cnsMeta.setName("fk_" + cnsMeta.getTable() + "_" + cm.name);
                    cnsMeta.setUsing(cm.using);
                    cnsMeta.setType(IndexType.FOREIGN_KEY);
                    cnsMeta.setRefTable(cm.refTable);
                    this.fieldConstraint.add(cnsMeta);
                }
                this.nameToColumnMeta.put(cm.getName(), cm);
            }
        }
    }

    private List<String> alterColumnSql(List<ColumnMeta> columnMetas) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (ColumnMeta ocm : columnMetas) {
            String sql = String.format("ALTER TABLE %s ALTER COLUMN %s TYPE %s", this.table, ocm.name, ocm.type);
            if (!ocm.nullable) {
                sql = sql + String.format(", ALTER COLUMN %s SET NOT NULL", ocm.name);
            }
            sql = sql + ";";
            sqls.add(sql);
        }
        return sqls;
    }

    private List<String> addColumnSql(List<ColumnMeta> columnMetas) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (ColumnMeta ocm : columnMetas) {
            String sql = String.format("ALTER TABLE %%s ADD COLUMN %s %s", this.table, ocm.name, ocm.type);
            if (!ocm.nullable) {
                sql = sql + String.format(" NOT NULL", new Object[0]);
            }
            if (ocm.defaultValue != null && !ocm.defaultValue.equals("")) {
                String dft = "";
                dft = ocm.getJavaBaseType().equals(String.class) ? " DEFAULT '" + ocm.defaultValue + "'" : " DEFAULT " + ocm.defaultValue;
                sql = sql + dft;
            }
            sql = sql + ";";
            sqls.add(sql);
        }
        return sqls;
    }

    public SqlPlanBuilder createTableSql() {
        SqlPlanBuilder planBuilder = new SqlPlanBuilder();
        StringBuffer tbl = new StringBuffer();
        ArrayList<String> comments = new ArrayList<String>();
        if (this.viewDef == null) {
            tbl.append(String.format("CREATE TABLE %s (", this.table));
            for (ColumnMeta cm : this.columnMetas) {
                String dft = "";
                if (cm.defaultValue != null && !cm.defaultValue.equals("")) {
                    dft = cm.getJavaBaseType().equals(String.class) ? " DEFAULT '" + cm.defaultValue + "'" : " DEFAULT " + cm.defaultValue;
                }
                tbl.append(String.format("%s %s%s%s,", cm.name, cm.type, cm.nullable ? "" : " NOT NULL", dft));
                if (cm.comment == null || cm.comment.equals("")) continue;
                comments.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s';", this.table, cm.name, cm.comment));
            }
            tbl.delete(tbl.length() - 1, tbl.length());
            tbl.append(");");
            planBuilder.append(SqlPlanBuilder.CREATE, this, tbl.toString());
            if (this.primaryKey != null) {
                planBuilder.append(SqlPlanBuilder.ALTER, this, this.primaryKey.addSql());
            }
            planBuilder.append(SqlPlanBuilder.ALTER, this, IndexMeta.addConstraintSql(this.fieldConstraint));
            planBuilder.append(SqlPlanBuilder.ALTER, this, IndexMeta.addConstraintSql(this.indexes));
            planBuilder.append(SqlPlanBuilder.COMMENT, this, comments);
        } else {
            planBuilder.append(SqlPlanBuilder.DROP, this, String.format("DROP VIEW IF EXISTS %s;", this.table));
            tbl.append(String.format("CREATE VIEW %s AS (", this.table));
            tbl.append(this.viewDef.toSql());
            tbl.append(");");
            planBuilder.append(SqlPlanBuilder.CREATE, this, tbl.toString());
        }
        return planBuilder;
    }

    public SqlPlanBuilder upgradeTo(TableMeta other) {
        if (!this.table.equals(other.table)) {
            return null;
        }
        if (this.viewDef == null) {
            return this.upgradeTableTo(other);
        }
        SqlPlanBuilder planBuilder = new SqlPlanBuilder();
        planBuilder.append(SqlPlanBuilder.DROP, other, String.format("DROP VIEW IF EXISTS %s;", this.table));
        StringBuffer tbl = new StringBuffer();
        tbl.append(String.format("CREATE VIEW %s AS (", this.table));
        tbl.append(this.viewDef);
        tbl.append(");");
        planBuilder.append(SqlPlanBuilder.CREATE, other, tbl.toString());
        return planBuilder;
    }

    public SqlPlanBuilder upgradeTableTo(TableMeta other) {
        ArrayList<String> comments = new ArrayList<String>();
        List<ColumnMeta> otherColumn = other.columnMetas;
        ArrayList<ColumnMeta> newColumns = new ArrayList<ColumnMeta>();
        ArrayList<IndexMeta> dropIndexs = new ArrayList<IndexMeta>();
        ArrayList<IndexMeta> dropForeignKeys = new ArrayList<IndexMeta>();
        ArrayList<ColumnMeta> alterColumns = new ArrayList<ColumnMeta>();
        ArrayList<IndexMeta> addForeignKeys = new ArrayList<IndexMeta>();
        for (ColumnMeta ocm : otherColumn) {
            ColumnMeta cm = this.nameToColumnMeta.get(ocm.name);
            if (cm == null) {
                newColumns.add(ocm);
                if (ocm.comment == null || ocm.comment.equals("")) continue;
                comments.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s';", this.table, ocm.name, ocm.comment));
                continue;
            }
            if (cm.unique && !ocm.unique) {
                IndexMeta indexMeta = new IndexMeta();
                indexMeta.setColumns(Arrays.asList(ocm.getName()));
                indexMeta.setTable(this.table);
                indexMeta.setType(IndexType.UNIQUE_FIELD);
                indexMeta.setUsing(ocm.getUsing());
                dropIndexs.add(indexMeta);
            }
            if (cm.useFK && !ocm.useFK) {
                IndexMeta indexMeta = new IndexMeta();
                indexMeta.setColumns(Arrays.asList(cm.getName()));
                indexMeta.setTable(this.table);
                indexMeta.setType(IndexType.FOREIGN_KEY);
                indexMeta.setRefTable(cm.getRefTable());
                indexMeta.setUsing(cm.getUsing());
                dropForeignKeys.add(indexMeta);
            }
            if (!Objects.equals(cm.type, ocm.type) || !Objects.equals(cm.defaultValue, ocm.defaultValue) || cm.nullable != ocm.nullable) {
                alterColumns.add(ocm);
            }
            if (!cm.useFK && ocm.useFK && ocm.useFK && ocm.refTable != null) {
                IndexMeta indexMeta = new IndexMeta();
                indexMeta.setColumns(Arrays.asList(cm.getName()));
                indexMeta.setTable(this.table);
                indexMeta.setType(IndexType.FOREIGN_KEY);
                indexMeta.setRefTable(ocm.getRefTable());
                indexMeta.setUsing(ocm.getUsing());
                addForeignKeys.add(indexMeta);
            }
            if (Objects.equals(cm.comment, ocm.comment) || ocm.comment == null || ocm.comment.equals("")) continue;
            comments.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s';", this.table, ocm.name, ocm.comment));
        }
        HashSet<String> oldConstraintSet = new HashSet<String>();
        HashSet<String> currentSet = new HashSet<String>();
        for (IndexMeta indexMeta : this.fieldConstraint) {
            oldConstraintSet.add(String.join((CharSequence)",", indexMeta.columns));
        }
        ArrayList<IndexMeta> addUniqueConstraint = new ArrayList<IndexMeta>();
        for (IndexMeta indexMeta : other.fieldConstraint) {
            currentSet.add(String.join((CharSequence)",", indexMeta.columns));
            if (oldConstraintSet.contains(String.join((CharSequence)",", indexMeta.columns))) continue;
            addUniqueConstraint.add(indexMeta);
        }
        ArrayList<IndexMeta> arrayList = new ArrayList<IndexMeta>();
        for (IndexMeta indexMeta : this.fieldConstraint) {
            if (currentSet.contains(String.join((CharSequence)",", indexMeta.columns))) continue;
            arrayList.add(indexMeta);
        }
        oldConstraintSet.clear();
        currentSet.clear();
        for (IndexMeta indexMeta : this.indexes) {
            oldConstraintSet.add(String.join((CharSequence)",", indexMeta.columns));
        }
        ArrayList<IndexMeta> arrayList2 = new ArrayList<IndexMeta>();
        for (IndexMeta indexMeta : other.indexes) {
            currentSet.add(String.join((CharSequence)",", indexMeta.columns));
            if (oldConstraintSet.contains(String.join((CharSequence)",", indexMeta.columns))) continue;
            arrayList2.add(indexMeta);
        }
        ArrayList<IndexMeta> arrayList3 = new ArrayList<IndexMeta>();
        for (IndexMeta tuple : this.indexes) {
            if (currentSet.contains(String.join((CharSequence)",", tuple.columns))) continue;
            arrayList3.add(tuple);
        }
        SqlPlanBuilder sqlPlanBuilder = new SqlPlanBuilder();
        if (this.primaryKey != null && !this.primaryKey.equals(other.primaryKey)) {
            sqlPlanBuilder.append(SqlPlanBuilder.DROP, other, this.primaryKey.dropSql());
        }
        if (other.primaryKey != null && !other.primaryKey.equals(this.primaryKey)) {
            sqlPlanBuilder.append(SqlPlanBuilder.ALTER, other, other.primaryKey.addSql());
        }
        sqlPlanBuilder.append(SqlPlanBuilder.ALTER, other, this.addColumnSql(newColumns));
        sqlPlanBuilder.append(SqlPlanBuilder.DROP, other, IndexMeta.dropConstraintSql(dropIndexs));
        sqlPlanBuilder.append(SqlPlanBuilder.DROP, other, IndexMeta.dropConstraintSql(dropForeignKeys));
        sqlPlanBuilder.append(SqlPlanBuilder.ALTER, other, this.alterColumnSql(alterColumns));
        sqlPlanBuilder.append(SqlPlanBuilder.ALTER, other, IndexMeta.addConstraintSql(addForeignKeys));
        sqlPlanBuilder.append(SqlPlanBuilder.DROP, other, IndexMeta.dropConstraintSql(arrayList));
        sqlPlanBuilder.append(SqlPlanBuilder.ALTER, other, IndexMeta.addConstraintSql(addUniqueConstraint));
        sqlPlanBuilder.append(SqlPlanBuilder.DROP, other, IndexMeta.dropConstraintSql(arrayList3));
        sqlPlanBuilder.append(SqlPlanBuilder.ALTER, other, IndexMeta.addConstraintSql(arrayList2));
        return sqlPlanBuilder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableMeta tableMeta = (TableMeta)o;
        return Objects.equals(this.table, tableMeta.table) && Objects.equals(this.primaryKey, tableMeta.primaryKey) && Objects.equals(this.viewDef, tableMeta.viewDef) && Objects.equals(this.indexes, tableMeta.indexes) && Objects.equals(this.columnMetas, tableMeta.columnMetas) && Objects.equals(this.nameToColumnMeta, tableMeta.nameToColumnMeta);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.primaryKey, this.viewDef, this.indexes, this.columnMetas, this.nameToColumnMeta);
    }

    public void validate(Object obj, boolean ignoreNull) {
        for (ColumnMeta cm : this.getColumnMetas()) {
            VolidateFailed vf;
            if (cm.getName().equals("id") || cm.getName().equals("rm")) continue;
            Object val = null;
            try {
                val = cm.getField().get(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
            if (!cm.isNullable() && val == null && !ignoreNull) {
                vf = VolidateFailed.createError("%s cannot be null", cm.getName());
                vf.put(cm.getName(), "cannot be null");
                vf.throwSelf();
                continue;
            }
            if (val == null || cm.getPattern().equals("") || !val.toString().matches(cm.getPattern())) continue;
            vf = VolidateFailed.createError("%s does not matches %s", cm.getName(), cm.getPattern());
            vf.put(cm.getName(), cm.getPattern());
            vf.throwSelf();
        }
    }

    public TblType getType() {
        return this.type;
    }
}

