/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.model;

import java.lang.reflect.Field;
import top.onceio.core.db.meta.TableMeta;
import top.onceio.core.db.model.BaseTable;
import top.onceio.core.db.model.Queryable;

public class BaseCol<T extends BaseTable>
implements Queryable {
    T table;
    public String name;
    private Field field;

    public BaseCol(T table, Field field) {
        this.table = table;
        this.name = TableMeta.getColumnName(field);
        this.field = field;
    }

    @Override
    public String name() {
        return ((BaseTable)this.table).alias + "." + this.name;
    }

    public T eq(Object val) {
        ((BaseTable)this.table).where.append(" " + this.name() + " = ?");
        ((BaseTable)this.table).args.add(val);
        return this.table;
    }

    public T ne(Object val) {
        ((BaseTable)this.table).where.append(" " + this.name() + " != ?");
        ((BaseTable)this.table).args.add(val);
        return this.table;
    }

    public T gt(Object val) {
        ((BaseTable)this.table).where.append(" " + this.name() + " > ?");
        ((BaseTable)this.table).args.add(val);
        return this.table;
    }

    public T ge(Object val) {
        ((BaseTable)this.table).where.append(" " + this.name() + " >= ?");
        ((BaseTable)this.table).args.add(val);
        return this.table;
    }

    public T lt(Object val) {
        ((BaseTable)this.table).where.append(" " + this.name() + " < ?");
        ((BaseTable)this.table).args.add(val);
        return this.table;
    }

    public T le(Object val) {
        ((BaseTable)this.table).where.append(" " + this.name() + " <= ?");
        ((BaseTable)this.table).args.add(val);
        return this.table;
    }

    public T in(Object ... vals) {
        ((BaseTable)this.table).where.append(" " + this.name() + " IN (");
        for (Object val : vals) {
            ((BaseTable)this.table).where.append("?,");
            ((BaseTable)this.table).args.add(val);
        }
        ((BaseTable)this.table).where.deleteCharAt(((BaseTable)this.table).where.length() - 1);
        ((BaseTable)this.table).where.append(")");
        return this.table;
    }

    public T in(BaseTable sub) {
        ((BaseTable)this.table).where.append(" " + this.name() + " IN (");
        ((BaseTable)this.table).where.append(sub.toString());
        ((BaseTable)this.table).args.addAll(sub.args);
        ((BaseTable)this.table).where.append(")");
        ((BaseTable)this.table).refs.add(sub);
        return this.table;
    }

    public T notIn(Object ... vals) {
        ((BaseTable)this.table).where.append(" " + this.name() + " NOT IN (");
        for (Object val : vals) {
            ((BaseTable)this.table).where.append("?,");
            ((BaseTable)this.table).args.add(val);
        }
        ((BaseTable)this.table).where.deleteCharAt(((BaseTable)this.table).where.length() - 1);
        ((BaseTable)this.table).where.append(")");
        return this.table;
    }

    public T notIn(BaseTable sub) {
        ((BaseTable)this.table).where.append(" " + this.name() + " NOT IN (");
        ((BaseTable)this.table).where.append(sub.toString());
        ((BaseTable)this.table).args.addAll(sub.args);
        ((BaseTable)this.table).where.append(")");
        ((BaseTable)this.table).refs.add(sub);
        return this.table;
    }

    public T set(Object val) {
        ((BaseTable)this.table).update.append(" " + this.name + " = ?,");
        ((BaseTable)this.table).args.add(val);
        return this.table;
    }

    public T setExp(String val) {
        ((BaseTable)this.table).update.append(String.format(" %s = %s + (%s),", this.name, this.name, val));
        return this.table;
    }
}

