/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.model;

import java.util.ArrayList;
import java.util.List;
import top.onceio.core.db.model.BaseCol;
import top.onceio.core.db.model.Queryable;
import top.onceio.core.util.OReflectUtil;

public class BaseTable<M> {
    protected M meta;
    protected String name;
    protected String alias;
    protected List<Object> args = new ArrayList<Object>();
    StringBuilder select = new StringBuilder();
    StringBuilder from = new StringBuilder();
    StringBuilder where = new StringBuilder();
    private StringBuilder group = new StringBuilder();
    private StringBuilder having = new StringBuilder();
    private StringBuilder limit = new StringBuilder();
    private StringBuilder order = new StringBuilder();
    StringBuilder update = new StringBuilder();
    List<BaseTable<?>> refs = new ArrayList();
    public BaseCol<?> id;

    protected <E> void bind(String name, M meta, Class<E> e) {
        this.alias = "t";
        this.name = name;
        this.meta = meta;
        this.id = new BaseCol<BaseTable>(this, OReflectUtil.getField(e, "id"));
    }

    public String getName() {
        return this.name;
    }

    public M alias(String alias) {
        this.alias = alias;
        return this.meta;
    }

    public List<Object> getArgs() {
        return this.args;
    }

    public M select(Queryable ... cs) {
        if (cs.length > 0) {
            for (Queryable c : cs) {
                this.select.append(" " + c.name() + ",");
            }
            this.select.deleteCharAt(this.select.length() - 1);
        } else {
            this.select.append(" *");
        }
        return this.meta;
    }

    public <O extends BaseTable> M from(O ... tables) {
        if (tables.length == 0) {
            this.from.append(" " + this.name + " as " + this.alias);
        } else {
            for (O t : tables) {
                this.from.append(" " + ((BaseTable)t).name + " AS " + ((BaseTable)t).alias + ",");
                this.refs.add((BaseTable<?>)t);
            }
            this.from.deleteCharAt(this.from.length() - 1);
        }
        return this.meta;
    }

    public M join(BaseTable otherTable) {
        this.from.append(" LEFT JOIN " + otherTable.name + " AS " + otherTable.alias);
        this.refs.add(otherTable);
        return this.meta;
    }

    public M on(BaseCol ac, BaseCol bc) {
        this.from.append(String.format(" ON %s.%s = %s.%s", ((BaseTable)ac.table).alias, ac.name, ((BaseTable)bc.table).alias, bc.name));
        return this.meta;
    }

    public M where() {
        return this.meta;
    }

    public <C extends BaseCol> M groupBy(C ... cs) {
        for (C c : cs) {
            this.group.append(String.format(" %s.%s,", ((BaseTable)((BaseCol)c).table).alias, ((BaseCol)c).name));
        }
        this.group.deleteCharAt(this.group.length() - 1);
        return this.meta;
    }

    public <C extends BaseCol> M orderBy(C ... cs) {
        for (C c : cs) {
            this.order.append(String.format(" %s.%s,", ((BaseTable)((BaseCol)c).table).alias, ((BaseCol)c).name));
        }
        this.order.deleteCharAt(this.order.length() - 1);
        return this.meta;
    }

    public <C extends BaseCol> M orderByDesc(C ... cs) {
        for (C c : cs) {
            this.order.append(String.format(" %s.%s desc,", ((BaseTable)((BaseCol)c).table).alias, ((BaseCol)c).name));
        }
        this.order.deleteCharAt(this.order.length() - 1);
        return this.meta;
    }

    public M limit(int s, int e) {
        this.limit.append(String.format(" %d OFFSET %d", s, e));
        return this.meta;
    }

    public M as(String alias) {
        this.alias = alias;
        return this.meta;
    }

    public M and() {
        this.where.append(" AND ");
        return this.meta;
    }

    public M or() {
        this.where.append(" OR ");
        return this.meta;
    }

    public M and(BaseTable meta) {
        this.where.append(" AND (" + meta.where + ")");
        this.args.addAll(meta.args);
        this.refs.add(meta);
        return this.meta;
    }

    public M or(BaseTable meta) {
        this.where.append(" OR (" + meta.where + ")");
        this.args.addAll(meta.args);
        this.refs.add(meta);
        return this.meta;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        if (this.select.length() > 0) {
            sql.append("SELECT" + this.select);
            if (this.from.length() > 0) {
                sql.append(" FROM" + this.from);
            }
        }
        if (this.update.length() > 0) {
            if (this.from.length() <= 0) {
                sql.append("UPDATE " + this.name + " as " + this.alias);
            } else {
                sql.append("UPDATE" + this.from);
            }
            sql.append(" SET" + this.update);
            sql.deleteCharAt(sql.length() - 1);
        }
        if (this.where.length() > 0) {
            sql.append(" WHERE" + this.where);
        }
        if (this.group.length() > 0) {
            sql.append(" GROUP BY" + this.group);
        }
        if (this.having.length() > 0) {
            sql.append(" HAVING" + this.having);
        }
        if (this.order.length() > 0) {
            sql.append(" ORDER BY" + this.order);
        }
        if (this.limit.length() > 0) {
            sql.append(" LIMIT " + this.limit);
        }
        return sql.toString();
    }

    public String toSql() {
        StringBuilder sql = new StringBuilder(this.toString());
        int start = 0;
        for (int i = 0; i < this.args.size(); ++i) {
            Object val = this.args.get(i);
            int index = sql.indexOf("?", start);
            sql.deleteCharAt(index);
            String str = val != null ? val.toString() : "NULL";
            start = index + str.length();
            if (val instanceof Number) {
                sql.insert(index, str);
                continue;
            }
            sql.insert(index, "'" + str + "'");
        }
        return sql.toString();
    }

    public List<BaseTable<?>> getRefs() {
        return this.refs;
    }

    public BaseTable<M> copy() {
        BaseTable<M> other = new BaseTable<M>();
        other.name = this.name;
        other.meta = this.meta;
        other.select.append((CharSequence)this.select);
        other.from.append((CharSequence)this.from);
        other.where.append((CharSequence)this.where);
        other.group.append((CharSequence)this.group);
        other.having.append((CharSequence)this.having);
        other.order.append((CharSequence)this.order);
        other.limit.append((CharSequence)this.limit);
        other.args.addAll(this.args);
        return other;
    }
}

