/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import top.onceio.core.db.annotation.IndexType;
import top.onceio.core.db.annotation.TblType;
import top.onceio.core.db.dao.DDLDao;
import top.onceio.core.db.dao.IdGenerator;
import top.onceio.core.db.dao.Page;
import top.onceio.core.db.dao.TransDao;
import top.onceio.core.db.jdbc.JdbcHelper;
import top.onceio.core.db.meta.ColumnMeta;
import top.onceio.core.db.meta.IndexMeta;
import top.onceio.core.db.meta.SqlPlanBuilder;
import top.onceio.core.db.meta.TableMeta;
import top.onceio.core.db.model.BaseTable;
import top.onceio.core.db.model.Queryable;
import top.onceio.core.db.tbl.BaseEntity;
import top.onceio.core.exception.Failed;
import top.onceio.core.util.OAssert;
import top.onceio.core.util.OLog;
import top.onceio.core.util.OReflectUtil;
import top.onceio.core.util.OUtils;

public class DaoHelper
implements DDLDao,
TransDao {
    private static final Logger LOGGER = Logger.getLogger(DaoHelper.class);
    private JdbcHelper jdbcHelper;
    private Map<Class<?>, TableMeta> classToTableMeta;
    private Map<String, TableMeta> nameToMeta;
    private IdGenerator idGenerator;
    private List<Class<? extends BaseEntity>> entities;

    public DaoHelper() {
    }

    public DaoHelper(JdbcHelper jdbcHelper, IdGenerator idGenerator, List<Class<? extends BaseEntity>> entitys) {
        this.init(jdbcHelper, idGenerator, entitys);
    }

    public boolean exist(Class<?> tbl) {
        Long cnt = 0L;
        try {
            cnt = (Long)this.jdbcHelper.queryForObject(String.format("SELECT count(*) FROM %s", TableMeta.getTableName(tbl)));
        }
        catch (Failed e) {
            cnt = -1L;
        }
        return cnt != null && cnt >= 0L;
    }

    private Map<String, TableMeta> findPGTableMeta(JdbcHelper jdbcHelper, Collection<String> tables) {
        HashMap<String, TableMeta> result = new HashMap<String, TableMeta>();
        if (tables.isEmpty()) {
            return result;
        }
        ArrayList<String> schemaTables = new ArrayList<String>();
        for (String table : tables) {
            if (!table.contains(".")) {
                schemaTables.add("public." + table);
                continue;
            }
            schemaTables.add(table);
        }
        String qColumns = "select\nns.nspname as schemaname,\nc.relname as tablename,\na.attnum,\na.attname AS field,\nt.typname AS type,\nisc.character_maximum_length max_length,\nisc.numeric_precision,\nisc.numeric_scale,\nisc.column_default,\nisc.is_nullable = 'YES' as nullable,\nb.description AS comment,\npk.conname pk_conname,\nuk.conname uk_conname,\nfk.conname fk_conname,\nfc.relname f_tablename,\nfns.nspname f_schemaname\nfrom pg_attribute a \nleft join pg_type t on a.atttypid = t.oid\nleft join pg_class c on a.attrelid = c.oid\nleft join pg_namespace ns on ns.oid = c.relnamespace\nleft join pg_description b ON a.attrelid=b.objoid AND a.attnum = b.objsubid\nleft join pg_constraint pk on pk.conrelid = c.oid and pk.contype='p' and a.attnum = pk.conkey[1]\nleft join pg_constraint uk on uk.conrelid = c.oid and uk.contype='u' and a.attnum = uk.conkey[1]\nleft join pg_constraint fk on fk.conrelid = c.oid and fk.contype='f' and a.attnum = fk.conkey[1] \nleft join pg_class fc on fk.confrelid = fc.oid\nleft join pg_namespace fns on fns.oid = fc.relnamespace\nleft join information_schema.columns isc on isc.table_schema = ns.nspname and isc.table_name = c.relname and isc.column_name =  a.attname\nWHERE a.attnum > 0\nand a.attrelid = c.oid\nand a.atttypid = t.oid\nand ns.oid = c.relnamespace\nand concat(ns.nspname,'.',c.relname) IN " + String.format("(%s)\n", OUtils.genStub("?", ",", schemaTables.size()), String.join((CharSequence)"','", new CharSequence[0])) + "ORDER BY ns.nspname,c.relname,a.attnum";
        HashMap<String, Map> tableToColumns = new HashMap<String, Map>();
        jdbcHelper.query(qColumns, schemaTables.toArray(), rs -> {
            try {
                String schemaTable;
                HashMap<String, ColumnMeta> columnMetaList;
                String schema = rs.getString("schemaname");
                String table = rs.getString("tablename");
                int varcharMaxLen = rs.getInt("max_length");
                int numericPrecision = rs.getInt("numeric_precision");
                int numericScale = rs.getInt("numeric_scale");
                String comment = rs.getString("comment");
                String column_default = rs.getString("column_default");
                boolean nullable = rs.getBoolean("nullable");
                String field = rs.getString("field");
                String typename = rs.getString("type");
                String pk_conname = rs.getString("pk_conname");
                String uk_conname = rs.getString("uk_conname");
                String fk_conname = rs.getString("fk_conname");
                String refTable = null;
                if (fk_conname != null) {
                    refTable = rs.getString("f_schemaname") + "." + rs.getString("f_tablename");
                }
                if ((columnMetaList = (HashMap<String, ColumnMeta>)tableToColumns.get(schemaTable = (schema + "." + table).toLowerCase().replace("public.", ""))) == null) {
                    columnMetaList = new HashMap<String, ColumnMeta>();
                    tableToColumns.put(schemaTable, columnMetaList);
                }
                ColumnMeta cm = new ColumnMeta();
                cm.setName(field);
                cm.setNullable(nullable);
                cm.setUnique(uk_conname != null);
                if (pk_conname != null) {
                    cm.setPrimaryKey(true);
                    cm.setUnique(true);
                    cm.setNullable(false);
                }
                cm.setUseFK(fk_conname != null);
                cm.setRefTable(refTable);
                cm.setType(typename.toLowerCase());
                cm.setUsing("");
                cm.setPattern("");
                Class<?> javaBaseType = TableMeta.parseType(typename, varcharMaxLen, 0);
                if (typename.equals("varchar")) {
                    cm.setType(String.format("varchar(%d)", varcharMaxLen));
                } else if (typename.equals("numeric")) {
                    cm.setType(String.format("numeric(%d,%d)", numericPrecision, numericScale));
                }
                cm.setJavaBaseType(javaBaseType);
                cm.setDefaultValue(column_default != null ? column_default : "");
                cm.setComment(comment != null ? comment : "");
                columnMetaList.put(cm.getName(), cm);
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage());
            }
        });
        HashMap tableToConstraintMeta = new HashMap();
        String qIndexes = "select * from pg_indexes i\nwhere i.indexname like ? and concat(i.schemaname,'.',i.tablename) IN " + String.format("(%s)", OUtils.genStub("?", ",", schemaTables.size()), String.join((CharSequence)"','", new CharSequence[0])) + " ORDER BY i.schemaname,i.tablename";
        ArrayList<String> args = new ArrayList<String>(schemaTables.size() + 1);
        args.add("nq_%");
        args.addAll(schemaTables);
        jdbcHelper.query(qIndexes, args.toArray(), rs -> {
            try {
                String schema = rs.getString("schemaname");
                String table = rs.getString("tablename");
                String indexname = rs.getString("indexname");
                String indexDef = rs.getString("indexdef");
                String schemaTable = (schema + "." + table).toLowerCase().replace("public.", "");
                Map nameToColumnMeta = (Map)tableToColumns.get(schemaTable);
                String col = indexDef.substring(indexDef.lastIndexOf(40) + 1, indexDef.lastIndexOf(41));
                if (col.contains(",") && indexname.startsWith("nq_")) {
                    IndexMeta constraintMeta = new IndexMeta();
                    ArrayList<String> columns = new ArrayList<String>();
                    for (String c : col.split(",")) {
                        columns.add(c.trim());
                    }
                    constraintMeta.setColumns(columns);
                    constraintMeta.setTable(table);
                    if (indexDef.toUpperCase().contains(" UNIQUE ")) {
                        constraintMeta.setType(IndexType.UNIQUE_FIELD);
                    } else {
                        constraintMeta.setType(IndexType.INDEX);
                    }
                    constraintMeta.setUsing(indexDef.replaceAll("^.* USING ([^( ]+).*$", "$1").trim());
                    ArrayList<IndexMeta> constraintMetas = (ArrayList<IndexMeta>)tableToConstraintMeta.get(schema);
                    if (constraintMetas == null) {
                        constraintMetas = new ArrayList<IndexMeta>();
                        tableToConstraintMeta.put(schemaTable, constraintMetas);
                    }
                    constraintMetas.add(constraintMeta);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage());
            }
        });
        tableToColumns.forEach((schemaTable, columnNameToCol) -> {
            List constraints = tableToConstraintMeta.getOrDefault(schemaTable, new ArrayList());
            String table = schemaTable;
            TableMeta tm = new TableMeta();
            tm.setTable(table);
            tm.setColumnMetas(new ArrayList<ColumnMeta>(columnNameToCol.values()));
            tm.setIndexes(constraints);
            tm.setPrimaryKey("id");
            tm.freshConstraintMetaTable();
            result.put(schemaTable.toLowerCase().replace("public.", ""), tm);
        });
        return result;
    }

    private Map<String, TableMeta> findTableMeta(JdbcHelper jdbcHelper, Collection<String> schemaTables) {
        switch (jdbcHelper.getDBType()) {
            case POSTGRESQL: {
                return this.findPGTableMeta(jdbcHelper, schemaTables);
            }
        }
        OAssert.err("\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b\uff1a%s", new Object[]{jdbcHelper.getDBType()});
        return new HashMap<String, TableMeta>();
    }

    public void init(JdbcHelper jdbcHelper, IdGenerator idGenerator, List<Class<? extends BaseEntity>> entities) {
        this.jdbcHelper = jdbcHelper;
        this.idGenerator = idGenerator;
        this.classToTableMeta = new HashMap();
        this.nameToMeta = new HashMap<String, TableMeta>();
        if (entities != null) {
            this.entities = entities;
            for (Class<? extends BaseEntity> tbl : entities) {
                TableMeta tm = TableMeta.createBy(tbl);
                tm.freshNameToField(tbl);
                tm.freshConstraintMetaTable();
                this.classToTableMeta.put(tbl, tm);
                this.nameToMeta.put(tm.getTable(), tm);
            }
        }
        Map<String, TableMeta> oldTableMeta = this.findTableMeta(jdbcHelper, this.nameToMeta.keySet());
        SqlPlanBuilder planBuilder = new SqlPlanBuilder();
        for (Class clazz : this.classToTableMeta.keySet()) {
            TableMeta tm = this.classToTableMeta.get(clazz);
            String schemaTable = tm.getTable();
            TableMeta old = oldTableMeta.get(schemaTable);
            if (old == null) {
                planBuilder.append(tm.createTableSql());
                continue;
            }
            if (old.equals(tm)) continue;
            planBuilder.append(old.upgradeTo(tm));
        }
        List<String> sqlList = planBuilder.build(this.nameToMeta);
        if (!sqlList.isEmpty()) {
            jdbcHelper.batchExec(sqlList.toArray(new String[0]));
        }
    }

    public List<Class<? extends BaseEntity>> getEntities() {
        return this.entities;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public JdbcHelper getJdbcHelper() {
        return this.jdbcHelper;
    }

    public void setJdbcHelper(JdbcHelper jdbcHelper) {
        this.jdbcHelper = jdbcHelper;
    }

    public Map<Class<?>, TableMeta> getTableToTableMata() {
        return this.classToTableMeta;
    }

    public void setTableToTableMata(Map<Class<?>, TableMeta> tableToTableMeta) {
        this.classToTableMeta = tableToTableMeta;
    }

    @Override
    public <E extends BaseEntity> boolean drop(Class<E> tbl) {
        TableMeta tm = this.classToTableMeta.get(tbl);
        if (tm == null) {
            return false;
        }
        String sql = String.format("DROP TABLE IF EXISTS %s;", TableMeta.getTableName(tbl));
        this.jdbcHelper.batchUpdate(sql);
        return true;
    }

    @Override
    public int[] batchUpdate(String ... sql) {
        return this.jdbcHelper.batchExec(sql);
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> batchArgs) {
        return this.jdbcHelper.batchUpdate(sql, batchArgs);
    }

    private static <E extends BaseEntity, M extends BaseTable> E createBy(Class<E> tbl, TableMeta tm, ResultSet rs) throws SQLException {
        BaseEntity row = null;
        try {
            row = (BaseEntity)tbl.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            OAssert.warnning("%s InstantiationException", tbl);
        }
        if (row != null) {
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String colName = rsmd.getColumnName(i);
                ColumnMeta cm = tm.getColumnMetaByName(colName);
                if (cm == null) continue;
                try {
                    Object val = rs.getObject(colName);
                    if (val != null && !val.getClass().equals(cm.getJavaBaseType())) {
                        Object fieldVal = OReflectUtil.strToBaseType(cm.getField().getType(), val.toString());
                        cm.getField().set(row, fieldVal);
                        continue;
                    }
                    cm.getField().set(row, val);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    OLog.error(e.getMessage(), new Object[0]);
                }
            }
            return (E)row;
        }
        return (E)row;
    }

    @Override
    public List<Object[]> call(String sql, Object[] args) {
        return this.jdbcHelper.call(sql, args);
    }

    @Override
    public void beginTransaction(int level, boolean readOnly) {
        this.jdbcHelper.beginTransaction(level, readOnly);
    }

    @Override
    public Savepoint setSavepoint() {
        return this.jdbcHelper.setSavepoint();
    }

    @Override
    public void rollback() {
        this.jdbcHelper.rollback();
    }

    @Override
    public void rollback(Savepoint sp) {
        this.jdbcHelper.rollback(sp);
    }

    @Override
    public void commit() {
        this.jdbcHelper.commit();
    }

    public <E extends BaseEntity, M extends BaseTable> E get(Class<E> tbl, Long id) {
        TableMeta tm = this.classToTableMeta.get(tbl);
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", TableMeta.getTableName(tbl));
        String sql = String.format("SELECT * FROM %s WHERE id = ?", tm.getTable());
        ArrayList rows = new ArrayList(1);
        this.jdbcHelper.query(sql, new Object[]{id}, rs -> {
            Object row = null;
            try {
                row = DaoHelper.createBy(tbl, tm, rs);
            }
            catch (SQLException e) {
                Failed.throwError(e.getMessage(), new Object[0]);
            }
            finally {
                rows.add(row);
            }
        });
        return (E)((BaseEntity)rows.get(0));
    }

    public <E extends BaseEntity, M extends BaseTable> E insert(E entity) {
        this.batchInsert(Arrays.asList(entity));
        return entity;
    }

    public <E extends BaseEntity, M extends BaseTable> int batchInsert(List<E> entities) {
        if (entities == null || entities.isEmpty()) {
            return 0;
        }
        Class<?> tbl = ((BaseEntity)entities.get(0)).getClass();
        TableMeta tm = this.classToTableMeta.get(tbl);
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", TableMeta.getTableName(tbl));
        ArrayList<String> names = new ArrayList<String>();
        for (ColumnMeta columnMeta : tm.getColumnMetas()) {
            names.add(columnMeta.getName());
        }
        ArrayList<Object[]> valArray = new ArrayList<Object[]>();
        for (BaseEntity entity : entities) {
            tm.validate(entity, false);
            Object[] val = this.initEntity(tm, names, entity);
            valArray.add(val);
        }
        String string = OUtils.genStub("?", ",", names.size());
        String sql = String.format("INSERT INTO %s(%s) VALUES(%s);", tm.getTable(), String.join((CharSequence)",", names), string);
        int[] cntArray = this.jdbcHelper.batchUpdate(sql, valArray);
        int cnt = 0;
        for (int c : cntArray) {
            cnt += c;
        }
        return cnt;
    }

    private <E extends BaseEntity> Object[] initEntity(TableMeta tm, List<String> names, E entity) {
        if (entity.getId() == null) {
            Long id = this.idGenerator.next(entity.getClass());
            entity.setId(id);
        }
        Object[] val = new Object[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            try {
                Object v;
                val[i] = v = tm.getColumnMetaByName(name).getField().get(entity);
                continue;
            }
            catch (IllegalAccessException e) {
                OLog.error(e.getMessage(), new Object[0]);
            }
        }
        return val;
    }

    private <E extends BaseEntity, M extends BaseTable> int update(E entity, boolean ignoreNull) {
        OAssert.warnning(entity != null, "\u4e0d\u53ef\u4ee5\u63d2\u5165null", new Object[0]);
        Class<?> tbl = entity.getClass();
        TableMeta tm = this.classToTableMeta.get(tbl);
        tm.validate(entity, ignoreNull);
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", TableMeta.getTableName(tbl));
        ArrayList<String> names = new ArrayList<String>();
        long id = entity.getId();
        for (ColumnMeta cm : tm.getColumnMetas()) {
            if (cm.isPrimaryKey()) continue;
            names.add(cm.getName());
        }
        Object[] val = this.initEntity(tm, names, entity);
        if (ignoreNull) {
            Iterator iterator = names.iterator();
            ArrayList notNull = new ArrayList();
            Object[] objectArray = val;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object v = objectArray[i];
                iterator.next();
                if (v != null) {
                    notNull.add(v);
                    continue;
                }
                iterator.remove();
            }
            val = notNull.toArray();
        }
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object v : val) {
            args.add(v);
        }
        args.add(id);
        String sql = String.format("UPDATE %s SET %s=? WHERE id=?", tm.getTable(), String.join((CharSequence)"=?,", names));
        return this.jdbcHelper.update(sql, args.toArray());
    }

    public <E extends BaseEntity, M extends BaseTable> int update(E entity) {
        return this.update(entity, false);
    }

    public <E extends BaseEntity, M extends BaseTable> int updateIgnoreNull(E entity) {
        return this.update(entity, true);
    }

    public <E extends BaseEntity, M extends BaseTable> int updateBy(Class<E> tbl, BaseTable<M> tpl) {
        return this.jdbcHelper.update(tpl.toString(), tpl.getArgs().toArray());
    }

    public <E> int deleteById(Class<E> tbl, Long id) {
        if (id == null) {
            return 0;
        }
        TableMeta tm = this.classToTableMeta.get(tbl);
        String sql = String.format("DELETE FROM %s WHERE id = ?", tm.getTable());
        return this.jdbcHelper.update(sql, new Object[]{id});
    }

    public <E> int deleteByIds(Class<E> tbl, List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        TableMeta tm = this.classToTableMeta.get(tbl);
        String stub = OUtils.genStub("?", ",", ids.size());
        String sql = String.format("DELETE FROM %s WHERE id IN (%s) ", tm.getTable(), stub);
        return this.jdbcHelper.update(sql, ids.toArray());
    }

    public <E extends BaseEntity, M extends BaseTable> int delete(Class<E> tbl, BaseTable<M> cnd) {
        if (cnd == null || cnd.toString().trim().isEmpty()) {
            TableMeta tm = this.classToTableMeta.get(tbl);
            String sql = String.format("DELETE FROM %s;", tm.getTable());
            return this.jdbcHelper.update(sql, new Object[0]);
        }
        TableMeta tm = this.classToTableMeta.get(tbl);
        String sql = String.format("DELETE FROM %s %s;", tm.getTable(), cnd.toString());
        return this.jdbcHelper.update(sql, cnd.getArgs().toArray());
    }

    public <E extends BaseEntity, M extends BaseTable> long count(Class<E> tbl) {
        return this.count(tbl, null);
    }

    public <E extends BaseEntity, M extends BaseTable> long count(Class<E> tbl, BaseTable<M> cnd) {
        if (cnd == null || cnd.toString().trim().isEmpty()) {
            TableMeta tm = this.classToTableMeta.get(tbl);
            String sql = String.format("SELECT COUNT(1) FROM %s;", tm.getTable());
            return (Long)this.jdbcHelper.queryForObject(sql);
        }
        TableMeta tm = this.classToTableMeta.get(tbl);
        String withName = cnd.alias + "_with";
        String sql = String.format("WITH %s AS (%s) SELECT COUNT(1) FROM %s", withName, cnd.toString(), withName);
        return (Long)this.jdbcHelper.queryForObject(sql, cnd.getArgs().toArray());
    }

    public <E extends BaseEntity, M extends BaseTable> List<E> find(Class<E> tbl, BaseTable<M> cnd) {
        ArrayList data = new ArrayList();
        this.find(tbl, cnd, e -> data.add(e));
        return data;
    }

    public <E extends BaseEntity, M extends BaseTable> Page<E> find(Class<E> tbl, BaseTable<M> cnd, int page, int pageSize) {
        if (cnd.select.length() == 0) {
            cnd.select(new Queryable[0]);
        }
        if (cnd.from.length() == 0) {
            cnd.from(new BaseTable[0]);
        }
        Page result = new Page();
        result.setPagesize(pageSize);
        ArrayList data = new ArrayList(10);
        result.setData(data);
        if (page <= 0) {
            result.setTotal(this.count(tbl, cnd));
        }
        if (page != 0) {
            page = Math.abs(page) - 1;
        }
        result.setPage(page + 1);
        BaseTable<M> limitCnd = cnd.copy();
        limitCnd.limit(pageSize, pageSize * page);
        this.find(tbl, limitCnd, e -> result.getData().add(e));
        return result;
    }

    public <E extends BaseEntity, M extends BaseTable> E fetch(Class<E> tbl, BaseTable<M> cnd) {
        Page<E> page = this.find(tbl, cnd, 1, 1);
        if (page.getData().size() == 0) {
            return null;
        }
        return (E)((BaseEntity)page.getData().get(0));
    }

    public <E extends BaseEntity, M extends BaseTable> void find(Class<E> tbl, BaseTable<M> cnd, Consumer<E> consumer) {
        TableMeta tm = this.classToTableMeta.get(tbl);
        if (tm == null) {
            return;
        }
        if (cnd.select.length() == 0) {
            cnd.select(new Queryable[0]);
        }
        if (cnd.from.length() == 0) {
            cnd.from(new BaseTable[0]);
        }
        String sql = null;
        if (TblType.TABLE.equals((Object)tm.getType())) {
            sql = cnd.toString();
        } else if (TblType.WITH.equals((Object)tm.getType())) {
            sql = String.format("WITH %s AS (%s) %s ", tm.getTable(), tm.getViewDef().toSql(), cnd.toString());
        }
        this.jdbcHelper.query(sql, cnd.getArgs().toArray(new Object[0]), rs -> {
            Object row = null;
            try {
                row = DaoHelper.createBy(tbl, tm, rs);
                consumer.accept(row);
            }
            catch (SQLException e) {
                Failed.throwError(e.getMessage(), new Object[0]);
            }
        });
    }

    public <E extends BaseEntity, M extends BaseTable> List<E> findByIds(Class<E> tbl, List<Long> ids) {
        if (ids == null || ids.isEmpty()) {
            return new ArrayList();
        }
        TableMeta tm = this.classToTableMeta.get(tbl);
        OAssert.fatal(tm != null, "\u65e0\u6cd5\u627e\u5230\u8868\uff1a%s", TableMeta.getTableName(tbl));
        String sql = String.format("SELECT * FROM %s WHERE id IN ()", tm.getTable(), OUtils.genStub("?", ",", ids.size()));
        ArrayList rows = new ArrayList(ids.size());
        this.jdbcHelper.query(sql, ids.toArray(), rs -> {
            try {
                Object row = null;
                while (rs.next()) {
                    row = DaoHelper.createBy(tbl, tm, rs);
                    rows.add(row);
                }
            }
            catch (SQLException e) {
                Failed.throwError(e.getMessage(), new Object[0]);
            }
        });
        return rows;
    }
}

