/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.processor;

import com.google.common.base.CaseFormat;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import top.onceio.core.db.annotation.Tbl;
import top.onceio.core.db.model.BaseCol;
import top.onceio.core.db.model.BaseTable;
import top.onceio.core.db.model.StringCol;
import top.onceio.core.util.OReflectUtil;

@SupportedAnnotationTypes(value={"top.onceio.core.db.annotation.Tbl"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class TblProcessor
extends AbstractProcessor {
    private static final String META_CLASS_NAME = "Meta";
    private static final String META_METHOD_NAME = "meta";
    private static final String CLASS_INIT_METHOD_NAME = "<init>";
    private static final String META_BIND_METHOD_NAME = "super.bind";
    private JavacTrees trees;
    private TreeMaker treeMaker;
    private Names names;
    private Messager messager;
    private ClassReader classReader;
    private Elements elementsUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.elementsUtils = processingEnvironment.getElementUtils();
        this.trees = JavacTrees.instance(this.processingEnv);
        Context context = ((JavacProcessingEnvironment)this.processingEnv).getContext();
        this.treeMaker = TreeMaker.instance(context);
        this.messager = processingEnvironment.getMessager();
        this.names = Names.instance(context);
        this.classReader = ClassReader.instance(context);
        this.classReader.loadClass(this.names.fromString(BaseTable.class.getName()));
        this.classReader.loadClass(this.names.fromString(BaseCol.class.getName()));
        this.classReader.loadClass(this.names.fromString(StringCol.class.getName()));
        this.classReader.loadClass(this.names.fromString(OReflectUtil.class.getName()));
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> annotation = roundEnv.getElementsAnnotatedWith(Tbl.class);
        HashMap nameToEntity = new HashMap();
        java.util.List entities = annotation.stream().map(element -> this.trees.getTree((Element)element)).collect(Collectors.toList());
        for (JCTree tree : entities) {
            EntityTranslator entityTranslator = new EntityTranslator();
            tree.accept(entityTranslator);
            if (entityTranslator.hasMetaClass) continue;
            JCTree.JCClassDecl jcClass = entityTranslator.jcClass;
            Map<String, TypeMirror> fieldToType = this.elementsUtils.getAllMembers(jcClass.sym).stream().filter(m -> m.getKind().isField()).collect(Collectors.toMap(k -> k.getSimpleName().toString(), v -> v.asType()));
            JCTree.JCClassDecl metaClass = this.generateMetaClass(entityTranslator.tbl, jcClass, fieldToType);
            jcClass.defs = jcClass.defs.append(metaClass);
            jcClass.defs = jcClass.defs.append(this.generateMetaMethod(metaClass));
        }
        return true;
    }

    private JCTree.JCMethodDecl generateGetterMethod(JCTree.JCVariableDecl jcVariable) {
        JCTree.JCModifiers jcModifiers = this.treeMaker.Modifiers(1L);
        Name methodName = this.handleMethodSignature(jcVariable.getName(), "get");
        ListBuffer<JCTree.JCReturn> jcStatements = new ListBuffer<JCTree.JCReturn>();
        jcStatements.append(this.treeMaker.Return(this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.getNameFromString("this")), jcVariable.getName())));
        JCTree.JCBlock jcBlock = this.treeMaker.Block(0L, jcStatements.toList());
        JCTree.JCExpression returnType = jcVariable.vartype;
        List<JCTree.JCTypeParameter> typeParameters = List.nil();
        List<JCTree.JCVariableDecl> parameters = List.nil();
        List<JCTree.JCExpression> throwsClauses = List.nil();
        return this.treeMaker.MethodDef(jcModifiers, methodName, returnType, typeParameters, parameters, throwsClauses, jcBlock, null);
    }

    private JCTree.JCMethodDecl generateSetterMethod(JCTree.JCVariableDecl jcVariable) throws ReflectiveOperationException {
        JCTree.JCModifiers modifiers = this.treeMaker.Modifiers(1L);
        Name variableName = jcVariable.getName();
        Name methodName = this.handleMethodSignature(variableName, "set");
        ListBuffer<JCTree.JCExpressionStatement> jcStatements = new ListBuffer<JCTree.JCExpressionStatement>();
        jcStatements.append(this.treeMaker.Exec(this.treeMaker.Assign(this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(this.getNameFromString("this")), variableName), this.treeMaker.Ident(variableName))));
        JCTree.JCBlock jcBlock = this.treeMaker.Block(0L, jcStatements.toList());
        JCTree.JCExpression returnType = this.treeMaker.Type((Type)Class.forName("com.sun.tools.javac.code.Type$JCVoidType").newInstance());
        List<JCTree.JCTypeParameter> typeParameters = List.nil();
        JCTree.JCVariableDecl variableDecl = this.treeMaker.VarDef(this.treeMaker.Modifiers(0x200000000L, List.nil()), jcVariable.name, jcVariable.vartype, null);
        List<JCTree.JCVariableDecl> parameters = List.of(variableDecl);
        List<JCTree.JCExpression> throwsClauses = List.nil();
        return this.treeMaker.MethodDef(modifiers, methodName, returnType, typeParameters, parameters, throwsClauses, jcBlock, null);
    }

    private JCTree.JCVariableDecl generateColField(JCTree.JCFieldAccess entityClass, Name metaClassName, String fieldName, TypeMirror fieldType) {
        JCTree.JCModifiers modifiers = this.treeMaker.Modifiers(1L);
        Name variableName = this.names.fromString(fieldName);
        JCTree.JCTypeApply typeApply = fieldType.getKind().equals((Object)TypeKind.BOOLEAN) || fieldType.getKind().equals((Object)TypeKind.BYTE) || fieldType.getKind().equals((Object)TypeKind.SHORT) || fieldType.getKind().equals((Object)TypeKind.INT) || fieldType.getKind().equals((Object)TypeKind.LONG) || fieldType.getKind().equals((Object)TypeKind.FLOAT) || fieldType.getKind().equals((Object)TypeKind.DOUBLE) ? this.treeMaker.TypeApply(this.memberAccess(BaseCol.class.getName()), List.of(this.treeMaker.Ident(metaClassName))) : this.treeMaker.TypeApply(this.memberAccess(StringCol.class.getName()), List.of(this.treeMaker.Ident(metaClassName)));
        JCTree.JCExpression fn = this.memberAccess(OReflectUtil.class.getName() + ".getField");
        JCTree.JCMethodInvocation m = this.treeMaker.Apply(List.nil(), fn, List.of(entityClass, this.treeMaker.Literal(variableName.toString())));
        JCTree.JCNewClass metaVal = this.treeMaker.NewClass(null, List.nil(), typeApply, List.of(this.treeMaker.Ident(this.getNameFromString("this")), m), null);
        return this.treeMaker.VarDef(modifiers, variableName, typeApply, metaVal);
    }

    private JCTree.JCClassDecl generateMetaClass(JCTree.JCAnnotation tblAnn, JCTree.JCClassDecl jcEntityClass, Map<String, TypeMirror> fieldToType) {
        JCTree.JCModifiers modifiers = this.treeMaker.Modifiers(9L);
        JCTree.JCFieldAccess entityClass = this.treeMaker.Select((JCTree.JCExpression)this.treeMaker.Ident(jcEntityClass.name), this.names.fromString("class"));
        Name metaClassName = this.getNameFromString(META_CLASS_NAME);
        List<JCTree.JCTypeParameter> typeParameters = List.nil();
        JCTree.JCTypeApply extending = this.treeMaker.TypeApply(this.memberAccess(BaseTable.class.getName()), List.of(this.treeMaker.Ident(metaClassName)));
        List<JCTree.JCExpression> implementing = List.nil();
        ArrayList<JCTree.JCMethodDecl> defs = new ArrayList<JCTree.JCMethodDecl>();
        JCTree.JCMethodDecl m = this.generateMetaConstructionMethod(tblAnn, jcEntityClass, entityClass, metaClassName);
        defs.add(m);
        fieldToType.forEach((fieldName, fieldType) -> defs.add((JCTree.JCMethodDecl)((Object)this.generateColField(entityClass, metaClassName, (String)fieldName, (TypeMirror)fieldType))));
        JCTree.JCClassDecl metaClassDecl = this.treeMaker.ClassDef(modifiers, metaClassName, typeParameters, extending, implementing, List.from(defs));
        return metaClassDecl;
    }

    private JCTree.JCMethodDecl generateMetaConstructionMethod(JCTree.JCAnnotation tblAnn, JCTree.JCClassDecl jcEntityClass, JCTree.JCFieldAccess entityClass, Name methodName) {
        JCTree.JCModifiers modifiers = this.treeMaker.Modifiers(1L);
        ListBuffer<JCTree.JCExpressionStatement> jcStatements = new ListBuffer<JCTree.JCExpressionStatement>();
        JCTree.JCExpression fn = this.memberAccess(META_BIND_METHOD_NAME);
        String tableName = jcEntityClass.name.toString().replaceAll("([A-Z])", "_$1").toLowerCase();
        if (tableName.startsWith("_")) {
            tableName = tableName.substring(1);
        }
        for (JCTree.JCExpression arg : tblAnn.getArguments()) {
            String[] fv = arg.toString().split("=");
            if (!fv[0].trim().equals("name")) continue;
            String v = fv[1].trim();
            tableName = v.substring(1, v.length() - 1);
        }
        JCTree.JCMethodInvocation m = this.treeMaker.Apply(List.nil(), fn, List.of(this.treeMaker.Literal(tableName), this.memberAccess("this"), entityClass));
        jcStatements.append(this.treeMaker.Exec(m));
        JCTree.JCBlock jcBlock = this.treeMaker.Block(0L, jcStatements.toList());
        Object returnType = null;
        List<JCTree.JCTypeParameter> typeParameters = List.nil();
        List<JCTree.JCVariableDecl> parameters = List.nil();
        List<JCTree.JCExpression> throwsClauses = List.nil();
        return this.treeMaker.MethodDef(modifiers, this.names.fromString(CLASS_INIT_METHOD_NAME), null, typeParameters, parameters, throwsClauses, jcBlock, null);
    }

    private JCTree.JCMethodDecl generateMetaMethod(JCTree.JCClassDecl metaClass) {
        JCTree.JCModifiers modifiers = this.treeMaker.Modifiers(9L);
        Name methodName = this.getNameFromString(META_METHOD_NAME);
        JCTree.JCNewClass metaVal = this.treeMaker.NewClass(null, List.nil(), this.treeMaker.Ident(metaClass.name), List.nil(), null);
        JCTree.JCVariableDecl metaValDecl = this.treeMaker.VarDef(this.treeMaker.Modifiers(0x200000000L), this.names.fromString("metaVal"), this.treeMaker.Ident(metaClass.name), metaVal);
        ListBuffer<JCTree.JCReturn> jcStatements = new ListBuffer<JCTree.JCReturn>();
        jcStatements.append(this.treeMaker.Return(metaValDecl.getInitializer()));
        JCTree.JCBlock jcBlock = this.treeMaker.Block(0L, jcStatements.toList());
        JCTree.JCIdent returnType = this.treeMaker.Ident(metaClass.name);
        List<JCTree.JCTypeParameter> typeParameters = List.nil();
        List<JCTree.JCVariableDecl> parameters = List.nil();
        List<JCTree.JCExpression> throwsClauses = List.nil();
        return this.treeMaker.MethodDef(modifiers, methodName, returnType, typeParameters, parameters, throwsClauses, jcBlock, null);
    }

    private JCTree.JCExpression memberAccess(String components) {
        String[] componentArray = components.split("\\.");
        JCTree.JCExpression expr = this.treeMaker.Ident(this.getNameFromString(componentArray[0]));
        for (int i = 1; i < componentArray.length; ++i) {
            expr = this.treeMaker.Select(expr, this.getNameFromString(componentArray[i]));
        }
        return expr;
    }

    private Name handleMethodSignature(Name name, String prefix) {
        return this.names.fromString(prefix + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, name.toString()));
    }

    private Name getNameFromString(String s) {
        return this.names.fromString(s);
    }

    class EntityTranslator
    extends TreeTranslator {
        private boolean hasMetaClass = false;
        private JCTree.JCAnnotation tbl;
        private JCTree.JCClassDecl jcClass;

        EntityTranslator() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jcClass) {
            super.visitClassDef(jcClass);
            this.jcClass = jcClass;
            if (jcClass.name.toString().equals(TblProcessor.META_CLASS_NAME)) {
                this.hasMetaClass = true;
            }
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation var1) {
            var1.annotationType = this.translate(var1.annotationType);
            var1.args = this.translate(var1.args);
            if (TblProcessor.this.treeMaker.Type(var1.type).toString().equals(Tbl.class.getName())) {
                this.tbl = var1;
            }
            this.result = var1;
        }
    }
}

