/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import top.onceio.core.db.meta.IndexMeta;
import top.onceio.core.db.meta.TableMeta;
import top.onceio.core.db.model.AccessHelper;
import top.onceio.core.db.model.BaseMeta;

public class SqlPlanBuilder {
    public static int DROP_VIEW = 0;
    public static int DROP = 1;
    public static int CREATE_SCHEMA = 2;
    public static int CREATE_TABLE = 3;
    public static int ALTER = 4;
    public static int CREATE_VIEW = 5;
    public static int COMMENT = 6;
    Map<TableMeta, Collection<String>[]> plan = new HashMap<TableMeta, Collection<String>[]>();

    private Collection<String>[] createArray() {
        Collection[] arr = new Collection[7];
        for (int i : Arrays.asList(DROP, CREATE_TABLE, ALTER, COMMENT)) {
            arr[i] = new ArrayList();
        }
        for (int i : Arrays.asList(DROP_VIEW, CREATE_SCHEMA, CREATE_VIEW)) {
            arr[i] = new HashSet();
        }
        return arr;
    }

    private Collection<String>[] getOrCreate(TableMeta meta) {
        Collection<String>[] arr = this.plan.get(meta);
        if (arr == null) {
            arr = this.createArray();
            this.plan.put(meta, arr);
        }
        return arr;
    }

    public SqlPlanBuilder append(int option, TableMeta meta, String sql) {
        Collection<String>[] arr = this.getOrCreate(meta);
        arr[option].add(sql);
        return this;
    }

    public SqlPlanBuilder append(int option, TableMeta meta, Collection<String> sql) {
        if (!sql.isEmpty()) {
            Collection<String>[] arr = this.getOrCreate(meta);
            arr[option].addAll(sql);
        }
        return this;
    }

    public SqlPlanBuilder append(SqlPlanBuilder otherPlan) {
        otherPlan.plan.forEach((k, v) -> {
            for (int i = 0; i < ((Collection[])v).length; ++i) {
                this.append(i, (TableMeta)k, v[i]);
            }
        });
        return this;
    }

    private void sortedAdd(Map<String, TableMeta> nameToMeta, List<TableMeta> order, BaseMeta def) {
        TableMeta meta = nameToMeta.get(AccessHelper.getName(def));
        if (order.contains(meta)) {
            return;
        }
        List<BaseMeta<?>> refs = AccessHelper.getRefs(def);
        for (BaseMeta<?> ref : refs) {
            this.sortedAdd(nameToMeta, order, ref);
        }
        order.add(meta);
    }

    private void sortedAdd(Map<String, TableMeta> nameToMeta, List<TableMeta> order, TableMeta meta) {
        if (order.contains(meta)) {
            return;
        }
        if (meta.getViewDef() != null) {
            this.sortedAdd(nameToMeta, order, meta.getViewDef());
            order.add(meta);
        } else {
            ArrayList<IndexMeta> all = new ArrayList<IndexMeta>();
            all.addAll(meta.getFieldConstraint());
            all.addAll(meta.getIndexes());
            for (IndexMeta indexMeta : all) {
                if (indexMeta.refTable == null) continue;
                this.sortedAdd(nameToMeta, order, nameToMeta.get(indexMeta.refTable));
            }
            order.add(meta);
        }
    }

    public List<String> build(Map<String, TableMeta> nameToMeta) {
        ArrayList<String> sql = new ArrayList<String>();
        ArrayList<TableMeta> order = new ArrayList<TableMeta>();
        for (TableMeta meta : this.plan.keySet()) {
            this.sortedAdd(nameToMeta, order, meta);
        }
        HashSet<String> createSchema = new HashSet<String>();
        HashSet<String> dropView = new HashSet<String>();
        for (TableMeta meta : order) {
            Collection<String>[] v = this.plan.get(meta);
            if (v == null) continue;
            for (int i = 0; i < v.length; ++i) {
                if (i == CREATE_SCHEMA) {
                    createSchema.addAll(v[i]);
                    continue;
                }
                if (i == DROP_VIEW) {
                    dropView.addAll(v[i]);
                    continue;
                }
                sql.addAll(v[i]);
            }
        }
        sql.addAll(0, dropView);
        sql.addAll(0, createSchema);
        return sql;
    }
}

