/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.model;

import java.lang.reflect.Field;
import top.onceio.core.db.meta.TableMeta;
import top.onceio.core.db.model.BaseMeta;
import top.onceio.core.db.model.Queryable;

public class BaseCol<T extends BaseMeta>
implements Queryable {
    T table;
    String name;
    Field field;

    public BaseCol(T table, Field field) {
        this.table = table;
        this.name = TableMeta.getColumnName(field);
        this.field = field;
    }

    @Override
    public String name() {
        return ((BaseMeta)this.table).alias + "." + this.name;
    }

    public T eq(Object val) {
        ((BaseMeta)this.table).where.append(" " + this.name() + " = ?");
        ((BaseMeta)this.table).args.add(val);
        return this.table;
    }

    public T ne(Object val) {
        ((BaseMeta)this.table).where.append(" " + this.name() + " != ?");
        ((BaseMeta)this.table).args.add(val);
        return this.table;
    }

    public T gt(Object val) {
        ((BaseMeta)this.table).where.append(" " + this.name() + " > ?");
        ((BaseMeta)this.table).args.add(val);
        return this.table;
    }

    public T ge(Object val) {
        ((BaseMeta)this.table).where.append(" " + this.name() + " >= ?");
        ((BaseMeta)this.table).args.add(val);
        return this.table;
    }

    public T lt(Object val) {
        ((BaseMeta)this.table).where.append(" " + this.name() + " < ?");
        ((BaseMeta)this.table).args.add(val);
        return this.table;
    }

    public T le(Object val) {
        ((BaseMeta)this.table).where.append(" " + this.name() + " <= ?");
        ((BaseMeta)this.table).args.add(val);
        return this.table;
    }

    public T in(Object ... vals) {
        ((BaseMeta)this.table).where.append(" " + this.name() + " IN (");
        for (Object val : vals) {
            ((BaseMeta)this.table).where.append("?,");
            ((BaseMeta)this.table).args.add(val);
        }
        ((BaseMeta)this.table).where.deleteCharAt(((BaseMeta)this.table).where.length() - 1);
        ((BaseMeta)this.table).where.append(")");
        return this.table;
    }

    public T in(BaseMeta sub) {
        ((BaseMeta)this.table).where.append(" " + this.name() + " IN (");
        ((BaseMeta)this.table).where.append(sub.toString());
        ((BaseMeta)this.table).args.addAll(sub.args);
        ((BaseMeta)this.table).where.append(")");
        ((BaseMeta)this.table).refs.add(sub);
        return this.table;
    }

    public T notIn(Object ... vals) {
        ((BaseMeta)this.table).where.append(" " + this.name() + " NOT IN (");
        for (Object val : vals) {
            ((BaseMeta)this.table).where.append("?,");
            ((BaseMeta)this.table).args.add(val);
        }
        ((BaseMeta)this.table).where.deleteCharAt(((BaseMeta)this.table).where.length() - 1);
        ((BaseMeta)this.table).where.append(")");
        return this.table;
    }

    public T notIn(BaseMeta sub) {
        ((BaseMeta)this.table).where.append(" " + this.name() + " NOT IN (");
        ((BaseMeta)this.table).where.append(sub.toString());
        ((BaseMeta)this.table).args.addAll(sub.args);
        ((BaseMeta)this.table).where.append(")");
        ((BaseMeta)this.table).refs.add(sub);
        return this.table;
    }

    public T set(Object val) {
        ((BaseMeta)this.table).update.append(" " + this.name + " = ?,");
        ((BaseMeta)this.table).args.add(val);
        return this.table;
    }

    public T setExp(String val) {
        ((BaseMeta)this.table).update.append(String.format(" %s = %s + (%s),", this.name, this.name, val));
        return this.table;
    }
}

