/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.util;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import top.onceio.core.util.ClassScanner;

public class AnnotationScanner {
    private static final Logger LOGGER = Logger.getLogger(AnnotationScanner.class);
    private final Set<Class<?>> filter = new HashSet();
    private final Map<Class<?>, Set<Class<?>>> classifiedAnns = new HashMap();

    public AnnotationScanner(Class<?> ... annotation) {
        this.filter.addAll(Arrays.asList(annotation));
    }

    public Set<Class<?>> getFilter() {
        return this.filter;
    }

    public void scanPackages(String ... packages) {
        LOGGER.debug((Object)("scanning :" + String.join((CharSequence)",", packages)));
        ClassScanner.findBy(new Consumer<Class<?>>(){

            @Override
            public void accept(Class<?> clazz) {
                for (Annotation a : clazz.getAnnotations()) {
                    if (!AnnotationScanner.this.filter.contains(a.annotationType())) continue;
                    AnnotationScanner.this.putClass(a.annotationType(), clazz);
                    LOGGER.debug((Object)String.format("%s:%s", a.annotationType().getName(), clazz.getName()));
                }
            }
        }, packages);
    }

    public void putClass(Class<?> annotation, Class<?> clazz) {
        Set<Class<?>> clazzList = this.classifiedAnns.get(annotation);
        if (clazzList == null) {
            clazzList = new HashSet();
            this.classifiedAnns.put(annotation, clazzList);
        }
        clazzList.add(clazz);
    }

    public Set<Class<?>> getClasses(Class<?> ... annotation) {
        HashSet result = new HashSet();
        for (Class<?> ann : annotation) {
            Set<Class<?>> r = this.classifiedAnns.get(ann);
            if (r == null) continue;
            result.addAll(r);
        }
        return result;
    }
}

