/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import top.onceio.OnceIO;

public class ClassScanner {
    private static final ClassLoader classLoader = OnceIO.getClassLoader();

    public static void findBy(Consumer<Class<?>> consumer, String ... packages) {
        for (String pkg : packages) {
            URL url = classLoader.getResource(pkg.replace(".", "/"));
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                ClassScanner.findClassLocal(pkg, consumer);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            ClassScanner.findClassJar(pkg, consumer);
        }
    }

    private static void findClassLocal(final String packName, final Consumer<Class<?>> consumer) {
        URI url = null;
        try {
            url = classLoader.getResource(packName.replace(".", "/")).toURI();
        }
        catch (URISyntaxException e1) {
            throw new RuntimeException("\u672a\u627e\u5230\u7b56\u7565\u8d44\u6e90");
        }
        File file = new File(url);
        file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File chiFile) {
                if (chiFile.isDirectory()) {
                    ClassScanner.findClassLocal(packName + "." + chiFile.getName(), consumer);
                }
                if (chiFile.getName().endsWith(".class")) {
                    Class<?> clazz = null;
                    try {
                        clazz = classLoader.loadClass(packName + "." + chiFile.getName().replace(".class", ""));
                        consumer.accept(clazz);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private static void findClassJar(String packName, Consumer<Class<?>> consumer) {
        String pathName = packName.replace(".", "/");
        JarFile jarFile = null;
        try {
            URL url = classLoader.getResource(pathName);
            JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
            jarFile = jarURLConnection.getJarFile();
        }
        catch (IOException e) {
            throw new RuntimeException("\u672a\u627e\u5230\u7b56\u7565\u8d44\u6e90");
        }
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.contains(pathName) || jarEntryName.equals(pathName + "/")) continue;
            if (jarEntry.isDirectory()) {
                String clazzName = jarEntry.getName().replace("/", ".");
                int endIndex = clazzName.lastIndexOf(".");
                String prefix = null;
                if (endIndex > 0) {
                    prefix = clazzName.substring(0, endIndex);
                }
                ClassScanner.findClassJar(prefix, consumer);
            }
            if (!jarEntry.getName().endsWith(".class")) continue;
            Class<?> clazz = null;
            try {
                clazz = classLoader.loadClass(jarEntry.getName().replace("/", ".").replace(".class", ""));
                consumer.accept(clazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

