/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import top.onceio.core.util.OLog;

public class EPSHelper<T> {
    private static final long TIME_WINDOW = 1000L;
    private int defaultMaxEPS;
    private Map<T, Integer> nameToMaxEPS;
    private ConcurrentHashMap<T, ConcurrentHashMap<Long, AtomicInteger>> nameToEPS = new ConcurrentHashMap(100);

    public EPSHelper(int defaultMaxEPS) {
        this.defaultMaxEPS = defaultMaxEPS;
        this.nameToMaxEPS = new HashMap<T, Integer>(16);
    }

    public EPSHelper(Map<T, Integer> nameToMaxEPS, int defaultMaxEPS) {
        this.nameToMaxEPS = nameToMaxEPS;
        this.defaultMaxEPS = defaultMaxEPS;
    }

    public void waiting(T name) {
        while (true) {
            int maxEPS;
            ConcurrentHashMap empty = new ConcurrentHashMap();
            ConcurrentHashMap<Long, AtomicInteger> eps = null;
            while ((eps = this.nameToEPS.putIfAbsent(name, empty)) == null) {
            }
            long currentTime = System.currentTimeMillis();
            long time = currentTime - currentTime % 1000L;
            AtomicInteger cnt = null;
            AtomicInteger ZERO = new AtomicInteger(0);
            while ((cnt = eps.putIfAbsent(time, ZERO)) == null) {
            }
            int waitingCnt = cnt.addAndGet(1);
            if (waitingCnt <= (maxEPS = this.nameToMaxEPS.getOrDefault(name, this.defaultMaxEPS).intValue())) break;
            try {
                Thread.sleep(1000L + time - currentTime);
            }
            catch (InterruptedException e) {
                OLog.error(e.toString(), new Object[0]);
            }
            this.nameToEPS.remove(time);
        }
    }
}

