/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.util;

import java.util.HashMap;
import java.util.Map;

public class PairMap<A, B> {
    private Map<A, B> a2b = null;
    private Map<B, A> b2a = null;

    public PairMap() {
        this.a2b = new HashMap<A, B>();
        this.b2a = new HashMap<B, A>();
    }

    public PairMap(int initialCapacity) {
        this.a2b = new HashMap<A, B>(initialCapacity);
        this.b2a = new HashMap<B, A>(initialCapacity);
    }

    public A getA(B b) {
        return this.b2a.get(b);
    }

    public B getB(A a) {
        return this.a2b.get(a);
    }

    public void put(A a, B b) {
        this.a2b.put(a, b);
        this.b2a.put(b, a);
    }

    public B removeByA(A a) {
        B b = this.a2b.remove(a);
        if (b != null) {
            this.b2a.remove(b);
        }
        return b;
    }

    public A removeByB(B b) {
        A a = this.b2a.remove(b);
        if (a != null) {
            this.a2b.remove(a);
        }
        return a;
    }

    public void clear() {
        this.a2b.clear();
        this.b2a.clear();
    }
}

