/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.dao;

import java.io.Serializable;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.function.Consumer;
import top.onceio.core.annotation.Using;
import top.onceio.core.beans.ApiMethod;
import top.onceio.core.db.dao.Dao;
import top.onceio.core.db.dao.Page;
import top.onceio.core.db.model.BaseMeta;
import top.onceio.core.db.model.BaseModel;
import top.onceio.core.db.model.DaoHelper;
import top.onceio.core.mvc.annocations.Api;
import top.onceio.core.mvc.annocations.Param;
import top.onceio.core.util.OReflectUtil;

public abstract class DaoHolder<T extends BaseModel, M extends BaseMeta>
implements Dao<T, M> {
    @Using
    protected DaoHelper daoHelper;
    private Class<T> tbl;
    private Class<M> mode;

    public DaoHolder() {
        TypeVariable t = DaoHolder.class.getTypeParameters()[0];
        this.tbl = OReflectUtil.searchGenType(DaoHolder.class, this.getClass(), t);
        TypeVariable m = DaoHolder.class.getTypeParameters()[1];
        this.mode = OReflectUtil.searchGenType(DaoHolder.class, this.getClass(), m);
    }

    public DaoHelper getDaoHelper() {
        return this.daoHelper;
    }

    public void setDaoHelper(DaoHelper daoHelper) {
        this.daoHelper = daoHelper;
    }

    @Override
    @Api(value="/{id}", method={ApiMethod.GET})
    public T get(@Param(value="id") Serializable id) {
        return this.daoHelper.get(this.tbl, id);
    }

    @Override
    @Api(value="/", method={ApiMethod.POST})
    public T insert(@Param T entity) {
        return this.daoHelper.insert(entity);
    }

    @Override
    @Api(value="/batch", method={ApiMethod.POST})
    public int batchInsert(@Param List<T> entities) {
        return this.daoHelper.batchInsert(entities);
    }

    @Override
    public int update(@Param T entity) {
        return this.daoHelper.update(entity);
    }

    @Api(value="/{id}", method={ApiMethod.PUT})
    public T save(@Param T entity) {
        Object e = this.get((Serializable)((BaseModel)entity).getId());
        if (e == null) {
            return this.daoHelper.insert(entity);
        }
        this.daoHelper.updateIgnoreNull(entity);
        return (T)this.get((Serializable)((BaseModel)entity).getId());
    }

    @Override
    @Api(value="/", method={ApiMethod.PATCH})
    public int updateIgnoreNull(@Param T entity) {
        return this.daoHelper.updateIgnoreNull(entity);
    }

    @Override
    @Api(value="/by", method={ApiMethod.PATCH})
    public int updateBy(BaseMeta<M> tpl) {
        return this.daoHelper.updateBy(this.tbl, tpl);
    }

    @Override
    public int deleteById(Serializable id) {
        return this.daoHelper.deleteById(this.tbl, id);
    }

    @Override
    public <ID extends Serializable> int deleteByIds(List<ID> ids) {
        return this.daoHelper.deleteByIds(this.tbl, ids);
    }

    @Override
    public int delete(BaseMeta<M> cnd) {
        return this.daoHelper.delete(this.tbl, cnd);
    }

    @Override
    @Api(value="/fetch", method={ApiMethod.GET})
    public T fetch(@Param(value="tpl") BaseMeta<M> tpl) {
        return this.daoHelper.fetch(this.tbl, tpl);
    }

    @Override
    @Api(value="/byIds", method={ApiMethod.GET})
    public <ID extends Serializable> List<T> findByIds(@Param(value="ids") List<ID> ids) {
        return this.daoHelper.findByIds(this.tbl, ids);
    }

    @Override
    public List<T> find(@Param(value="cnd") BaseMeta<M> cnd) {
        return this.daoHelper.find(this.tbl, cnd);
    }

    @Override
    @Api(value="/", method={ApiMethod.GET})
    public Page<T> find(@Param(value="cnd") BaseMeta<M> cnd, @Param(value="page") int page, @Param(value="pageSize") int pageSize) {
        return this.daoHelper.find(this.tbl, cnd, page, pageSize);
    }

    @Override
    public void find(BaseMeta<M> cnd, Consumer<T> consumer) {
        this.daoHelper.find(this.tbl, cnd, consumer);
    }

    @Override
    public long count() {
        return this.daoHelper.count(this.tbl);
    }

    @Override
    @Api(value="/count", method={ApiMethod.GET})
    public long count(@Param(value="cnd") BaseMeta<M> cnd) {
        return this.daoHelper.count(this.tbl, cnd);
    }
}

