/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.meta;

import java.util.ArrayList;
import java.util.List;
import top.onceio.core.db.annotation.IndexType;
import top.onceio.core.util.OAssert;
import top.onceio.core.util.OUtils;

public class IndexMeta {
    public static final String PRIMARY_KEY = "PRIMARY KEY";
    public static final String FOREIGN_KEY = "FOREIGN KEY";
    public static final String UNIQUE = "UNIQUE";
    public static final String INDEX = "INDEX";
    public static final String INDEX_NAME_PREFIX_PK = "pk_";
    public static final String INDEX_NAME_PREFIX_FK = "fk_";
    public static final String INDEX_NAME_PREFIX_UN = "un_";
    public static final String INDEX_NAME_PREFIX_NQ = "nq_";
    String name;
    IndexType type;
    String using;
    String table;
    String refTable;
    List<String> columns;

    public static String indexName(String table) {
        return table.replace('.', '_');
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IndexType getType() {
        return this.type;
    }

    public void setType(IndexType type) {
        this.type = type;
    }

    public String getUsing() {
        return this.using;
    }

    public void setUsing(String using) {
        this.using = using;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getRefTable() {
        return this.refTable;
    }

    public void setRefTable(String refTable) {
        this.refTable = refTable;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public String genName() {
        String cName = null;
        switch (this.type) {
            case PRIMARY_KEY: {
                cName = String.format("%s%s_%s", INDEX_NAME_PREFIX_PK, IndexMeta.indexName(this.table), String.join((CharSequence)"_", this.columns));
                break;
            }
            case FOREIGN_KEY: {
                cName = String.format("%s%s_%s", INDEX_NAME_PREFIX_FK, IndexMeta.indexName(this.table), String.join((CharSequence)"_", this.columns));
                break;
            }
            case UNIQUE_INDEX: 
            case INDEX: {
                cName = String.format("%s%s_%s", INDEX_NAME_PREFIX_NQ, IndexMeta.indexName(this.table), String.join((CharSequence)"_", this.columns));
                break;
            }
            case UNIQUE_FIELD: {
                cName = String.format("%s%s_%s", INDEX_NAME_PREFIX_UN, IndexMeta.indexName(this.table), String.join((CharSequence)"_", this.columns));
                break;
            }
            default: {
                OAssert.fatal("\u4e0d\u5b58\u5728\uff1a%s", OUtils.toJson(this));
            }
        }
        return cName;
    }

    public String genDef() {
        String def = null;
        String usingStruct = this.using != null ? " USING " + this.using : "";
        switch (this.type) {
            case PRIMARY_KEY: {
                def = String.format("PRIMARY KEY (%s)", String.join((CharSequence)",", this.columns));
                break;
            }
            case FOREIGN_KEY: {
                def = String.format("FOREIGN KEY (%s) REFERENCES %s(%s)", String.join((CharSequence)",", this.columns), this.refTable, "id");
                break;
            }
            case UNIQUE_FIELD: {
                def = String.format("UNIQUE (%s)", String.join((CharSequence)",", this.columns));
                break;
            }
            case UNIQUE_INDEX: 
            case INDEX: {
                def = String.format("ON %s%s (%s)", this.table, usingStruct, String.join((CharSequence)",", this.columns));
                break;
            }
            default: {
                OAssert.fatal("\u4e0d\u5b58\u5728\uff1a%s", OUtils.toJson(this));
            }
        }
        return def;
    }

    public String addSql() {
        String cName = this.name == null ? this.genName() : this.name;
        String def = this.genDef();
        if (this.type == IndexType.PRIMARY_KEY) {
            return String.format("ALTER TABLE %s ADD CONSTRAINT %s %s;", this.table, cName, def);
        }
        if (this.type == IndexType.INDEX) {
            return String.format("CREATE INDEX %s %s;", cName, def);
        }
        if (this.type == IndexType.UNIQUE_INDEX) {
            return String.format("CREATE UNIQUE INDEX %s %s;", cName, def);
        }
        return String.format("ALTER TABLE %s ADD CONSTRAINT %s %s;", this.table, cName, def);
    }

    public String dropSql() {
        String cName = this.name == null ? this.genName() : this.name;
        return String.format("ALTER TABLE %s DROP CONSTRAINT %s;", this.table, cName);
    }

    public static List<String> addConstraintSql(List<IndexMeta> cms) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (IndexMeta cm : cms) {
            sqls.add(cm.addSql());
        }
        return sqls;
    }

    public static List<String> dropConstraintSql(List<IndexMeta> cms) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (IndexMeta cm : cms) {
            sqls.add(cm.dropSql());
        }
        return sqls;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.refTable == null ? 0 : this.refTable.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.using == null ? 0 : this.using.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexMeta other = (IndexMeta)obj;
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.refTable == null ? other.refTable != null : !this.refTable.equals(other.refTable)) {
            return false;
        }
        if (this.table == null ? other.table != null : !this.table.equals(other.table)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.using == null ? other.using != null : !this.using.equals(other.using));
    }
}

