/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

public class ElementBuffer<E> {
    final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private int size = 10;
    private Lock readLock = this.rwl.readLock();
    private Lock writeLock = this.rwl.writeLock();
    private List<E> buffer;
    private Consumer<List<E>> consumer;

    public ElementBuffer(int size, Consumer<List<E>> consumer) {
        this.size = size;
        this.buffer = new ArrayList(size);
        this.consumer = consumer;
    }

    public void append(E element) {
        this.writeLock.lock();
        try {
            if (this.buffer.size() >= this.size) {
                this.flush();
            }
            this.buffer.add(element);
        }
        catch (Exception exception) {
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void append(List<E> elements) {
        this.writeLock.lock();
        try {
            int subFirst = 0;
            List<E> arrayList = new ArrayList<E>(elements);
            while (this.buffer.size() + arrayList.size() >= this.size) {
                subFirst = this.size - this.buffer.size();
                List sub = arrayList.subList(0, subFirst);
                this.buffer.addAll(sub);
                arrayList = arrayList.subList(subFirst, arrayList.size());
                this.flush();
            }
            this.buffer.addAll(arrayList);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void flush() {
        this.readLock.lock();
        try {
            this.consumer.accept(this.buffer);
            this.buffer.clear();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

