/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.onceio.OnceIO;
import top.onceio.core.util.OReflectUtil;
import top.onceio.core.util.OUtils;

public class JsonConfLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonConfLoader.class);
    private JsonObject conf = new JsonObject();
    private JsonObject beans = new JsonObject();

    public JsonObject getConf() {
        return this.conf;
    }

    public JsonObject getBeans() {
        return this.beans;
    }

    public static JsonConfLoader loadConf(String ... dirs) {
        JsonConfLoader conf = new JsonConfLoader();
        for (String dir : dirs) {
            conf.load(dir);
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJar(URL url) {
        String path = url.getFile();
        int sp = path.indexOf(".jar!");
        String jarpath = path.substring(0, sp) + ".jar";
        jarpath = OnceIO.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String dir = path.substring(sp + 6);
        JarFile localJarFile = null;
        try {
            localJarFile = new JarFile(jarpath);
            Enumeration<JarEntry> entries = localJarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String innerPath = jarEntry.getName();
                if (!innerPath.startsWith(dir) || !innerPath.endsWith(".json")) continue;
                InputStream inputStream = OnceIO.getClassLoader().getResourceAsStream(innerPath);
                this.loadJson(inputStream);
                inputStream.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
        finally {
            if (localJarFile != null) {
                try {
                    localJarFile.close();
                }
                catch (IOException e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        }
    }

    public void loadJson(InputStream inputStream) {
        try {
            JsonReader reader = OUtils.gson.newJsonReader((Reader)new InputStreamReader(inputStream));
            JsonObject jn = (JsonObject)OUtils.gson.fromJson(reader, JsonObject.class);
            jn.entrySet().forEach(arg -> {
                if ("beans".equals(arg.getKey())) {
                    ((JsonElement)arg.getValue()).getAsJsonObject().entrySet().forEach(bean -> this.beans.add((String)bean.getKey(), (JsonElement)bean.getValue()));
                } else {
                    this.conf.add((String)arg.getKey(), (JsonElement)arg.getValue());
                }
            });
            reader.close();
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
    }

    public void load(String dir) {
        File file;
        URL url = OnceIO.getClassLoader().getResource(dir);
        try {
            Enumeration<URL> files = OnceIO.getClassLoader().getResources(dir);
            while (files.hasMoreElements()) {
                URL u = files.nextElement();
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug(u.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (url != null) {
            if (url.getPath().contains(".jar!")) {
                this.loadJar(url);
            } else {
                file = new File(url.getFile());
                if (file.exists() && file.isDirectory()) {
                    this.loadDir(file);
                }
            }
        } else {
            file = new File(dir);
            if (file.exists() && file.isDirectory()) {
                this.loadDir(file);
            }
        }
    }

    private void loadDir(File dir) {
        try {
            Files.walk(dir.toPath(), FileVisitOption.FOLLOW_LINKS).forEach(path -> {
                File cnf = path.toFile();
                if (cnf.getName().endsWith(".json")) {
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(cnf);
                        this.loadJson(fis);
                    }
                    catch (FileNotFoundException e) {
                        LOGGER.warn(e.getMessage());
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {
                                LOGGER.warn(e.getMessage());
                            }
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
    }

    public Map<String, Object> resolveBeans() {
        HashMap<String, Object> name2Bean = new HashMap<String, Object>();
        this.beans.entrySet().forEach(t -> {
            JsonObject clsFields = ((JsonElement)t.getValue()).getAsJsonObject();
            JsonElement type = clsFields.get("@TYPE");
            String clsName = type != null ? type.getAsString() : (String)t.getKey();
            try {
                Class<?> cls = OnceIO.getClassLoader().loadClass(clsName);
                Object bean = cls.newInstance();
                name2Bean.put((String)t.getKey(), bean);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.warn(e.getMessage());
            }
        });
        this.beans.entrySet().forEach(t -> {
            JsonObject clsFields = ((JsonElement)t.getValue()).getAsJsonObject();
            Object bean = name2Bean.get(t.getKey());
            Class<?> cls = bean.getClass();
            clsFields.entrySet().forEach(fieldType -> {
                if (((String)fieldType.getKey()).equals("@TYPE")) {
                    return;
                }
                try {
                    Method method = OReflectUtil.getSetMethod(cls, (String)fieldType.getKey());
                    if (method != null) {
                        String strV = ((JsonElement)fieldType.getValue()).getAsString();
                        if (strV != null) {
                            if (strV.startsWith("@")) {
                                method.invoke(bean, name2Bean.get(strV.substring(1)));
                            } else {
                                method.invoke(bean, OReflectUtil.strToBaseType(method.getParameterTypes()[0], strV));
                            }
                        } else {
                            method.invoke(bean, OReflectUtil.strToBaseType(method.getParameterTypes()[0], strV));
                        }
                    } else {
                        LOGGER.warn("not exist : " + (String)fieldType.getKey());
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage());
                }
            });
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((String)t.getKey() + " -> " + bean);
            }
        });
        return name2Bean;
    }
}

