/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.beans;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.onceio.core.beans.ApiMethod;
import top.onceio.core.beans.ApiPair;

public class ApiResover {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiResover.class);
    private Map<String, ApiPair> patternToApi = new TreeMap<String, ApiPair>();
    private List<String> apis = new ArrayList<String>();

    public ApiResover push(ApiMethod apiMethod, String api, Object bean, Method method) {
        String[] ts;
        StringBuilder sb = new StringBuilder();
        for (String s : ts = api.split("/")) {
            if (s.startsWith("{") && s.endsWith("}")) {
                sb.append("/[^/]+");
                continue;
            }
            if (s.isEmpty()) continue;
            sb.append("/" + s);
        }
        String pattern = sb.toString();
        this.patternToApi.put(apiMethod.name() + ":" + pattern, new ApiPair(apiMethod, api, bean, method));
        return this;
    }

    public ApiResover build() {
        this.apis.addAll(this.patternToApi.keySet());
        Collections.sort(this.apis, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return String.CASE_INSENSITIVE_ORDER.compare(o2, o1);
            }
        });
        for (String apiPttern : this.apis) {
            ApiPair ap = this.patternToApi.get(apiPttern);
            LOGGER.info((Object)((Object)ap.getApiMethod()) + " " + ap.getApi());
        }
        return this;
    }

    public Map<String, ApiPair> getPatternToApi() {
        return this.patternToApi;
    }

    public List<String> getApis() {
        return this.apis;
    }
}

