/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.onceio.core.db.jdbc.DBType;
import top.onceio.core.exception.Failed;

public class JdbcHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcHelper.class);
    private static ThreadLocal<Connection> trans = new ThreadLocal();
    private DataSource dataSource;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DBType getDBType() {
        return DBType.POSTGRESQL;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean beginTransaction(int level, boolean readOnly) {
        boolean created = false;
        try {
            Connection conn = trans.get();
            if (conn == null) {
                created = true;
                conn = this.dataSource.getConnection();
                conn.setReadOnly(readOnly);
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(level);
                trans.set(conn);
            } else if (conn.getTransactionIsolation() < level) {
                conn.setTransactionIsolation(level);
            }
        }
        catch (SQLException e) {
            Failed.throwError(e.getMessage(), new Object[0]);
        }
        return created;
    }

    public Savepoint setSavepoint() {
        Savepoint sp = null;
        Connection conn = trans.get();
        try {
            sp = conn.setSavepoint();
        }
        catch (SQLException e) {
            Failed.throwError(e.getMessage(), new Object[0]);
        }
        return sp;
    }

    public void rollback(Savepoint sp) {
        Connection conn = trans.get();
        if (conn != null) {
            try {
                conn.rollback(sp);
                conn.releaseSavepoint(sp);
            }
            catch (SQLException e) {
                Failed.throwError(e.getMessage(), new Object[0]);
            }
        }
    }

    public void rollback() {
        Connection conn = trans.get();
        if (conn != null) {
            try {
                conn.rollback();
                trans.remove();
            }
            catch (SQLException e) {
                Failed.throwError(e.getMessage(), new Object[0]);
            }
        }
    }

    public void commit() {
        Connection conn = trans.get();
        if (conn != null) {
            try {
                conn.commit();
                trans.remove();
            }
            catch (SQLException e) {
                Failed.throwError(e.getMessage(), new Object[0]);
            }
            finally {
                try {
                    if (conn != null && !conn.isClosed()) {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object[]> call(String sql, Object[] args) {
        LinkedList<Object[]> result = new LinkedList<Object[]>();
        Connection conn = trans.get();
        CallableStatement stat = null;
        ResultSet rs = null;
        boolean usingTrans = false;
        if (conn == null) {
            if (this.dataSource != null) {
                try {
                    conn = this.dataSource.getConnection();
                }
                catch (SQLException e) {
                    Failed.throwError(e.getMessage(), new Object[0]);
                }
            }
        } else {
            usingTrans = true;
        }
        if (conn != null) {
            try {
                stat = conn.prepareCall(sql, 1002, 1008);
                if (args != null) {
                    for (int i = 0; i < args.length; ++i) {
                        stat.setObject(i + 1, args[i]);
                    }
                }
                rs = stat.executeQuery();
                ResultSetMetaData md = rs.getMetaData();
                Object[] rowNames = new Object[md.getColumnCount()];
                for (int cc = 1; cc <= md.getColumnCount(); ++cc) {
                    rowNames[cc - 1] = md.getColumnName(cc);
                }
                result.add(rowNames);
                while (rs.next()) {
                    Object[] row = new Object[md.getColumnCount()];
                    for (int cc = 1; cc <= md.getColumnCount(); ++cc) {
                        row[cc - 1] = rs.getObject(cc);
                    }
                    result.add(row);
                }
                rs.close();
            }
            catch (SQLException e) {
                Failed.throwMsg(e.getMessage(), new Object[0]);
            }
            finally {
                if (stat != null) {
                    try {
                        stat.close();
                    }
                    catch (SQLException e) {
                        Failed.throwMsg(e.getMessage(), new Object[0]);
                    }
                }
                if (conn != null && !usingTrans) {
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        Failed.throwMsg(e.getMessage(), new Object[0]);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batchExec(String ... sqls) {
        Connection conn = trans.get();
        Statement stat = null;
        int[] result = null;
        boolean usingTrans = false;
        if (conn == null) {
            if (this.dataSource != null) {
                try {
                    conn = this.dataSource.getConnection();
                }
                catch (SQLException e) {
                    Failed.throwError(e.getMessage(), new Object[0]);
                }
            }
        } else {
            usingTrans = true;
        }
        try {
            stat = conn.createStatement(1005, 1007);
            for (String sql : sqls) {
                stat.addBatch(sql);
            }
            stat.setMaxRows(sqls.length);
            result = stat.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Failed.throwMsg(e.getMessage(), new Object[0]);
        }
        finally {
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException e) {
                    Failed.throwMsg(e.getMessage(), new Object[0]);
                }
            }
            if (conn != null && !usingTrans) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    Failed.throwMsg(e.getMessage(), new Object[0]);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] batchExec(String sql, List<Object[]> args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(sql);
        }
        Connection conn = trans.get();
        PreparedStatement stat = null;
        int[] result = null;
        boolean usingTrans = false;
        if (conn == null) {
            if (this.dataSource != null) {
                try {
                    conn = this.dataSource.getConnection();
                }
                catch (SQLException e) {
                    Failed.throwError(e.getMessage(), new Object[0]);
                }
            }
        } else {
            usingTrans = true;
        }
        try {
            stat = conn.prepareStatement(sql, 1005, 1007);
            for (Object[] arr : args) {
                for (int i = 0; i < arr.length; ++i) {
                    stat.setObject(i + 1, arr[i]);
                }
                stat.addBatch();
            }
            stat.setMaxRows(args.size());
            result = stat.executeBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Failed.throwMsg(e.getMessage(), new Object[0]);
        }
        finally {
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException e) {
                    Failed.throwMsg(e.getMessage(), new Object[0]);
                }
            }
            if (conn != null && !usingTrans) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    Failed.throwMsg(e.getMessage(), new Object[0]);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(String sql, Object[] args, Consumer<ResultSet> consumer) {
        Connection conn = trans.get();
        PreparedStatement stat = null;
        ResultSet rs = null;
        boolean usingTrans = false;
        if (conn == null) {
            if (this.dataSource != null) {
                try {
                    conn = this.dataSource.getConnection();
                }
                catch (SQLException e) {
                    Failed.throwError(e.getMessage(), new Object[0]);
                }
            }
        } else {
            usingTrans = true;
        }
        try {
            stat = conn.prepareStatement(sql, 1002, 1007);
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    stat.setObject(i + 1, args[i]);
                }
            }
            rs = stat.executeQuery();
            while (rs.next()) {
                consumer.accept(rs);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            Failed.throwMsg(e.getMessage(), new Object[0]);
        }
        finally {
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException e) {
                    Failed.throwMsg(e.getMessage(), new Object[0]);
                }
            }
            if (conn != null && !usingTrans) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    Failed.throwMsg(e.getMessage(), new Object[0]);
                }
            }
        }
    }

    public Object queryForObject(String sql) {
        return this.queryForObject(sql, null);
    }

    public Object queryForObject(String sql, Object[] args) {
        List<Object[]> list = this.call(sql, args);
        if (list.size() == 2) {
            return list.get(1)[0];
        }
        return null;
    }

    public int[] batchUpdate(String sql) {
        return this.batchUpdate(sql, null);
    }

    public int[] batchUpdate(String sql, List<Object[]> batchArgs) {
        return this.batchExec(sql, batchArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, Object[] args) {
        int cnt = 0;
        Connection conn = trans.get();
        PreparedStatement stat = null;
        boolean usingTrans = false;
        if (conn == null) {
            if (this.dataSource != null) {
                try {
                    conn = this.dataSource.getConnection();
                }
                catch (SQLException e) {
                    Failed.throwError(e.getMessage(), new Object[0]);
                }
            }
        } else {
            usingTrans = true;
        }
        try {
            stat = conn.prepareStatement(sql, 1002, 2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(sql);
            }
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    stat.setObject(i + 1, args[i]);
                }
            }
            cnt = stat.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Failed.throwMsg(e.getMessage(), new Object[0]);
        }
        finally {
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException e) {
                    Failed.throwMsg(e.getMessage(), new Object[0]);
                }
            }
            if (conn != null && !usingTrans) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    Failed.throwMsg(e.getMessage(), new Object[0]);
                }
            }
        }
        return cnt;
    }
}

