/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.db.meta;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.onceio.core.db.annotation.Col;
import top.onceio.core.db.annotation.Index;
import top.onceio.core.db.annotation.IndexType;
import top.onceio.core.db.annotation.Model;
import top.onceio.core.db.annotation.ModelType;
import top.onceio.core.db.meta.ColumnMeta;
import top.onceio.core.db.meta.IndexMeta;
import top.onceio.core.db.meta.SqlPlanBuilder;
import top.onceio.core.db.model.BaseMeta;
import top.onceio.core.db.model.DefView;
import top.onceio.core.exception.VolidateFailed;
import top.onceio.core.util.OAssert;
import top.onceio.core.util.OReflectUtil;
import top.onceio.core.util.OUtils;

public class TableMeta {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableMeta.class);
    String table;
    BaseMeta viewDef;
    ModelType type;
    transient List<IndexMeta> fieldConstraint = new ArrayList<IndexMeta>(0);
    List<IndexMeta> indexes = new ArrayList<IndexMeta>();
    List<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>(0);
    transient Map<String, ColumnMeta> nameToColumnMeta = new HashMap<String, ColumnMeta>();
    transient Class<?> entity;
    public static final Map<Class<?>, TableMeta> tableCache = new HashMap();

    public String name() {
        return this.table;
    }

    public static String getTableName(Class<?> clazz) {
        Model model;
        String defaultName = clazz.getSimpleName().replaceAll("([A-Z])", "_$1").toLowerCase();
        if (defaultName.startsWith("_")) {
            defaultName = defaultName.substring(1);
        }
        if ((model = clazz.getAnnotation(Model.class)) != null && !model.name().equals("")) {
            return model.name().toLowerCase().replace("public.", "");
        }
        return defaultName;
    }

    public static String getColumnName(Field field) {
        String defaultName = field.getName().replaceAll("([A-Z])", "_$1").toLowerCase();
        Col col = field.getAnnotation(Col.class);
        if (col != null && !"".equals(col.name())) {
            return col.name();
        }
        return defaultName;
    }

    public static TableMeta createBy(Class<?> entity) {
        TableMeta tm = new TableMeta();
        tm.entity = entity;
        Model model = entity.getAnnotation(Model.class);
        tm.table = TableMeta.getTableName(entity);
        tm.type = model.type();
        if (model.type().equals((Object)ModelType.TABLE)) {
            ArrayList<IndexMeta> constraints = new ArrayList<IndexMeta>();
            for (Index index : model.indexes()) {
                IndexMeta cm = new IndexMeta();
                constraints.add(cm);
                cm.setColumns(Arrays.asList(index.columns()));
                cm.setTable(tm.getTable());
                if (index.unique()) {
                    cm.setType(IndexType.UNIQUE_INDEX);
                } else {
                    cm.setType(IndexType.INDEX);
                }
                cm.setUsing(index.using());
            }
            tm.setIndexes(constraints);
        } else if (DefView.class.isAssignableFrom(entity)) {
            try {
                DefView view = (DefView)entity.newInstance();
                tm.viewDef = view.def();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        ArrayList classes = new ArrayList();
        Class<?> clazz = entity;
        while (!clazz.equals(Object.class)) {
            classes.add(0, clazz);
            clazz = clazz.getSuperclass();
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        ArrayList<String> colOrder = new ArrayList<String>();
        for (Class clazz2 : classes) {
            for (Field field : clazz2.getDeclaredFields()) {
                int index;
                String table;
                Col col = field.getAnnotation(Col.class);
                if (col == null) continue;
                ColumnMeta cm = new ColumnMeta();
                cm.setName(TableMeta.getColumnName(field));
                cm.setUnique(col.unique());
                cm.setUsing(col.using());
                cm.setDefaultValue(col.defaultValue());
                cm.setComment(col.comment());
                cm.setNullable(col.nullable());
                if (TableMeta.getColumnName(field).equals("id")) {
                    cm.setPrimaryKey(true);
                    cm.setUnique(true);
                    cm.setNullable(false);
                    if (model.extend() != Void.TYPE) {
                        cm.setUseFK(col.useFK());
                        table = TableMeta.getTableName(model.extend());
                        cm.setRefTable(table);
                    }
                }
                cm.setPattern(col.pattern());
                if (col.type().equals("")) {
                    Class<?> javaBaseType = cm.getJavaBaseType();
                    if (javaBaseType == null) {
                        javaBaseType = field.getType() == Serializable.class ? OReflectUtil.searchGenType(clazz2, (Class)classes.get(classes.size() - 1), field.getGenericType()) : field.getType();
                        cm.setJavaBaseType(javaBaseType);
                    }
                    String type = TableMeta.transType(javaBaseType, col);
                    cm.setType(type);
                } else {
                    cm.setType(col.type().toLowerCase());
                }
                if (col.ref() != Void.TYPE && col.ref().getAnnotation(Model.class) != null) {
                    cm.setUseFK(col.useFK());
                    table = TableMeta.getTableName(col.ref());
                    cm.setRefTable(table);
                }
                if ((index = colOrder.indexOf(cm.getName())) < 0) {
                    colOrder.add(cm.getName());
                    columnMetas.add(cm);
                    continue;
                }
                columnMetas.set(index, cm);
            }
        }
        tm.setColumnMetas(columnMetas);
        tm.freshNameToField(entity);
        tm.freshConstraintMetaTable();
        tableCache.put(entity, tm);
        return tm;
    }

    public static String transType(Class<?> type, Col col) {
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return "int8";
        }
        if (type.equals(String.class)) {
            return String.format("varchar(%d)", col.size());
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return "int4";
        }
        if (type.equals(BigDecimal.class)) {
            return String.format("numeric(%d,%d)", col.precision(), col.scale());
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return "bool";
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return "int2";
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return "float4";
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return "float8";
        }
        if (type.equals(Timestamp.class)) {
            return "timestamptz";
        }
        if (type.isEnum()) {
            return "varchar(64)";
        }
        OAssert.fatal("\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b:%s", type);
        return null;
    }

    public static Class<?> parseType(String udtName, int size, int i) {
        if (udtName.equals("bool")) {
            return Boolean.TYPE;
        }
        if (udtName.equals("int2")) {
            return Short.TYPE;
        }
        if (udtName.equals("int4")) {
            return Integer.TYPE;
        }
        if (udtName.equals("int8")) {
            return Long.TYPE;
        }
        if (udtName.equals("float4")) {
            return Float.TYPE;
        }
        if (udtName.equals("float8")) {
            return Double.TYPE;
        }
        if (udtName.equals("numeric")) {
            return BigDecimal.class;
        }
        if (udtName.equals("varchar")) {
            return String.class;
        }
        if (udtName.equals("text")) {
            return String.class;
        }
        if (udtName.equals("timestamptz") || udtName.equals("timestamp")) {
            return Timestamp.class;
        }
        if (udtName.equals("time") || udtName.equals("date")) {
            return Date.class;
        }
        return Object.class;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
        this.freshConstraintMetaTable();
    }

    public List<ColumnMeta> getColumnMetas() {
        return this.columnMetas;
    }

    public BaseMeta getViewDef() {
        return this.viewDef;
    }

    public List<IndexMeta> getFieldConstraint() {
        return this.fieldConstraint;
    }

    public void setFieldConstraint(List<IndexMeta> fieldConstraint) {
        this.fieldConstraint = fieldConstraint;
    }

    public List<IndexMeta> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(List<IndexMeta> indexes) {
        this.indexes = indexes;
    }

    public ColumnMeta getColumnMetaByName(String colName) {
        return this.nameToColumnMeta.get(colName);
    }

    public void setColumnMetas(List<ColumnMeta> columnMetas) {
        this.columnMetas = columnMetas;
        this.nameToColumnMeta = new HashMap<String, ColumnMeta>(columnMetas.size());
        this.fieldConstraint = new ArrayList<IndexMeta>(columnMetas.size());
        for (ColumnMeta cm : columnMetas) {
            this.nameToColumnMeta.put(cm.name, cm);
        }
    }

    public void freshNameToField(Class<?> tblEntity) {
        ArrayList classes = new ArrayList();
        Class<?> clazz = tblEntity;
        while (!clazz.equals(Object.class)) {
            classes.add(0, clazz);
            clazz = clazz.getSuperclass();
        }
        HashSet<String> missed = new HashSet<String>(this.nameToColumnMeta.keySet());
        for (Class clazz2 : classes) {
            for (Field field : clazz2.getDeclaredFields()) {
                ColumnMeta cm = this.nameToColumnMeta.get(TableMeta.getColumnName(field));
                if (cm == null) continue;
                field.setAccessible(true);
                cm.setField(field);
                if (field.getType().equals(field.getGenericType())) {
                    cm.setJavaBaseType(field.getType());
                } else {
                    Class<?> jbt = OReflectUtil.searchGenType(clazz2, (Class)classes.get(classes.size() - 1), field.getGenericType());
                    cm.setJavaBaseType(jbt);
                }
                missed.remove(TableMeta.getColumnName(field));
            }
        }
        if (!missed.isEmpty()) {
            LOGGER.warn(String.format("\u4ee5\u4e0b\u5b57\u6bb5\u6ca1\u6709\u52a0\u8f7d\u5230Field %s", OUtils.toJson(missed)));
        }
    }

    public void freshConstraintMetaTable() {
        if (this.columnMetas != null && !this.columnMetas.isEmpty()) {
            this.nameToColumnMeta.clear();
            this.fieldConstraint = new ArrayList<IndexMeta>(this.columnMetas.size());
            for (ColumnMeta cm : this.columnMetas) {
                ArrayList<String> cols;
                IndexMeta cnsMeta;
                if (cm.isPrimaryKey()) {
                    cnsMeta = new IndexMeta();
                    cols = new ArrayList<String>();
                    cols.add(cm.getName());
                    cnsMeta.setColumns(new ArrayList<String>(cols));
                    cnsMeta.setTable(this.getTable());
                    cnsMeta.setName("pk_" + IndexMeta.indexName(cnsMeta.table) + "_" + cm.name);
                    cnsMeta.setUsing(cm.using);
                    cnsMeta.setType(IndexType.PRIMARY_KEY);
                    this.fieldConstraint.add(cnsMeta);
                } else if (cm.unique) {
                    cnsMeta = new IndexMeta();
                    cols = new ArrayList();
                    cols.add(cm.getName());
                    cnsMeta.setColumns(new ArrayList<String>(cols));
                    cnsMeta.setTable(this.getTable());
                    cnsMeta.setName("un_" + IndexMeta.indexName(cnsMeta.table) + "_" + cm.name);
                    cnsMeta.setUsing(cm.using);
                    cnsMeta.setType(IndexType.UNIQUE_FIELD);
                    this.fieldConstraint.add(cnsMeta);
                } else if (cm.useFK && cm.refTable != null) {
                    cnsMeta = new IndexMeta();
                    cols = new ArrayList();
                    cols.add(cm.getName());
                    cnsMeta.setColumns(new ArrayList<String>(cols));
                    cnsMeta.setTable(this.getTable());
                    cnsMeta.setName("fk_" + IndexMeta.indexName(cnsMeta.table) + "_" + cm.name);
                    cnsMeta.setUsing(cm.using);
                    cnsMeta.setType(IndexType.FOREIGN_KEY);
                    cnsMeta.setRefTable(cm.refTable);
                    this.fieldConstraint.add(cnsMeta);
                }
                this.nameToColumnMeta.put(cm.getName(), cm);
            }
        }
    }

    private List<String> alterColumnSql(List<ColumnMeta> columnMetas) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (ColumnMeta ocm : columnMetas) {
            String sql = String.format("ALTER TABLE %s ALTER COLUMN %s TYPE %s", this.table, ocm.name, ocm.type);
            if (!ocm.nullable) {
                sql = sql + String.format(", ALTER COLUMN %s SET NOT NULL", ocm.name);
            }
            sql = sql + ";";
            sqls.add(sql);
        }
        return sqls;
    }

    private String dftExp(ColumnMeta cm) {
        String dft = "";
        if (cm.getJavaBaseType().equals(String.class)) {
            dft = " DEFAULT '" + cm.defaultValue + "'";
        } else if (cm.defaultValue == null || cm.defaultValue.equals("")) {
            if (cm.getJavaBaseType().equals(Boolean.class) || cm.getJavaBaseType().equals(Boolean.TYPE)) {
                dft = " DEFAULT false";
            } else if (Number.class.isAssignableFrom(cm.getJavaBaseType())) {
                dft = " DEFAULT 0";
            }
        } else {
            dft = " DEFAULT " + cm.defaultValue;
        }
        return dft;
    }

    private List<String> addColumnSql(List<ColumnMeta> columnMetas) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (ColumnMeta ocm : columnMetas) {
            String sql = String.format("ALTER TABLE %s ADD COLUMN %s %s", this.table, ocm.name, ocm.type);
            if (!ocm.nullable) {
                sql = sql + String.format(" NOT NULL", new Object[0]);
            }
            String dft = this.dftExp(ocm);
            sql = sql + dft;
            sql = sql + ";";
            sqls.add(sql);
        }
        return sqls;
    }

    public SqlPlanBuilder createTableSql() {
        SqlPlanBuilder planBuilder = new SqlPlanBuilder();
        StringBuffer tbl = new StringBuffer();
        ArrayList<String> comments = new ArrayList<String>();
        int comaIndex = this.name().indexOf(46);
        if (comaIndex > -1) {
            String schema = this.name().substring(0, comaIndex);
            planBuilder.append(SqlPlanBuilder.CREATE_SCHEMA, this, String.format("CREATE SCHEMA IF NOT EXISTS %s;", schema));
        }
        if (this.type.equals((Object)ModelType.TABLE)) {
            tbl.append(String.format("CREATE TABLE %s (", this.table));
            for (ColumnMeta cm : this.columnMetas) {
                String dft = "";
                if (cm.defaultValue != null && !cm.defaultValue.equals("")) {
                    dft = this.dftExp(cm);
                }
                tbl.append(String.format("%s %s%s%s,", cm.name, cm.type, cm.nullable ? "" : " NOT NULL", dft));
                if (cm.comment == null || cm.comment.equals("")) continue;
                comments.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s';", this.table, cm.name, cm.comment));
            }
            tbl.delete(tbl.length() - 1, tbl.length());
            tbl.append(");");
            planBuilder.append(SqlPlanBuilder.CREATE_TABLE, this, tbl.toString());
            planBuilder.append(SqlPlanBuilder.ALTER, this, IndexMeta.addConstraintSql(this.fieldConstraint));
            planBuilder.append(SqlPlanBuilder.ALTER, this, IndexMeta.addConstraintSql(this.indexes));
            planBuilder.append(SqlPlanBuilder.COMMENT, this, comments);
        } else if (this.type.equals((Object)ModelType.VIEW)) {
            planBuilder.append(SqlPlanBuilder.DROP_VIEW, this, String.format("DROP VIEW IF EXISTS %s;", this.table));
            tbl.append(String.format("CREATE VIEW %s AS (", this.table));
            tbl.append(this.viewDef.toSql());
            tbl.append(");");
            planBuilder.append(SqlPlanBuilder.CREATE_VIEW, this, tbl.toString());
        } else if (this.type.equals((Object)ModelType.MATERIALIZED)) {
            planBuilder.append(SqlPlanBuilder.DROP_VIEW, this, String.format("DROP VIEW IF EXISTS %s;", this.table));
            tbl.append(String.format("CREATE MATERIALIZED VIEW %s AS (", this.table));
            tbl.append(this.viewDef.toSql());
            tbl.append(");");
            planBuilder.append(SqlPlanBuilder.CREATE_VIEW, this, tbl.toString());
        }
        return planBuilder;
    }

    public SqlPlanBuilder upgradeBy(TableMeta old) {
        if (!this.table.equals(old.table)) {
            return null;
        }
        if (this.type.equals((Object)ModelType.TABLE)) {
            return this.upgradeTableBy(old);
        }
        if (this.type.equals((Object)ModelType.VIEW)) {
            SqlPlanBuilder planBuilder = new SqlPlanBuilder();
            planBuilder.append(SqlPlanBuilder.DROP_VIEW, this, String.format("DROP VIEW IF EXISTS %s;", this.table));
            StringBuffer tbl = new StringBuffer();
            tbl.append(String.format("CREATE VIEW %s AS (", this.table));
            tbl.append(this.viewDef.toSql());
            tbl.append(");");
            planBuilder.append(SqlPlanBuilder.CREATE_VIEW, this, tbl.toString());
            return planBuilder;
        }
        if (this.type.equals((Object)ModelType.MATERIALIZED)) {
            SqlPlanBuilder planBuilder = new SqlPlanBuilder();
            planBuilder.append(SqlPlanBuilder.DROP_VIEW, this, String.format("DROP VIEW IF EXISTS %s;", this.table));
            StringBuffer tbl = new StringBuffer();
            tbl.append(String.format("CREATE MATERIALIZED VIEW %s AS (", this.table));
            tbl.append(this.viewDef.toSql());
            tbl.append(");");
            planBuilder.append(SqlPlanBuilder.CREATE_VIEW, this, tbl.toString());
            return planBuilder;
        }
        return new SqlPlanBuilder();
    }

    public SqlPlanBuilder upgradeTableBy(TableMeta old) {
        ArrayList<String> comments = new ArrayList<String>();
        ArrayList<ColumnMeta> newColumns = new ArrayList<ColumnMeta>();
        ArrayList<IndexMeta> dropIndexs = new ArrayList<IndexMeta>();
        ArrayList<IndexMeta> dropForeignKeys = new ArrayList<IndexMeta>();
        ArrayList<ColumnMeta> alterColumns = new ArrayList<ColumnMeta>();
        ArrayList<IndexMeta> addForeignKeys = new ArrayList<IndexMeta>();
        for (ColumnMeta newCm : this.columnMetas) {
            ColumnMeta oldCm = old.nameToColumnMeta.get(newCm.name);
            if (oldCm == null) {
                newColumns.add(newCm);
                if (newCm.comment == null || newCm.comment.equals("")) continue;
                comments.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s';", this.table, newCm.name, newCm.comment));
                continue;
            }
            if (oldCm.unique && !newCm.unique) {
                IndexMeta indexMeta = new IndexMeta();
                indexMeta.setColumns(Arrays.asList(newCm.getName()));
                indexMeta.setTable(this.table);
                indexMeta.setType(IndexType.UNIQUE_FIELD);
                indexMeta.setUsing(newCm.getUsing());
                dropIndexs.add(indexMeta);
            }
            if (oldCm.useFK && !newCm.useFK) {
                IndexMeta indexMeta = new IndexMeta();
                indexMeta.setColumns(Arrays.asList(oldCm.getName()));
                indexMeta.setTable(this.table);
                indexMeta.setType(IndexType.FOREIGN_KEY);
                indexMeta.setRefTable(oldCm.getRefTable());
                indexMeta.setUsing(oldCm.getUsing());
                dropForeignKeys.add(indexMeta);
            }
            if (!Objects.equals(oldCm.type, newCm.type) || !Objects.equals(oldCm.defaultValue, newCm.defaultValue) || oldCm.nullable != newCm.nullable) {
                alterColumns.add(newCm);
            }
            if (!oldCm.useFK && newCm.useFK && newCm.useFK && newCm.refTable != null) {
                IndexMeta indexMeta = new IndexMeta();
                indexMeta.setColumns(Arrays.asList(oldCm.getName()));
                indexMeta.setTable(this.table);
                indexMeta.setType(IndexType.FOREIGN_KEY);
                indexMeta.setRefTable(newCm.getRefTable());
                indexMeta.setUsing(newCm.getUsing());
                addForeignKeys.add(indexMeta);
            }
            if (Objects.equals(oldCm.comment, newCm.comment) || newCm.comment == null || newCm.comment.equals("")) continue;
            comments.add(String.format("COMMENT ON COLUMN \"%s\".\"%s\" IS '%s';", this.table, newCm.name, newCm.comment));
        }
        HashSet<String> oldConstraintSet = new HashSet<String>();
        HashSet<String> currentSet = new HashSet<String>();
        for (IndexMeta indexMeta : old.fieldConstraint) {
            oldConstraintSet.add(String.join((CharSequence)",", indexMeta.columns));
        }
        ArrayList<IndexMeta> addUniqueConstraint = new ArrayList<IndexMeta>();
        for (IndexMeta indexMeta : this.fieldConstraint) {
            currentSet.add(String.join((CharSequence)",", indexMeta.columns));
            if (oldConstraintSet.contains(String.join((CharSequence)",", indexMeta.columns))) continue;
            addUniqueConstraint.add(indexMeta);
        }
        ArrayList<IndexMeta> arrayList = new ArrayList<IndexMeta>();
        for (IndexMeta indexMeta : old.fieldConstraint) {
            if (currentSet.contains(String.join((CharSequence)",", indexMeta.columns))) continue;
            arrayList.add(indexMeta);
        }
        oldConstraintSet.clear();
        currentSet.clear();
        for (IndexMeta indexMeta : old.indexes) {
            oldConstraintSet.add(String.join((CharSequence)",", indexMeta.columns));
        }
        ArrayList<IndexMeta> arrayList2 = new ArrayList<IndexMeta>();
        for (IndexMeta indexMeta : this.indexes) {
            currentSet.add(String.join((CharSequence)",", indexMeta.columns));
            if (oldConstraintSet.contains(String.join((CharSequence)",", indexMeta.columns))) continue;
            arrayList2.add(indexMeta);
        }
        ArrayList<IndexMeta> arrayList3 = new ArrayList<IndexMeta>();
        for (IndexMeta tuple : old.indexes) {
            if (currentSet.contains(String.join((CharSequence)",", tuple.columns))) continue;
            arrayList3.add(tuple);
        }
        SqlPlanBuilder sqlPlanBuilder = new SqlPlanBuilder();
        sqlPlanBuilder.append(SqlPlanBuilder.ALTER, this, this.addColumnSql(newColumns));
        sqlPlanBuilder.append(SqlPlanBuilder.DROP, this, IndexMeta.dropConstraintSql(dropIndexs));
        sqlPlanBuilder.append(SqlPlanBuilder.DROP, this, IndexMeta.dropConstraintSql(dropForeignKeys));
        sqlPlanBuilder.append(SqlPlanBuilder.ALTER, this, this.alterColumnSql(alterColumns));
        sqlPlanBuilder.append(SqlPlanBuilder.ALTER, this, IndexMeta.addConstraintSql(addForeignKeys));
        sqlPlanBuilder.append(SqlPlanBuilder.DROP, this, IndexMeta.dropConstraintSql(arrayList));
        sqlPlanBuilder.append(SqlPlanBuilder.ALTER, this, IndexMeta.addConstraintSql(addUniqueConstraint));
        sqlPlanBuilder.append(SqlPlanBuilder.DROP, this, IndexMeta.dropConstraintSql(arrayList3));
        sqlPlanBuilder.append(SqlPlanBuilder.ALTER, this, IndexMeta.addConstraintSql(arrayList2));
        return sqlPlanBuilder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableMeta tableMeta = (TableMeta)o;
        return Objects.equals(this.table, tableMeta.table) && Objects.equals(this.viewDef, tableMeta.viewDef) && Objects.equals(this.indexes, tableMeta.indexes) && Objects.equals(this.columnMetas, tableMeta.columnMetas) && Objects.equals(this.nameToColumnMeta, tableMeta.nameToColumnMeta);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.viewDef, this.indexes, this.columnMetas, this.nameToColumnMeta);
    }

    public void validate(Object obj, boolean ignoreNull) {
        for (ColumnMeta cm : this.getColumnMetas()) {
            VolidateFailed vf;
            if (cm.getName().equals("id") || cm.getName().equals("rm")) continue;
            Object val = null;
            try {
                val = cm.getField().get(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
            if (!cm.isNullable() && val == null && !ignoreNull) {
                vf = VolidateFailed.createError("%s cannot be null", cm.getName());
                vf.put(cm.getName(), "cannot be null");
                vf.throwSelf();
                continue;
            }
            if (val == null || cm.getPattern().equals("") || !val.toString().matches(cm.getPattern())) continue;
            vf = VolidateFailed.createError("%s does not matches %s", cm.getName(), cm.getPattern());
            vf.put(cm.getName(), cm.getPattern());
            vf.throwSelf();
        }
    }

    public ModelType getType() {
        return this.type;
    }

    public void setType(ModelType type) {
        this.type = type;
    }
}

