/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.core.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import top.onceio.core.exception.Failed;
import top.onceio.core.util.Tuple3;

public class FieldPathPicker {
    List<Tuple3<Field, String, Integer>> fields = new ArrayList<Tuple3<Field, String, Integer>>();

    public FieldPathPicker(Class<?> clazz, String path) {
        int first = path.indexOf(46);
        String[] p = null;
        p = first >= 0 ? path.split("\\.") : new String[]{path};
        try {
            for (int i = 0; i < p.length; ++i) {
                String fieldName = p[i];
                int leftIndex = fieldName.indexOf(91);
                int rightIndex = fieldName.lastIndexOf(93);
                if (leftIndex >= 0 && rightIndex > leftIndex) {
                    String fn = fieldName.substring(0, leftIndex);
                    String idx = fieldName.substring(leftIndex + 1, rightIndex);
                    Field field = null;
                    if (!fn.isEmpty()) {
                        field = FieldPathPicker.getClassField(clazz, fn);
                        field.setAccessible(true);
                        clazz = field.getType();
                    }
                    this.fields.add(new Tuple3<Field, Object, Integer>(field, null, Integer.parseInt(idx)));
                    continue;
                }
                if (leftIndex < 0 && rightIndex < 0) {
                    if (Map.class.isAssignableFrom(clazz)) {
                        this.fields.add(new Tuple3<Object, String, Object>(null, fieldName, null));
                        continue;
                    }
                    Field field = FieldPathPicker.getClassField(clazz, fieldName);
                    field.setAccessible(true);
                    clazz = field.getType();
                    this.fields.add(new Tuple3<Field, Object, Object>(field, null, null));
                    continue;
                }
                Failed.throwError("%s \u4e0d\u5408\u6cd5", path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Failed.throwError(e.getMessage(), new Object[0]);
        }
    }

    private static Field getClassField(Class<?> clazz, String name) {
        while (true) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
                if (!(clazz = clazz.getSuperclass()).equals(Object.class)) continue;
                return null;
            }
            break;
        }
    }

    public Object getField(Object obj) {
        boolean found = true;
        for (Tuple3<Field, String, Integer> fieldPath : this.fields) {
            Field field = (Field)fieldPath.a;
            String fieldName = (String)fieldPath.b;
            Integer idx = (Integer)fieldPath.c;
            try {
                if (obj != null) {
                    if (field != null) {
                        obj = field.get(obj);
                    } else if (fieldName != null) {
                        obj = ((Map)obj).get(fieldName);
                    }
                    if (idx == null || idx < 0) continue;
                    if (obj instanceof Object[]) {
                        obj = ((Object[])obj)[idx];
                        continue;
                    }
                    if (obj instanceof List) {
                        obj = ((List)obj).get(idx);
                        continue;
                    }
                    if (obj instanceof int[]) {
                        obj = ((int[])obj)[idx];
                        continue;
                    }
                    if (obj instanceof short[]) {
                        obj = ((short[])obj)[idx];
                        continue;
                    }
                    if (obj instanceof char[]) {
                        obj = Character.valueOf(((char[])obj)[idx]);
                        continue;
                    }
                    if (obj instanceof byte[]) {
                        obj = ((byte[])obj)[idx];
                        continue;
                    }
                    if (obj instanceof float[]) {
                        obj = Float.valueOf(((float[])obj)[idx]);
                        continue;
                    }
                    if (obj instanceof boolean[]) {
                        obj = ((boolean[])obj)[idx];
                        continue;
                    }
                    if (obj instanceof double[]) {
                        obj = ((double[])obj)[idx];
                        continue;
                    }
                    if (!(obj instanceof long[])) continue;
                    obj = ((long[])obj)[idx];
                    continue;
                }
                found = false;
                break;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                found = false;
            }
        }
        if (found) {
            return obj;
        }
        return null;
    }
}

