/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.excel.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelClassHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelClassHelper.class);

    private static Map<String, Field> getNameToField(Class<?> clazz, Map<String, String> aliasToField) {
        HashSet<String> fieldNames = null;
        if (aliasToField != null) {
            fieldNames = new HashSet<String>(aliasToField.values());
        }
        HashMap<String, Field> nameToField = new HashMap<String, Field>();
        for (Class<?> sc = clazz; sc != null && !sc.equals(Object.class); sc = sc.getSuperclass()) {
            for (Field f : sc.getDeclaredFields()) {
                if (fieldNames == null) {
                    nameToField.put(f.getName(), f);
                    continue;
                }
                if (!fieldNames.contains(f.getName())) continue;
                nameToField.put(f.getName(), f);
            }
        }
        return nameToField;
    }

    private static Map<Field, Integer> build(Class<?> clazz, Map<String, String> aliasToField, Map<String, Integer> nameToIndex) {
        Map<String, Field> nameToField = ExcelClassHelper.getNameToField(clazz, aliasToField);
        HashMap<Field, Integer> fieldToIndex = new HashMap<Field, Integer>();
        for (Map.Entry<String, Integer> entry : nameToIndex.entrySet()) {
            Field f;
            String fn = entry.getKey();
            if (aliasToField != null && (fn = aliasToField.get(entry.getKey())) == null) {
                fn = entry.getKey();
            }
            if (fn == null || (f = nameToField.get(fn)) == null) continue;
            f.setAccessible(true);
            fieldToIndex.put(f, entry.getValue());
        }
        return fieldToIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> read(Class<T> clazz, Map<String, String> alias, String filepath) {
        List<T> result = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filepath);
            result = ExcelClassHelper.read(clazz, alias, filepath, fis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage());
                }
            }
        }
        return result;
    }

    public static <T> List<T> read(Class<T> clazz, Map<String, String> alias, String filename, InputStream is) {
        return ExcelClassHelper.read(clazz, alias, filename, is, true);
    }

    private static void fillObjectViaExcel(int valType, Cell cell, Field field, Object obj, boolean useTrim) throws IllegalAccessException {
        switch (valType) {
            case 0: {
                if (field.getType().equals(Date.class)) {
                    field.set(obj, cell.getDateCellValue());
                    break;
                }
                if (field.getType().equals(Long.class) && cell.getNumericCellValue() - (double)((long)cell.getNumericCellValue()) != 0.0) {
                    field.set(obj, cell.getDateCellValue().getTime());
                    break;
                }
                field.set(obj, ExcelClassHelper.parseNumber(cell.getNumericCellValue(), field.getType()));
                break;
            }
            case 1: {
                if (cell.getStringCellValue() == null) break;
                if (useTrim) {
                    field.set(obj, ExcelClassHelper.strToBaseType(field.getType(), cell.getStringCellValue().trim()));
                    break;
                }
                field.set(obj, ExcelClassHelper.strToBaseType(field.getType(), cell.getStringCellValue()));
                break;
            }
            case 4: {
                field.set(obj, cell.getBooleanCellValue());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> read(Class<T> clazz, Map<String, String> alias, String filename, InputStream is, boolean useTrim) {
        ArrayList<T> result = new ArrayList<T>();
        String ext = filename.substring(filename.lastIndexOf("."));
        HSSFWorkbook wb = null;
        int rowNum = 0;
        int colNum = 0;
        Cell cell = null;
        try {
            if (".xls".equals(ext)) {
                wb = new HSSFWorkbook(is);
            } else if (".xlsx".equals(ext)) {
                wb = new XSSFWorkbook(is);
            } else {
                throw new RuntimeException("\u6587\u4ef6\u683c\u5f0f\u53ea\u652f\u6301xls\u548cxlsx");
            }
            Sheet sheet = wb.getSheetAt(0);
            HashMap<String, Integer> nameToC = new HashMap<String, Integer>();
            Row row = sheet.getRow(sheet.getFirstRowNum());
            for (int c = row.getFirstCellNum(); c <= row.getLastCellNum(); ++c) {
                cell = row.getCell(c);
                if (cell == null) continue;
                if (useTrim && cell.getStringCellValue() != null) {
                    nameToC.put(cell.getStringCellValue().trim(), c);
                    continue;
                }
                nameToC.put(cell.getStringCellValue(), c);
            }
            Map<Field, Integer> fieldToIndex = ExcelClassHelper.build(clazz, alias, nameToC);
            for (rowNum = sheet.getFirstRowNum() + 1; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                row = sheet.getRow(rowNum);
                if (row == null) continue;
                T obj = clazz.newInstance();
                block33: for (Map.Entry<Field, Integer> entry : fieldToIndex.entrySet()) {
                    colNum = entry.getValue();
                    cell = row.getCell(entry.getValue().intValue());
                    Field field = entry.getKey();
                    if (cell == null) continue;
                    switch (cell.getCellType()) {
                        case 0: {
                            ExcelClassHelper.fillObjectViaExcel(0, cell, field, obj, useTrim);
                            break;
                        }
                        case 1: {
                            ExcelClassHelper.fillObjectViaExcel(1, cell, field, obj, useTrim);
                            break;
                        }
                        case 4: {
                            ExcelClassHelper.fillObjectViaExcel(4, cell, field, obj, useTrim);
                            break;
                        }
                        case 2: {
                            try {
                                if (field.getType().equals(Date.class)) {
                                    field.set(obj, cell.getDateCellValue());
                                    break;
                                }
                                if (field.getType().equals(Long.class) && cell.getNumericCellValue() - (double)((long)cell.getNumericCellValue()) != 0.0) {
                                    field.set(obj, cell.getDateCellValue().getTime());
                                    break;
                                }
                                if (field.getType().equals(String.class)) {
                                    field.set(obj, cell.getStringCellValue());
                                    break;
                                }
                                if (field.getType().equals(Boolean.class)) {
                                    field.set(obj, cell.getBooleanCellValue());
                                    break;
                                }
                                if (field.getType().equals(Integer.class) || field.getType().equals(Short.class) || field.getType().equals(Byte.class) || field.getType().equals(Float.class) || field.getType().equals(BigDecimal.class)) {
                                    field.set(obj, ExcelClassHelper.parseNumber(cell.getNumericCellValue(), field.getType()));
                                    break;
                                }
                                field.set(obj, ExcelClassHelper.strToBaseType(field.getType(), cell.getStringCellValue()));
                            }
                            catch (Exception exception) {
                                try {
                                    Double fdVal = cell.getNumericCellValue();
                                    if (fdVal != null) {
                                        ExcelClassHelper.fillObjectViaExcel(0, cell, field, obj, useTrim);
                                        break;
                                    }
                                }
                                catch (Exception fdVal) {
                                    // empty catch block
                                }
                                try {
                                    String fsVal = cell.getStringCellValue();
                                    if (fsVal != null) {
                                        ExcelClassHelper.fillObjectViaExcel(1, cell, field, obj, useTrim);
                                        break;
                                    }
                                }
                                catch (Exception fsVal) {
                                    // empty catch block
                                }
                                try {
                                    Boolean fbVal = cell.getBooleanCellValue();
                                    if (fbVal == null) continue block33;
                                    ExcelClassHelper.fillObjectViaExcel(4, cell, field, obj, useTrim);
                                }
                                catch (Exception exception2) {}
                            }
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 5: {
                            break;
                        }
                        default: {
                            LOGGER.info("\u672a\u77e5\u7c7b\u578b : ", (Object)cell.getCellType());
                        }
                    }
                }
                result.add(obj);
            }
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            LOGGER.error("Exception", (Throwable)e);
        }
        catch (IllegalStateException ex) {
            ex.printStackTrace();
            LOGGER.error("\u6570\u636e\u9519\u8bef:" + String.format("%s,%s", rowNum, colNum));
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void write(Class<T> clazz, List<T> data, Map<String, String> alias, String tplPath, String filepath) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(tplPath);
            fos = new FileOutputStream(filepath);
            ExcelClassHelper.write(clazz, data, alias, filepath, fis, fos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage());
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void write(Class<T> clazz, List<T> data, Map<String, String> alias, String filename, InputStream tplis, OutputStream os) {
        String ext = filename.substring(filename.lastIndexOf("."));
        HSSFWorkbook wb = null;
        if (tplis == null) {
            throw new RuntimeException("\u6a21\u677f\u4e0d\u53ef\u4e3anull");
        }
        if (os == null) {
            throw new RuntimeException("\u8f93\u51fa\u6d41\u4e0d\u53ef\u4e3a\u7a7a");
        }
        try {
            if (".xls".equals(ext)) {
                wb = new HSSFWorkbook(tplis);
            } else if (".xlsx".equals(ext)) {
                wb = new XSSFWorkbook(tplis);
            } else {
                throw new RuntimeException("\u4e0a\u6b21\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff08\u53ea\u652f\u6301xls\u548cxlsx\uff09");
            }
            Sheet sheet = wb.getSheetAt(0);
            HashMap<String, Integer> nameToC = new HashMap<String, Integer>();
            Row row = sheet.getRow(sheet.getFirstRowNum());
            int r = sheet.getFirstRowNum() + 1;
            Row example = sheet.getRow(r++);
            HashMap<Integer, Cell> egCell = new HashMap<Integer, Cell>();
            for (int c = row.getFirstCellNum(); c <= row.getLastCellNum(); ++c) {
                Cell cell = row.getCell(c);
                if (cell == null) continue;
                nameToC.put(cell.getStringCellValue(), c);
                egCell.put(c, example.getCell(c));
            }
            Map<Field, Integer> fieldToIndex = ExcelClassHelper.build(clazz, alias, nameToC);
            boolean isEg = true;
            for (T obj : data) {
                row = isEg ? example : sheet.createRow(r++);
                for (Map.Entry<Field, Integer> entry : fieldToIndex.entrySet()) {
                    Cell eg = (Cell)egCell.get(entry.getValue());
                    Field field = entry.getKey();
                    if (eg == null || field == null) continue;
                    Cell cell = null;
                    if (!isEg) {
                        cell = row.createCell(entry.getValue().intValue());
                        cell.setCellStyle(eg.getCellStyle());
                        cell.setCellType(eg.getCellType());
                        Comment cc = eg.getCellComment();
                        if (cc != null) {
                            cell.setCellComment(cc);
                        }
                    } else {
                        cell = row.getCell(entry.getValue().intValue());
                    }
                    Object val = field.get(obj);
                    if (val == null) continue;
                    ExcelClassHelper.fillCellValue(cell, val);
                }
                isEg = false;
            }
            wb.write(os);
        }
        catch (IOException | IllegalAccessException e) {
            e.printStackTrace();
            LOGGER.error("Exception", (Throwable)e);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            LOGGER.error("Exception", (Throwable)e);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage());
                }
            }
        }
    }

    public static void fillCellValue(Cell cell, Object val) {
        switch (cell.getCellType()) {
            case 0: {
                if (val instanceof Date) {
                    cell.setCellValue((Date)val);
                    break;
                }
                if (val instanceof Long) {
                    cell.setCellValue(Double.parseDouble(val.toString()));
                    break;
                }
                cell.setCellValue(Double.parseDouble(val.toString()));
                break;
            }
            case 1: {
                cell.setCellValue(val.toString());
                break;
            }
            case 4: {
                cell.setCellValue(Boolean.parseBoolean(val.toString()));
                break;
            }
            case 2: {
                cell.setCellFormula(val.toString());
                break;
            }
            case 3: {
                if (val instanceof String) {
                    cell.setCellValue((String)val);
                    break;
                }
                if (val instanceof Boolean) {
                    cell.setCellValue(((Boolean)val).booleanValue());
                    break;
                }
                if (val instanceof BigDecimal || val instanceof Integer || val instanceof Short || val instanceof Float || val instanceof Double || val instanceof Long) {
                    cell.setCellValue(Double.parseDouble(val.toString()));
                    break;
                }
                if (val instanceof Date) {
                    cell.setCellValue((Date)val);
                    break;
                }
                cell.setCellValue(val.toString());
                break;
            }
            case 5: {
                break;
            }
            default: {
                LOGGER.info("unresolve : ", (Object)cell.getCellType());
            }
        }
    }

    private static Object parseNumber(double val, Class<?> type) {
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return (long)val;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return (int)val;
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return (long)val;
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return val;
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf((float)val);
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return (byte)val;
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimal(val + "");
        }
        if (type.equals(String.class)) {
            if (val - (double)((long)val) == 0.0) {
                return (long)val + "";
            }
            return val + "";
        }
        return null;
    }

    private static <T> T strToBaseType(Class<T> type, String val) {
        if (val != null) {
            if (type.equals(String.class)) {
                return (T)val;
            }
            if (val.trim().equals("")) {
                return null;
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return (T)Integer.valueOf(val);
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return (T)Long.valueOf(val);
            }
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                return (T)Boolean.valueOf(val);
            }
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return (T)Byte.valueOf(val);
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return (T)Short.valueOf(val);
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return (T)Double.valueOf(val);
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return (T)Float.valueOf(val);
            }
            if (type.equals(BigDecimal.class)) {
                return (T)BigDecimal.valueOf(Double.valueOf(val));
            }
        }
        return null;
    }
}

