/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.excel.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelTplWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelTplWriter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String tplPath, int exampleRow, List<Object[]> data, String filepath) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(tplPath);
            fos = new FileOutputStream(filepath);
            ExcelTplWriter.write(fis, exampleRow, data, filepath, fos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage());
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage());
                }
            }
        }
    }

    public static void write(InputStream tplis, int exampleRow, List<Object[]> data, String filename, OutputStream os) {
        ExcelTplWriter.write(tplis, exampleRow, null, data, filename, os);
    }

    public static void fillCellValue(Cell cell, Object val, String comment) {
        switch (cell.getCellType()) {
            case 0: {
                if (val instanceof Date) {
                    cell.setCellValue((Date)val);
                    break;
                }
                if (val instanceof Long) {
                    cell.setCellValue(Double.parseDouble(val.toString()));
                    break;
                }
                cell.setCellValue(Double.parseDouble(val.toString()));
                break;
            }
            case 1: {
                cell.setCellValue(val.toString());
                break;
            }
            case 4: {
                cell.setCellValue(Boolean.parseBoolean(val.toString()));
                break;
            }
            case 2: {
                cell.setCellFormula(val.toString());
                break;
            }
            case 3: {
                if (val instanceof String) {
                    cell.setCellValue((String)val);
                    break;
                }
                if (val instanceof Boolean) {
                    cell.setCellValue(((Boolean)val).booleanValue());
                    break;
                }
                if (val instanceof BigDecimal || val instanceof Integer || val instanceof Short || val instanceof Float || val instanceof Double || val instanceof Long) {
                    cell.setCellValue(Double.parseDouble(val.toString()));
                    break;
                }
                if (val instanceof Date) {
                    cell.setCellValue((Date)val);
                    break;
                }
                cell.setCellValue(val.toString());
                break;
            }
            case 5: {
                break;
            }
            default: {
                LOGGER.info("unresolve : ", (Object)cell.getCellType());
            }
        }
    }

    public static void copyCell(Cell cell, int index, Row rowDes) {
        if (cell != null) {
            Cell dest = rowDes.createCell(index);
            dest.setCellType(cell.getCellType());
            dest.setCellStyle(cell.getCellStyle());
            switch (cell.getCellType()) {
                case 4: {
                    dest.setCellValue(cell.getBooleanCellValue());
                    break;
                }
                case 1: {
                    dest.setCellValue(cell.getStringCellValue());
                    break;
                }
                case 0: {
                    dest.setCellValue(cell.getNumericCellValue());
                    break;
                }
                case 2: {
                    dest.setCellValue(cell.getCellFormula());
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    dest.setCellValue((double)cell.getErrorCellValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(InputStream tplis, int exampleRow, List<String> heads, List<Object[]> data, String filename, OutputStream os) {
        String ext = filename.substring(filename.lastIndexOf("."));
        HSSFWorkbook wb = null;
        XSSFWorkbook wbEg = null;
        try {
            Cell cell;
            if (".xls".equals(ext)) {
                wb = new HSSFWorkbook(tplis);
            } else if (".xlsx".equals(ext)) {
                wbEg = new XSSFWorkbook(tplis);
                wb = new SXSSFWorkbook(wbEg, 100);
            } else {
                throw new RuntimeException("\u4e0a\u6b21\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff08\u53ea\u652f\u6301xls\u548cxlsx\uff09");
            }
            Sheet sheetEg = wb.getSheetAt(0);
            int r = exampleRow;
            if (heads != null) {
                Row headRow = sheetEg.getRow(exampleRow - 1);
                int offset = headRow.getLastCellNum() - heads.size();
                for (int i = 0; i < heads.size(); ++i) {
                    cell = headRow.getCell(i + offset);
                    cell.setCellValue(heads.get(i));
                }
            }
            Row example = sheetEg.getRow(r);
            HashMap<Integer, Cell> egCell = new HashMap<Integer, Cell>();
            for (int c = example.getFirstCellNum(); c <= example.getLastCellNum(); ++c) {
                cell = example.getCell(c);
                if (cell == null) continue;
                egCell.put(c, example.getCell(c));
            }
            Sheet sheet = wb.createSheet();
            for (int i = 0; i < r; ++i) {
                Row rowEg = sheetEg.getRow(i);
                Row rowDes = sheet.createRow(i);
                for (int c = rowEg.getFirstCellNum(); c <= rowEg.getLastCellNum(); ++c) {
                    Cell cell2 = rowEg.getCell(c);
                    ExcelTplWriter.copyCell(cell2, c, rowDes);
                    sheet.setColumnWidth(c, sheetEg.getColumnWidth(c));
                }
            }
            Row row = null;
            for (Object[] objs : data) {
                row = sheet.createRow(r);
                for (int i = 0; i < objs.length; ++i) {
                    Cell eg = (Cell)egCell.get(i);
                    Cell cell3 = row.createCell(i);
                    Object val = objs[i];
                    String comment = null;
                    int cellType = 1;
                    if (eg != null) {
                        cell3.setCellType(eg.getCellType());
                        cell3.setCellStyle(eg.getCellStyle());
                        Comment cc = eg.getCellComment();
                        cellType = cell3.getCellType();
                        if (cc != null) {
                            comment = cc.getString().getString();
                        }
                    }
                    if (eg == null || val == null) continue;
                    ExcelTplWriter.fillCellValue(cell3, val, comment);
                }
                ++r;
            }
            wb.removeSheetAt(0);
            wb.write(os);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("Exception", (Throwable)e);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage());
                }
            }
            if (wbEg != null) {
                try {
                    wbEg.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LOGGER.error(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeByColumn(InputStream tplis, int startRow, int exampleCol, List<Object[]> data, String filename, OutputStream os) {
        String ext = filename.substring(filename.lastIndexOf("."));
        HSSFWorkbook wb = null;
        XSSFWorkbook wbEg = null;
        try {
            Cell cell;
            int c;
            Row rowDes;
            int i;
            if (".xls".equals(ext)) {
                wb = new HSSFWorkbook(tplis);
            } else if (".xlsx".equals(ext)) {
                wbEg = new XSSFWorkbook(tplis);
                wb = new SXSSFWorkbook(wbEg, 100);
            } else {
                throw new RuntimeException("\u4e0a\u6b21\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff08\u53ea\u652f\u6301xls\u548cxlsx\uff09");
            }
            Sheet sheetEg = wbEg.getSheetAt(0);
            int r = startRow;
            HashMap<Integer, Cell> egCell = new HashMap<Integer, Cell>();
            for (int c2 = startRow; c2 <= sheetEg.getLastRowNum(); ++c2) {
                Row example = sheetEg.getRow(c2);
                Cell cell2 = example.getCell(exampleCol);
                if (cell2 == null) continue;
                egCell.put(c2, cell2);
            }
            Sheet sheet = wb.createSheet();
            for (i = 0; i < startRow; ++i) {
                Row rowEg = sheetEg.getRow(i);
                if (rowEg == null) continue;
                rowDes = sheet.createRow(i);
                for (c = rowEg.getFirstCellNum(); c <= rowEg.getLastCellNum(); ++c) {
                    cell = rowEg.getCell(c);
                    ExcelTplWriter.copyCell(cell, c, rowDes);
                }
            }
            for (i = startRow; i <= sheetEg.getLastRowNum(); ++i) {
                Row example = sheetEg.getRow(i);
                rowDes = sheet.createRow(i);
                for (c = 0; c < exampleCol; ++c) {
                    cell = example.getCell(c);
                    ExcelTplWriter.copyCell(cell, c, rowDes);
                }
            }
            Row row = null;
            for (int colNum = 0; colNum < data.size(); ++colNum) {
                Object[] objs = data.get(colNum);
                if (objs == null) continue;
                for (int i2 = 0; i2 < objs.length; ++i2) {
                    Object val;
                    Cell eg = (Cell)egCell.get(startRow + i2);
                    row = sheet.getRow(startRow + i2);
                    Cell cell3 = row.createCell(colNum + exampleCol);
                    cell3.setCellStyle(eg.getCellStyle());
                    cell3.setCellType(eg.getCellType());
                    Comment cc = eg.getCellComment();
                    String comment = null;
                    if (cc != null) {
                        comment = cc.getString().getString();
                    }
                    if ((val = objs[i2]) == null) continue;
                    ExcelTplWriter.fillCellValue(cell3, val, comment);
                }
                ++r;
            }
            wb.removeSheetAt(0);
            wb.write(os);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("Exception", (Throwable)e);
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
            if (wbEg != null) {
                try {
                    wbEg.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
    }

    private static Object parseNumber(double val, Class<?> type) {
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return (long)val;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return (int)val;
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return (long)val;
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return val;
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf((float)val);
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return (byte)val;
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimal(val);
        }
        return null;
    }

    private static <T> T strToBaseType(Class<T> type, String val) {
        if (val == null) {
            return null;
        }
        if (type.equals(String.class)) {
            return (T)val;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return (T)Integer.valueOf(val);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return (T)Long.valueOf(val);
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return (T)Boolean.valueOf(val);
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return (T)Byte.valueOf(val);
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return (T)Short.valueOf(val);
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return (T)Double.valueOf(val);
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return (T)Float.valueOf(val);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)BigDecimal.valueOf(Double.valueOf(val));
        }
        return null;
    }
}

