/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.plugins.servlet;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import top.onceio.core.annotation.BeansIn;
import top.onceio.core.beans.ApiMethod;
import top.onceio.core.beans.ApiPair;
import top.onceio.core.beans.ApiResover;
import top.onceio.core.beans.BeansEden;
import top.onceio.core.exception.Failed;
import top.onceio.plugins.servlet.ApiPairAdaptor;

public class OIODispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Gson GSON = new Gson();

    public void init() throws ServletException {
        super.init();
        String launcherClass = this.getInitParameter("launcher");
        try {
            Class<?> cnf = Class.forName(launcherClass);
            OIODispatcherServlet.loadBeans(cnf);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static void loadBeans(Class<?> cnf) {
        BeansIn beansPackage = cnf.getDeclaredAnnotation(BeansIn.class);
        if (beansPackage != null && beansPackage.value().length != 0) {
            BeansEden.get().resovle(beansPackage.value());
        } else {
            String pkg = cnf.getPackage().getName();
            BeansEden.get().resovle(new String[]{pkg});
        }
    }

    public void destroy() {
        super.destroy();
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("non-HTTP request or response");
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        request.setCharacterEncoding("UTF-8");
        response.setCharacterEncoding("UTF-8");
        resp.setHeader("Content-type", "application/json;charset=UTF-8");
        String localUri = req.getRequestURI().substring(req.getContextPath().length());
        ApiPair apiPair = this.search(ApiMethod.valueOf((String)req.getMethod()), localUri);
        ApiPairAdaptor adaptor = new ApiPairAdaptor(apiPair);
        if (apiPair != null) {
            try {
                Object obj = adaptor.invoke(req, resp);
                if (obj != null) {
                    PrintWriter writer = resp.getWriter();
                    GSON.toJson(obj, (Appendable)writer);
                    writer.close();
                }
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof Failed) {
                    Failed failed = (Failed)target;
                    HashMap<String, Object> r = new HashMap<String, Object>();
                    r.put("msg", String.format(failed.getFormat(), failed.getArgs()));
                    r.put("data", failed.getData());
                    PrintWriter writer = resp.getWriter();
                    GSON.toJson(r, (Appendable)writer);
                    writer.close();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                resp.sendError(500, e.getMessage());
                e.printStackTrace();
            }
        } else {
            resp.sendError(404, String.format("Not found: %s %s", req.getMethod(), req.getRequestURI()));
        }
    }

    public ApiPair search(ApiMethod apiMethod, String uri) {
        ApiResover ar = BeansEden.get().getApiResover();
        String target = apiMethod.name() + ":" + uri;
        for (String api : ar.getApis()) {
            if (!target.matches(api)) continue;
            return (ApiPair)ar.getPatternToApi().get(api);
        }
        return null;
    }
}

