/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.plugins.servlet;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import top.onceio.core.beans.ApiPair;

public class ApiPairAdaptor {
    private ApiPair apiPair;
    private static final Gson GSON = new Gson();

    public ApiPairAdaptor(ApiPair ap) {
        this.apiPair = ap;
    }

    public Object[] resoveReqParams(final HttpServletRequest req, final HttpServletResponse resp) {
        Class<?> type;
        Map nameVarIndex = this.apiPair.getNameVarIndex();
        Map typeIndex = this.apiPair.getTypeIndex();
        Method method = this.apiPair.getMethod();
        Map paramNameArgIndex = this.apiPair.getParamNameArgIndex();
        Map attrNameArgIndex = this.apiPair.getAttrNameArgIndex();
        JsonObject json = null;
        try {
            json = (JsonObject)GSON.fromJson((Reader)req.getReader(), JsonObject.class);
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            e.printStackTrace();
        }
        if (json == null) {
            json = new JsonObject();
        }
        String uri = req.getRequestURI().substring(req.getContextPath().length());
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String[] uris = uri.split("/");
        for (Object name : nameVarIndex.keySet()) {
            Integer n = (Integer)nameVarIndex.get(name);
            String v = uris[n];
            json.addProperty((String)name, v);
        }
        Map map = req.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            String[] vals = (String[])entry.getValue();
            String name = (String)entry.getKey();
            String[] ps = name.split("\\.");
            String pname = name;
            JsonObject jobj = json;
            if (ps.length > 0) {
                pname = ps[ps.length - 1];
                jobj = ApiPairAdaptor.getOrCreateFatherByPath(json, ps);
            }
            if (vals != null && vals.length == 1) {
                jobj.addProperty(pname, vals[0]);
                continue;
            }
            JsonArray ja = new JsonArray();
            for (String v : vals) {
                ja.add(v);
            }
            jobj.add(pname, (JsonElement)ja);
        }
        final Object[] args = new Object[method.getParameterCount()];
        Class<?>[] classArray = method.getParameterTypes();
        if (paramNameArgIndex != null && !paramNameArgIndex.isEmpty()) {
            for (Map.Entry entry : paramNameArgIndex.entrySet()) {
                type = classArray[(Integer)entry.getKey()];
                if (((String)entry.getValue()).equals("")) {
                    args[((Integer)entry.getKey()).intValue()] = GSON.fromJson((JsonElement)json, type);
                    continue;
                }
                args[((Integer)entry.getKey()).intValue()] = GSON.fromJson(json.get((String)entry.getValue()), type);
            }
        }
        if (paramNameArgIndex != null && !paramNameArgIndex.isEmpty()) {
            for (Map.Entry entry : paramNameArgIndex.entrySet()) {
                type = classArray[(Integer)entry.getKey()];
                if (((String)entry.getValue()).equals("")) {
                    args[((Integer)entry.getKey()).intValue()] = GSON.fromJson((JsonElement)json, type);
                    continue;
                }
                args[((Integer)entry.getKey()).intValue()] = GSON.fromJson(json.get((String)entry.getValue()), type);
            }
        }
        if (attrNameArgIndex != null && !attrNameArgIndex.isEmpty()) {
            for (Map.Entry entry : attrNameArgIndex.entrySet()) {
                args[((Integer)entry.getKey()).intValue()] = req.getAttribute((String)entry.getValue());
            }
        }
        if (typeIndex != null && !typeIndex.isEmpty()) {
            typeIndex.forEach(new BiConsumer<Class<?>, Integer>(){

                @Override
                public void accept(Class<?> cls, Integer i) {
                    if (HttpServletRequest.class.isAssignableFrom(cls)) {
                        args[i.intValue()] = req;
                    } else if (HttpServletResponse.class.isAssignableFrom(cls)) {
                        args[i.intValue()] = resp;
                    }
                }
            });
        }
        return args;
    }

    private static JsonObject getOrCreateFatherByPath(JsonObject json, String[] ps) {
        JsonObject jobj = json;
        for (int i = 0; i < ps.length - 1; ++i) {
            String p = ps[i];
            if ((jobj = jobj.getAsJsonObject(p)) != null) continue;
            jobj = new JsonObject();
            jobj.add(p, (JsonElement)jobj);
        }
        return jobj;
    }

    public Object invoke(HttpServletRequest req, HttpServletResponse resp) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] args = this.resoveReqParams(req, resp);
        Object obj = this.apiPair.getMethod().invoke(this.apiPair.getBean(), args);
        return obj;
    }
}

