/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.plugins.vertx;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.sql.Date;
import java.util.Map;
import java.util.function.BiConsumer;
import top.onceio.core.beans.ApiPair;
import top.onceio.core.db.dao.Cnd;
import top.onceio.core.db.dao.DaoHolder;
import top.onceio.core.db.dao.tpl.SelectTpl;
import top.onceio.core.db.dao.tpl.UpdateTpl;
import top.onceio.core.util.OLog;
import top.onceio.core.util.OReflectUtil;

public class ApiPairAdaptor {
    private ApiPair apiPair;

    public ApiPairAdaptor(ApiPair ap) {
        this.apiPair = ap;
    }

    public void resoveReqParams(HttpServerRequest req) {
    }

    private static JsonObject getOrCreateFatherByPath(JsonObject json, String[] ps) {
        JsonObject jobj = json;
        for (int i = 0; i < ps.length - 1; ++i) {
            String p = ps[i];
            if ((jobj = jobj.getJsonObject(p)) != null) continue;
            jobj = new JsonObject();
            jobj.put(p, jobj);
        }
        return jobj;
    }

    private Object[] resoveArgs(final HttpServerRequest req, Buffer event) {
        Map nameVarIndex = this.apiPair.getNameVarIndex();
        Map typeIndex = this.apiPair.getTypeIndex();
        Method method = this.apiPair.getMethod();
        Map paramNameArgIndex = this.apiPair.getParamNameArgIndex();
        Map attrNameArgIndex = this.apiPair.getAttrNameArgIndex();
        JsonObject json = null;
        if (event.length() > 0) {
            json = event.toJsonObject();
        }
        if (json == null) {
            json = new JsonObject();
        }
        String uri = req.path();
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String[] uris = uri.split("/");
        for (Object name : nameVarIndex.keySet()) {
            Integer i = (Integer)nameVarIndex.get(name);
            String v = uris[i];
            json.put((String)name, v);
        }
        MultiMap map = req.params();
        for (Map.Entry entry : map.entries()) {
            Object jval;
            String val = (String)entry.getValue();
            String name = (String)entry.getKey();
            String[] ps = name.split("\\.");
            String pname = name;
            JsonObject jobj = json;
            if (ps.length > 0) {
                pname = ps[ps.length - 1];
                jobj = ApiPairAdaptor.getOrCreateFatherByPath(json, ps);
            }
            if ((jval = jobj.getValue(pname)) == null) {
                jobj.put(pname, val);
                continue;
            }
            if (jval instanceof JsonArray) {
                ((JsonArray)jval).add(val);
                continue;
            }
            JsonArray ja = new JsonArray();
            ja.add(jval);
            ja.add(val);
            jobj.put(pname, ja);
        }
        final Object[] args = new Object[method.getParameterCount()];
        Class<?>[] types = this.apiPair.getMethod().getParameterTypes();
        if (paramNameArgIndex != null && !paramNameArgIndex.isEmpty()) {
            for (Map.Entry entry : paramNameArgIndex.entrySet()) {
                Class<Object> type = types[(Integer)entry.getKey()];
                if (((String)entry.getValue()).equals("")) {
                    args[((Integer)entry.getKey()).intValue()] = json.mapTo(type);
                    continue;
                }
                if (DaoHolder.class.isAssignableFrom(this.apiPair.getBean().getClass())) {
                    TypeVariable t = DaoHolder.class.getTypeParameters()[0];
                    Class tblClass = OReflectUtil.searchGenType(DaoHolder.class, this.apiPair.getBean().getClass(), t);
                    String argStr = json.getString((String)entry.getValue());
                    if (type.isAssignableFrom(Cnd.class) && args[(Integer)entry.getKey()] == null) {
                        args[((Integer)entry.getKey()).intValue()] = new Cnd(tblClass, argStr);
                        continue;
                    }
                    if (type.isAssignableFrom(SelectTpl.class) && args[(Integer)entry.getKey()] == null) {
                        args[((Integer)entry.getKey()).intValue()] = new SelectTpl(tblClass, argStr);
                        continue;
                    }
                    if (type.isAssignableFrom(UpdateTpl.class) && args[(Integer)entry.getKey()] == null) {
                        args[((Integer)entry.getKey()).intValue()] = new UpdateTpl(tblClass, argStr);
                        continue;
                    }
                    args[((Integer)entry.getKey()).intValue()] = this.trans(json, (String)entry.getValue(), type);
                    continue;
                }
                args[((Integer)entry.getKey()).intValue()] = this.trans(json, (String)entry.getValue(), type);
            }
        }
        if (attrNameArgIndex != null && !attrNameArgIndex.isEmpty()) {
            for (Map.Entry entry : attrNameArgIndex.entrySet()) {
                args[((Integer)entry.getKey()).intValue()] = req.getFormAttribute((String)entry.getValue());
            }
        }
        if (typeIndex != null && !typeIndex.isEmpty()) {
            typeIndex.forEach(new BiConsumer<Class<?>, Integer>(){

                @Override
                public void accept(Class<?> cls, Integer i) {
                    if (HttpServerRequest.class.isAssignableFrom(cls)) {
                        args[i.intValue()] = req;
                    }
                }
            });
        }
        return args;
    }

    private Object trans(JsonObject obj, String key, Class<?> type) {
        if (obj != null) {
            if (type.equals(String.class)) {
                return obj.getString(key);
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return obj.getInteger(key);
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return obj.getLong(key);
            }
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                return obj.getBoolean(key);
            }
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return obj.getBinary(key)[0];
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return obj.getInteger(key);
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return obj.getDouble(key);
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return obj.getFloat(key);
            }
            if (type.equals(BigDecimal.class)) {
                return new BigDecimal(obj.getString(key));
            }
            if (type.equals(Date.class)) {
                return new Date(obj.getLong(key));
            }
            return obj.getJsonObject(key).mapTo(type);
        }
        return null;
    }

    public void invoke(final HttpServerRequest req) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        req.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer event) {
                req.response().putHeader("Content-Type", "application/json");
                Object[] args = ApiPairAdaptor.this.resoveArgs(req, event);
                Object obj = null;
                String msg = null;
                try {
                    obj = ApiPairAdaptor.this.apiPair.getMethod().invoke(ApiPairAdaptor.this.apiPair.getBean(), args);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    msg = e.getMessage();
                    e.printStackTrace();
                }
                if (obj != null) {
                    req.response().end(Json.encode((Object)obj));
                } else {
                    if (msg == null) {
                        msg = "ERROR";
                    }
                    req.response().end(msg);
                }
            }
        });
        req.exceptionHandler(handler -> OLog.error((String)handler.getMessage(), (Object[])new Object[0]));
    }
}

