/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.plugins.vertx;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import top.onceio.core.beans.ApiPair;
import top.onceio.core.db.dao.DaoHolder;
import top.onceio.core.db.dao.tpl.Cnd;
import top.onceio.core.db.dao.tpl.SelectTpl;
import top.onceio.core.db.dao.tpl.UpdateTpl;
import top.onceio.core.db.tbl.OEntity;
import top.onceio.core.util.OLog;
import top.onceio.core.util.OReflectUtil;

public class ApiPairAdaptor {
    private ApiPair apiPair;

    public ApiPairAdaptor(ApiPair ap) {
        this.apiPair = ap;
    }

    private static JsonObject getOrCreateFatherByPath(JsonObject json, String[] ps) {
        JsonObject jobj = json;
        for (int i = 0; i < ps.length - 1; ++i) {
            String p = ps[i];
            if ((jobj = jobj.getJsonObject(p)) != null) continue;
            jobj = new JsonObject();
            jobj.put(p, jobj);
        }
        return jobj;
    }

    private Object[] detectCallbackableArgs(RoutingContext event) {
        Map typeIndex = this.apiPair.getTypeIndex();
        Method method = this.apiPair.getMethod();
        Object[] args = new Object[method.getParameterCount()];
        if (typeIndex != null && !typeIndex.isEmpty()) {
            boolean has = false;
            for (Map.Entry entry : typeIndex.entrySet()) {
                Class cls = (Class)entry.getKey();
                Integer i = (Integer)entry.getValue();
                if (RoutingContext.class.isAssignableFrom(cls)) {
                    args[i.intValue()] = event;
                    has = true;
                    continue;
                }
                if (!HttpServerRequest.class.isAssignableFrom(cls)) continue;
                args[i.intValue()] = event.request();
                has = true;
            }
            if (has) {
                return args;
            }
        }
        return null;
    }

    private Object[] resoveArgs(RoutingContext event) {
        Map nameVarIndex = this.apiPair.getNameVarIndex();
        Map typeIndex = this.apiPair.getTypeIndex();
        Method method = this.apiPair.getMethod();
        Object[] args = new Object[method.getParameterCount()];
        Map paramNameArgIndex = this.apiPair.getParamNameArgIndex();
        Map cookieNameArgIndex = this.apiPair.getCookieNameArgIndex();
        Map headerNameArgIndex = this.apiPair.getHeaderNameArgIndex();
        Map attrNameArgIndex = this.apiPair.getAttrNameArgIndex();
        JsonObject json = null;
        if (event.getBody().length() > 0) {
            json = event.getBodyAsJson();
        }
        if (json == null) {
            json = new JsonObject();
        }
        String uri = event.normalisedPath();
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String[] uris = uri.split("/");
        for (Object name : nameVarIndex.keySet()) {
            Integer i = (Integer)nameVarIndex.get(name);
            String v = uris[i];
            json.put((String)name, v);
        }
        MultiMap map = event.queryParams();
        for (Iterator entry : map.entries()) {
            Object jval;
            String val = (String)entry.getValue();
            String string = (String)entry.getKey();
            String[] ps = string.split("\\.");
            String pname = string;
            JsonObject jobj = json;
            if (ps.length > 0) {
                pname = ps[ps.length - 1];
                jobj = ApiPairAdaptor.getOrCreateFatherByPath(json, ps);
            }
            if ((jval = jobj.getValue(pname)) == null) {
                jobj.put(pname, val);
                continue;
            }
            if (jval instanceof JsonArray) {
                ((JsonArray)jval).add(val);
                continue;
            }
            JsonArray ja = new JsonArray();
            ja.add(jval);
            ja.add(val);
            jobj.put(pname, ja);
        }
        Class<?>[] types = this.apiPair.getMethod().getParameterTypes();
        if (paramNameArgIndex != null && !paramNameArgIndex.isEmpty()) {
            for (Map.Entry entry : paramNameArgIndex.entrySet()) {
                Class<?> clazz = types[(Integer)entry.getKey()];
                if (DaoHolder.class.isAssignableFrom(this.apiPair.getBean().getClass())) {
                    String strId;
                    String argStr;
                    TypeVariable t = DaoHolder.class.getTypeParameters()[0];
                    Class tblClass = OReflectUtil.searchGenType(DaoHolder.class, this.apiPair.getBean().getClass(), t);
                    if (Cnd.class.isAssignableFrom(clazz) && args[(Integer)entry.getKey()] == null) {
                        String orderby;
                        String pagesize;
                        String page;
                        StringBuilder sb = new StringBuilder();
                        String argStr2 = json.getString((String)entry.getValue());
                        if (argStr2 != null) {
                            sb.append("cnd=" + argStr2);
                        }
                        if ((page = json.getString("page")) != null && !page.equals("")) {
                            sb.append("&page=" + page);
                        }
                        if ((pagesize = json.getString("pagesize")) != null && !pagesize.equals("")) {
                            sb.append("&pagesize=" + pagesize);
                        }
                        if ((orderby = json.getString("orderby")) != null && !orderby.equals("")) {
                            sb.append("&orderby=" + orderby);
                        }
                        args[((Integer)entry.getKey()).intValue()] = new Cnd(tblClass, sb.toString());
                        continue;
                    }
                    if (SelectTpl.class.isAssignableFrom(clazz) && args[(Integer)entry.getKey()] == null) {
                        argStr = json.getString((String)entry.getValue());
                        if (argStr == null || argStr.equals("")) {
                            args[((Integer)entry.getKey()).intValue()] = null;
                            continue;
                        }
                        args[((Integer)entry.getKey()).intValue()] = new SelectTpl(tblClass, argStr);
                        continue;
                    }
                    if (UpdateTpl.class.isAssignableFrom(clazz) && args[(Integer)entry.getKey()] == null) {
                        argStr = json.getString((String)entry.getValue());
                        if (argStr == null || argStr.equals("")) {
                            args[((Integer)entry.getKey()).intValue()] = null;
                            continue;
                        }
                        args[((Integer)entry.getKey()).intValue()] = new UpdateTpl(tblClass, argStr);
                        continue;
                    }
                    if (((String)entry.getValue()).equals("id")) {
                        argStr = json.getString((String)entry.getValue());
                        args[((Integer)entry.getKey()).intValue()] = Long.parseLong(argStr);
                        continue;
                    }
                    if (((String)entry.getValue()).equals("ids")) {
                        argStr = json.getString((String)entry.getValue());
                        String[] sIds = argStr.split(",");
                        ArrayList<Long> ids = new ArrayList<Long>(sIds.length);
                        for (String id : sIds) {
                            ids.add(Long.parseLong(id));
                        }
                        args[((Integer)entry.getKey()).intValue()] = ids;
                        continue;
                    }
                    args[((Integer)entry.getKey()).intValue()] = this.trans(json, (String)entry.getValue(), tblClass);
                    if (!OEntity.class.isAssignableFrom(clazz) || (strId = json.getString("id")) == null) continue;
                    Long id = Long.parseLong(strId);
                    if (args[(Integer)entry.getKey()] == null) continue;
                    ((OEntity)args[(Integer)entry.getKey()]).setId(id);
                    continue;
                }
                if (((String)entry.getValue()).equals("")) {
                    args[((Integer)entry.getKey()).intValue()] = json.mapTo(clazz);
                    continue;
                }
                args[((Integer)entry.getKey()).intValue()] = this.trans(json, (String)entry.getValue(), clazz);
            }
            if (typeIndex != null && !typeIndex.isEmpty()) {
                for (Map.Entry entry : typeIndex.entrySet()) {
                    Class clazz = (Class)entry.getKey();
                    Integer i = (Integer)entry.getValue();
                    args[i.intValue()] = json.mapTo(clazz);
                }
            }
        }
        if (cookieNameArgIndex != null && !cookieNameArgIndex.isEmpty()) {
            for (Map.Entry entry : cookieNameArgIndex.entrySet()) {
                args[((Integer)entry.getKey()).intValue()] = event.getCookie((String)entry.getValue());
            }
        }
        if (headerNameArgIndex != null && !headerNameArgIndex.isEmpty()) {
            HttpServerRequest req = event.request();
            for (Map.Entry entry : headerNameArgIndex.entrySet()) {
                args[((Integer)entry.getKey()).intValue()] = req.getHeader((String)entry.getValue());
            }
        }
        if (attrNameArgIndex != null && !attrNameArgIndex.isEmpty()) {
            for (Map.Entry entry : attrNameArgIndex.entrySet()) {
                args[((Integer)entry.getKey()).intValue()] = event.get((String)entry.getValue());
            }
        }
        return args;
    }

    private Object trans(JsonObject obj, String key, Class<?> type) {
        if (obj != null) {
            if (type.equals(String.class)) {
                return obj.getString(key);
            }
            if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                return obj.getInteger(key);
            }
            if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                return obj.getLong(key);
            }
            if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                return obj.getBoolean(key);
            }
            if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                return obj.getBinary(key)[0];
            }
            if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                return obj.getInteger(key);
            }
            if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                return obj.getDouble(key);
            }
            if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                return obj.getFloat(key);
            }
            if (type.equals(BigDecimal.class)) {
                return new BigDecimal(obj.getString(key));
            }
            if (type.equals(Date.class)) {
                return new Date(obj.getLong(key));
            }
            if (!"".equals(key)) {
                JsonObject jobj = obj.getJsonObject(key);
                if (jobj != null) {
                    return jobj.mapTo(type);
                }
                return null;
            }
            return obj.mapTo(type);
        }
        return null;
    }

    public void invoke(RoutingContext event) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] callbackableArgs = this.detectCallbackableArgs(event);
        if (callbackableArgs == null) {
            Object[] args = this.resoveArgs(event);
            HttpServerRequest req = event.request();
            req.response().putHeader("Content-Type", "application/json");
            Object obj = null;
            String msg = null;
            Class<?> returnType = this.apiPair.getMethod().getReturnType();
            try {
                obj = this.apiPair.getMethod().invoke(this.apiPair.getBean(), args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                msg = e.getMessage();
            }
            if (!returnType.equals(Void.TYPE) && !returnType.equals(Void.class)) {
                if (obj != null) {
                    req.response().end(Json.encode((Object)obj));
                } else {
                    req.response().end(msg);
                }
            }
            req.exceptionHandler(handler -> OLog.error((String)handler.getMessage(), (Object[])new Object[0]));
        } else {
            this.apiPair.getMethod().invoke(this.apiPair.getBean(), callbackableArgs);
        }
    }
}

