/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.plugins.vertx;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.impl.RouterImpl;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import top.onceio.core.annotation.BeansIn;
import top.onceio.core.beans.ApiPair;
import top.onceio.core.beans.ApiResover;
import top.onceio.core.beans.BeansEden;
import top.onceio.plugins.vertx.ApiPairAdaptor;
import top.onceio.plugins.vertx.VertxSockJSHandler;
import top.onceio.plugins.vertx.VertxWebSocketHandler;
import top.onceio.plugins.vertx.annotation.AsSock;
import top.onceio.plugins.vertx.annotation.AsWebsocket;

public class OIOVerticle
extends AbstractVerticle {
    protected HttpServer httpServer;
    protected Router router;

    protected void createHttpServerAndRouter() {
        this.httpServer = this.vertx.createHttpServer();
        this.router = new RouterImpl(this.vertx);
    }

    protected void initBeans() {
        EventBus eb = this.vertx.eventBus();
        BeansEden.get().store(EventBus.class, null, (Object)eb);
        BeansIn pkgConf = ((Object)((Object)this)).getClass().getAnnotation(BeansIn.class);
        String[] confDir = null;
        String[] pkgs = null;
        if (pkgConf != null) {
            pkgs = pkgConf.value();
            confDir = pkgConf.conf();
        } else {
            String pkg = ((Object)((Object)this)).getClass().getName();
            pkgs = new String[]{pkg.substring(0, pkg.lastIndexOf(46))};
            confDir = new String[]{"conf"};
        }
        BeansEden.get().addAnnotation(new Class[]{AsSock.class, AsWebsocket.class});
        BeansEden.get().resovle(confDir, pkgs);
    }

    protected void initRouter() {
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)BodyHandler.create());
        ApiResover ar = BeansEden.get().getApiResover();
        Map p2ap = ar.getPatternToApi();
        p2ap.forEach(new BiConsumer<String, ApiPair>(){

            @Override
            public void accept(String key, ApiPair apiPair) {
                int sp = key.indexOf(58);
                String method = key.substring(0, sp);
                String uri = key.substring(sp + 1);
                HttpMethod httpMethod = HttpMethod.valueOf((String)method);
                Handler handler = event -> {
                    ApiPairAdaptor adaptor = new ApiPairAdaptor(apiPair);
                    try {
                        adaptor.invoke((RoutingContext)event);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new RuntimeException(e.getMessage());
                    }
                };
                if (uri.contains("[^/]+")) {
                    if (httpMethod != null) {
                        OIOVerticle.this.router.routeWithRegex(httpMethod, uri).handler(handler);
                    } else {
                        OIOVerticle.this.router.routeWithRegex(uri).handler(handler);
                    }
                } else if (httpMethod != null) {
                    OIOVerticle.this.router.route(httpMethod, uri).handler(handler);
                } else {
                    OIOVerticle.this.router.route(uri).handler(handler);
                }
            }
        });
        this.router.exceptionHandler(eh -> eh.printStackTrace());
    }

    protected void startServer() {
        int port = this.config().getInteger("port", Integer.valueOf(1230));
        Set websockets = BeansEden.get().getClassByAnnotation(AsWebsocket.class);
        if (!websockets.isEmpty()) {
            Class wsh = (Class)websockets.iterator().next();
            Object bean = BeansEden.get().load(wsh);
            if (bean != null && bean instanceof VertxWebSocketHandler) {
                VertxWebSocketHandler webSocketHandler = (VertxWebSocketHandler)bean;
                this.httpServer.websocketHandler((Handler)webSocketHandler);
            }
        }
        Set classes = BeansEden.get().getClassByAnnotation(AsSock.class);
        for (Class clazz : classes) {
            VertxSockJSHandler vertxSockJSHandler;
            AsSock sock;
            Object bean = BeansEden.get().load(clazz);
            if (bean == null || !(bean instanceof VertxSockJSHandler) || (sock = (vertxSockJSHandler = (VertxSockJSHandler)bean).getClass().getAnnotation(AsSock.class)) == null) continue;
            SockJSHandler sockJSHandler = SockJSHandler.create((Vertx)this.vertx, (SockJSHandlerOptions)vertxSockJSHandler.getSockJSHandlerOptions());
            sockJSHandler.socketHandler(vertxSockJSHandler.getSocketHandler());
            if (sock.prefix().endsWith("*")) {
                this.router.route(sock.prefix()).handler((Handler)sockJSHandler);
                continue;
            }
            this.router.route(sock.prefix() + "/*").handler((Handler)sockJSHandler);
        }
        this.httpServer.requestHandler(arg_0 -> ((Router)this.router).accept(arg_0)).listen(port);
    }

    public void start() throws Exception {
        this.createHttpServerAndRouter();
        this.initBeans();
        this.initRouter();
        this.startServer();
    }
}

