/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.plugins.vertx;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import top.onceio.core.annotation.Validate;
import top.onceio.core.beans.ApiPair;
import top.onceio.core.db.annotation.Tbl;
import top.onceio.core.db.dao.DaoHolder;
import top.onceio.core.db.dao.tpl.Cnd;
import top.onceio.core.db.dao.tpl.SelectTpl;
import top.onceio.core.db.dao.tpl.UpdateTpl;
import top.onceio.core.exception.Failed;
import top.onceio.core.util.OReflectUtil;
import top.onceio.core.util.OUtils;

public class ApiPairAdaptor {
    private ApiPair apiPair;

    public ApiPairAdaptor(ApiPair ap) {
        this.apiPair = ap;
    }

    private static JsonObject getOrCreateFatherByPath(JsonObject json, String[] ps) {
        JsonObject jobj = json;
        for (int i = 0; i < ps.length - 1; ++i) {
            String p = ps[i];
            if ((jobj = jobj.getJsonObject(p)) != null) continue;
            jobj = new JsonObject();
            jobj.put(p, jobj);
        }
        return jobj;
    }

    private Object[] detectCallbackableArgs(RoutingContext event) {
        Map typeIndex = this.apiPair.getTypeIndex();
        Method method = this.apiPair.getMethod();
        Object[] args = new Object[method.getParameterCount()];
        if (typeIndex != null && !typeIndex.isEmpty()) {
            boolean has = false;
            for (Map.Entry entry : typeIndex.entrySet()) {
                Class cls = (Class)entry.getKey();
                Integer i = (Integer)entry.getValue();
                if (RoutingContext.class.isAssignableFrom(cls)) {
                    args[i.intValue()] = event;
                    has = true;
                    continue;
                }
                if (!HttpServerRequest.class.isAssignableFrom(cls)) continue;
                args[i.intValue()] = event.request();
                has = true;
            }
            if (has) {
                return args;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Object[] resoveArgs(RoutingContext event) {
        void var17_30;
        Class<?> type;
        Map nameVarIndex = this.apiPair.getNameVarIndex();
        Map typeIndex = this.apiPair.getTypeIndex();
        Method method = this.apiPair.getMethod();
        Object[] args = new Object[method.getParameterCount()];
        Map paramNameArgIndex = this.apiPair.getParamNameArgIndex();
        Map cookieNameArgIndex = this.apiPair.getCookieNameArgIndex();
        Map headerNameArgIndex = this.apiPair.getHeaderNameArgIndex();
        Map attrNameArgIndex = this.apiPair.getAttrNameArgIndex();
        JsonObject json = null;
        if (event.getBody().length() > 0) {
            json = event.getBodyAsJson();
        }
        if (json == null) {
            json = new JsonObject();
        }
        String uri = event.normalisedPath();
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String[] uris = uri.split("/");
        for (Object name : nameVarIndex.keySet()) {
            Integer i = (Integer)nameVarIndex.get(name);
            String v = uris[i];
            json.put((String)name, v);
        }
        MultiMap map = event.queryParams();
        for (Iterator entry : map.entries()) {
            Object jval;
            String val = (String)entry.getValue();
            String string = (String)entry.getKey();
            String[] ps = string.split("\\.");
            String pname = string;
            JsonObject jobj = json;
            if (ps.length > 0) {
                pname = ps[ps.length - 1];
                jobj = ApiPairAdaptor.getOrCreateFatherByPath(json, ps);
            }
            if ((jval = jobj.getValue(pname)) == null) {
                jobj.put(pname, val);
                continue;
            }
            if (jval instanceof JsonArray) {
                ((JsonArray)jval).add(val);
                continue;
            }
            JsonArray ja = new JsonArray();
            ja.add(jval);
            ja.add(val);
            jobj.put(pname, ja);
        }
        Class<?>[] types = this.apiPair.getMethod().getParameterTypes();
        if (paramNameArgIndex != null && !paramNameArgIndex.isEmpty()) {
            for (Map.Entry entry : paramNameArgIndex.entrySet()) {
                Class<?> clazz = types[(Integer)entry.getKey()];
                if (DaoHolder.class.isAssignableFrom(this.apiPair.getBean().getClass())) {
                    String argStr;
                    TypeVariable t = DaoHolder.class.getTypeParameters()[0];
                    Class tblClass = OReflectUtil.searchGenType(DaoHolder.class, this.apiPair.getBean().getClass(), t);
                    if (Cnd.class.isAssignableFrom(clazz) && args[(Integer)entry.getKey()] == null) {
                        String orderby;
                        String pagesize;
                        String page;
                        StringBuilder sb = new StringBuilder();
                        String argStr2 = json.getString((String)entry.getValue());
                        if (argStr2 != null) {
                            sb.append("cnd=" + argStr2);
                        }
                        if ((page = json.getString("page")) != null && !page.equals("")) {
                            sb.append("&page=" + page);
                        }
                        if ((pagesize = json.getString("pagesize")) != null && !pagesize.equals("")) {
                            sb.append("&pagesize=" + pagesize);
                        }
                        if ((orderby = json.getString("orderby")) != null && !orderby.equals("")) {
                            sb.append("&orderby=" + orderby);
                        }
                        args[((Integer)entry.getKey()).intValue()] = new Cnd(tblClass, sb.toString());
                        continue;
                    }
                    if (SelectTpl.class.isAssignableFrom(clazz) && args[(Integer)entry.getKey()] == null) {
                        argStr = json.getString((String)entry.getValue());
                        if (argStr == null || argStr.equals("")) {
                            args[((Integer)entry.getKey()).intValue()] = null;
                            continue;
                        }
                        args[((Integer)entry.getKey()).intValue()] = new SelectTpl(tblClass, argStr);
                        continue;
                    }
                    if (UpdateTpl.class.isAssignableFrom(clazz) && args[(Integer)entry.getKey()] == null) {
                        argStr = json.getString((String)entry.getValue());
                        if (argStr == null || argStr.equals("")) {
                            args[((Integer)entry.getKey()).intValue()] = null;
                            continue;
                        }
                        args[((Integer)entry.getKey()).intValue()] = new UpdateTpl(tblClass, argStr);
                        continue;
                    }
                    if (!((String)entry.getValue()).equals("")) {
                        args[((Integer)entry.getKey()).intValue()] = this.trans(json, (String)entry.getValue(), clazz);
                        continue;
                    }
                    args[((Integer)entry.getKey()).intValue()] = this.trans(json, (String)entry.getValue(), tblClass);
                    continue;
                }
                args[((Integer)entry.getKey()).intValue()] = this.trans(json, (String)entry.getValue(), clazz);
            }
            if (typeIndex != null && !typeIndex.isEmpty()) {
                for (Map.Entry entry : typeIndex.entrySet()) {
                    Class clazz = (Class)entry.getKey();
                    Integer i = (Integer)entry.getValue();
                    args[i.intValue()] = json.mapTo(clazz);
                }
            }
        }
        if (cookieNameArgIndex != null && !cookieNameArgIndex.isEmpty()) {
            for (Map.Entry entry : cookieNameArgIndex.entrySet()) {
                Cookie cookie = event.getCookie((String)entry.getValue());
                if (cookie == null) continue;
                type = types[(Integer)entry.getKey()];
                args[((Integer)entry.getKey()).intValue()] = this.trans(cookie.getValue(), type);
            }
        }
        if (headerNameArgIndex != null && !headerNameArgIndex.isEmpty()) {
            HttpServerRequest req = event.request();
            for (Map.Entry entry : headerNameArgIndex.entrySet()) {
                type = types[(Integer)entry.getKey()];
                args[((Integer)entry.getKey()).intValue()] = this.trans(req.getHeader((String)entry.getValue()), type);
            }
        }
        if (attrNameArgIndex != null && !attrNameArgIndex.isEmpty()) {
            for (Map.Entry entry : attrNameArgIndex.entrySet()) {
                Class<?> clazz = types[(Integer)entry.getKey()];
                args[((Integer)entry.getKey()).intValue()] = this.trans(event.get((String)entry.getValue()), clazz);
            }
        }
        Validate[] validates = new Validate[types.length];
        Tbl[] tbls = new Tbl[types.length];
        boolean bl = false;
        while (var17_30 < validates.length) {
            validates[var17_30] = this.apiPair.getMethod().getParameters()[var17_30].getAnnotation(Validate.class);
            tbls[var17_30] = types[var17_30].getAnnotation(Tbl.class);
            ++var17_30;
        }
        return args;
    }

    public Object trans(Object val, Class<?> type) {
        if (val == null) {
            return null;
        }
        if (type.equals(String.class)) {
            return val.toString();
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return Integer.valueOf(val.toString());
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return Long.valueOf(val.toString());
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return Boolean.valueOf(val.toString());
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return Byte.valueOf(val.toString());
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return Short.valueOf(val.toString());
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return Double.valueOf(val.toString());
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return Float.valueOf(val.toString());
        }
        if (type.equals(BigDecimal.class)) {
            return new BigDecimal(val.toString());
        }
        if (type.equals(Date.class)) {
            return new Date(Long.valueOf(val.toString()));
        }
        return null;
    }

    private Object trans(JsonObject obj, String key, Class<?> type) {
        if (obj != null) {
            if (!"".equals(key)) {
                Object val = obj.getValue(key);
                if (val == null) {
                    return val;
                }
                Class<?> valType = val.getClass();
                if (valType.equals(type)) {
                    return val;
                }
                if (type.equals(String.class)) {
                    return val.toString();
                }
                if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
                    return Integer.valueOf(val.toString());
                }
                if (type.equals(Long.TYPE) || type.equals(Long.class)) {
                    return Long.valueOf(val.toString());
                }
                if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                    return Boolean.valueOf(val.toString());
                }
                if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
                    return obj.getBinary(key)[0];
                }
                if (type.equals(Short.TYPE) || type.equals(Short.class)) {
                    return Short.valueOf(val.toString());
                }
                if (type.equals(Double.TYPE) || type.equals(Double.class)) {
                    return Double.valueOf(val.toString());
                }
                if (type.equals(Float.TYPE) || type.equals(Float.class)) {
                    return Float.valueOf(val.toString());
                }
                if (type.equals(BigDecimal.class)) {
                    return new BigDecimal(val.toString());
                }
                if (type.equals(Date.class)) {
                    return new Date(Long.valueOf(val.toString()));
                }
                if (valType.equals(String.class)) {
                    return Json.decodeValue((String)((String)val), type);
                }
                JsonObject jobj = obj.getJsonObject(key);
                if (jobj != null) {
                    return jobj.mapTo(type);
                }
                return null;
            }
            return obj.mapTo(type);
        }
        return null;
    }

    public void invoke(RoutingContext event) {
        block15: {
            Object obj = null;
            Object[] callbackableArgs = this.detectCallbackableArgs(event);
            if (callbackableArgs == null) {
                Object[] args = this.resoveArgs(event);
                HttpServerRequest req = event.request();
                req.response().headers().set("Content-Type", "application/json;charset=utf-8");
                String origin = req.getHeader("Origin");
                if (origin != null) {
                    req.response().headers().set("Access-Control-Allow-Origin", origin);
                }
                req.response().headers().set("Access-Control-Allow-Credentials", "true");
                req.response().headers().set("Access-Control-Allow-Methods", "GET,POST,PUT,PATCH,DELETE,HEAD,OPTIONS,TRACE");
                req.response().headers().set("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept, Cookie, userId, accessToken");
                Class<?> returnType = this.apiPair.getMethod().getReturnType();
                try {
                    obj = this.apiPair.getMethod().invoke(this.apiPair.getBean(), args);
                    if (!returnType.equals(Void.TYPE) && !returnType.equals(Void.class) && obj != null) {
                        req.response().end(OUtils.toJson((Object)obj));
                        break block15;
                    }
                    req.response().end("{}");
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    req.response().end(e.getMessage());
                }
                catch (InvocationTargetException e) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Throwable te = e.getTargetException();
                    if (te instanceof Failed) {
                        Failed failed = (Failed)te;
                        map.put("data", failed.getData());
                        map.put("args", failed.getArgs());
                        map.put("format", failed.getFormat());
                        map.put("ERROR", String.format(failed.getFormat(), failed.getArgs()));
                    } else {
                        if (te.getMessage() != null && !te.getMessage().equals("")) {
                            map.put("ERROR", te.getMessage());
                        } else {
                            map.put("ERROR", te.getClass().getName());
                        }
                        ArrayList<String> trace = new ArrayList<String>(te.getStackTrace().length);
                        for (StackTraceElement ste : te.getStackTrace()) {
                            trace.add(ste.getFileName() + ":" + ste.getLineNumber() + " " + ste.getMethodName());
                        }
                        map.put("stacktrace", trace);
                        req.response().setStatusCode(500);
                        te.printStackTrace();
                    }
                    req.response().end(OUtils.toJson(map));
                }
            } else {
                try {
                    this.apiPair.getMethod().invoke(this.apiPair.getBean(), callbackableArgs);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    }
}

