/*
 * Decompiled with CFR 0.152.
 */
package top.onceio.plugins.springboot;

import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import top.onceio.core.beans.ApiMethod;
import top.onceio.core.db.dao.Cnd;
import top.onceio.core.db.dao.Dao;
import top.onceio.core.db.dao.Page;
import top.onceio.core.db.dao.impl.DaoHelper;
import top.onceio.core.db.dao.tpl.SelectTpl;
import top.onceio.core.db.dao.tpl.UpdateTpl;
import top.onceio.core.db.tbl.OEntity;
import top.onceio.core.mvc.annocations.Api;
import top.onceio.core.mvc.annocations.Param;
import top.onceio.core.util.OReflectUtil;

public abstract class SpringDaoHolder<T extends OEntity>
implements Dao<T> {
    @Autowired
    protected DaoHelper daoHelper;
    private Class<T> tbl;

    public SpringDaoHolder() {
        TypeVariable t = SpringDaoHolder.class.getTypeParameters()[0];
        this.tbl = OReflectUtil.searchGenType(SpringDaoHolder.class, this.getClass(), t);
    }

    public DaoHelper getDaoHelper() {
        return this.daoHelper;
    }

    public void setDaoHelper(DaoHelper daoHelper) {
        this.daoHelper = daoHelper;
    }

    @Api(method={ApiMethod.GET, ApiMethod.POST})
    public T get(@Param(value="id") Long id) {
        this.daoHelper.get(this.tbl, id);
        return (T)this.daoHelper.get(this.tbl, id);
    }

    @Api(method={ApiMethod.PUT})
    public T insert(@Param(value="entity") T entity) {
        return (T)this.daoHelper.insert(entity);
    }

    @Api(method={ApiMethod.PUT})
    public int batchInsert(@Param(value="entities") List<T> entities) {
        return this.daoHelper.batchInsert(entities);
    }

    @Api(method={ApiMethod.PUT})
    public int update(@Param(value="entity") T entity) {
        return this.daoHelper.update(entity);
    }

    @Api(method={ApiMethod.PATCH})
    public int updateIgnoreNull(@Param(value="entity") T entity) {
        return this.daoHelper.updateIgnoreNull(entity);
    }

    public int updateByTpl(UpdateTpl<T> tpl) {
        return this.daoHelper.updateByTpl(this.tbl, tpl);
    }

    @Api(method={ApiMethod.PATCH})
    public int updateByTplCnd(@Param(value="tpl") UpdateTpl<T> tpl, @Param(value="cnd") Cnd<T> cnd) {
        return this.daoHelper.updateByTplCnd(this.tbl, tpl, cnd);
    }

    @Api(method={ApiMethod.REMOVE, ApiMethod.GET})
    public int removeById(@Param(value="id") Long id) {
        return this.daoHelper.removeById(this.tbl, id);
    }

    @Api(method={ApiMethod.REMOVE})
    public int removeByIds(@Param(value="ids") List<Long> ids) {
        return this.daoHelper.removeByIds(this.tbl, ids);
    }

    @Api(method={ApiMethod.REMOVE})
    public int remove(@Param(value="cnd") Cnd<T> cnd) {
        return this.daoHelper.remove(this.tbl, cnd);
    }

    @Api(method={ApiMethod.RECOVERY})
    public int recovery(@Param(value="cnd") Cnd<T> cnd) {
        return this.daoHelper.recovery(this.tbl, cnd);
    }

    public int deleteById(Long id) {
        return this.daoHelper.deleteById(this.tbl, id);
    }

    public int deleteByIds(List<Long> ids) {
        return this.daoHelper.deleteByIds(this.tbl, ids);
    }

    public int delete(Cnd<T> cnd) {
        return this.daoHelper.delete(this.tbl, cnd);
    }

    @Api(method={ApiMethod.RECOVERY})
    public T fetch(@Param(value="tpl") SelectTpl<T> tpl, @Param(value="cnd") Cnd<T> cnd) {
        return (T)this.daoHelper.fetch(this.tbl, tpl, cnd);
    }

    @Api(method={ApiMethod.GET, ApiMethod.POST})
    public List<T> findByIds(@Param(value="ids") List<Long> ids) {
        return this.daoHelper.findByIds(this.tbl, ids);
    }

    @Api(method={ApiMethod.GET, ApiMethod.POST})
    public Page<T> find(@Param(value="cnd") Cnd<T> cnd) {
        return this.daoHelper.find(this.tbl, cnd);
    }

    @Api(method={ApiMethod.GET, ApiMethod.POST})
    public Page<T> findTpl(@Param(value="tpl") SelectTpl<T> tpl, @Param(value="cnd") Cnd<T> cnd) {
        return this.daoHelper.findByTpl(this.tbl, tpl, cnd);
    }

    @Api(method={ApiMethod.GET, ApiMethod.POST})
    public void download(@Param(value="tpl") SelectTpl<T> tpl, @Param(value="cnd") Cnd<T> cnd, Consumer<T> consumer) {
        this.daoHelper.download(this.tbl, tpl, cnd, consumer);
    }

    public long count() {
        return this.daoHelper.count(this.tbl);
    }

    public long count(Cnd<T> cnd) {
        return this.daoHelper.count(this.tbl, cnd);
    }
}

