/*
 * Decompiled with CFR 0.152.
 */
package top.oneyoung.portal.aspect;

import javax.validation.ConstraintViolationException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import top.oneyoung.common.message.ErrorCodeException;
import top.oneyoung.common.result.Result;
import top.oneyoung.common.result.Results;

@Aspect
@Component
@Order
public class ServiceThrowableAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceThrowableAspect.class);

    @Pointcut(value="execution(* top.oneyoung.portal.controller.*.*(..))")
    public void service() {
    }

    @Around(value="service()")
    public Result<Object> processService(ProceedingJoinPoint joinPoint) {
        return this.processService0(joinPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result<Object> processService0(ProceedingJoinPoint joinPoint) {
        this.printEntranceLog(joinPoint);
        long startTime = System.currentTimeMillis();
        Result result = null;
        Throwable throwable = null;
        try {
            Result result2 = result = (Result)joinPoint.proceed();
            return result2;
        }
        catch (ErrorCodeException e) {
            Result result3 = result = e.toResult();
            return result3;
        }
        catch (IllegalArgumentException | UnsupportedOperationException t) {
            throwable = t;
            Result result4 = result = Results.failIllegalArgument((String)t.getMessage());
            return result4;
        }
        catch (ConstraintViolationException t) {
            Result result5 = result = Results.failValidation((ConstraintViolationException)t);
            return result5;
        }
        catch (Throwable t) {
            throwable = t;
            Result result6 = result = Results.failException((Throwable)t);
            return result6;
        }
        finally {
            long costTime = System.currentTimeMillis() - startTime;
            this.printResultLog(joinPoint, costTime, result, throwable);
        }
    }

    private void printEntranceLog(ProceedingJoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        LOGGER.info("EntranceLog class {}, method {}, args {}", new Object[]{signature.getDeclaringTypeName(), signature.getName(), joinPoint.getArgs()});
    }

    private void printResultLog(ProceedingJoinPoint joinPoint, long costTime, Object result, Throwable throwable) {
        Signature signature = joinPoint.getSignature();
        if (throwable != null) {
            LOGGER.error("ResultLog {}#{} costTime {}, result={}", new Object[]{signature.getDeclaringTypeName(), signature.getName(), costTime, result, throwable});
        } else {
            LOGGER.info("ResultLog {}#{} costTime {}, result={}", new Object[]{signature.getDeclaringTypeName(), signature.getName(), costTime, result});
        }
    }
}

