/*
 * Decompiled with CFR 0.152.
 */
package top.oneyoung.portal;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;
import top.oneyoung.common.result.Result;
import top.oneyoung.common.result.Results;

@ControllerAdvice
public class GlobalControllerExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalControllerExceptionHandler.class);

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        Result result = Results.failException((Exception)ex);
        ResponseEntity resultResponseEntity = ResponseEntity.badRequest().body((Object)result);
        if (ex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException validException = (MethodArgumentNotValidException)ex;
            BindingResult bindingResult = validException.getBindingResult();
            List fieldErrors = bindingResult.getFieldErrors();
            StringBuilder stringBuilder = new StringBuilder();
            for (FieldError error : fieldErrors) {
                String objectName = error.getObjectName();
                String field = error.getField();
                String defaultMessage = error.getDefaultMessage();
                Object rejectedValue = error.getRejectedValue();
                String message = "object '" + objectName + "' field '" + field + "': rejected value [" + ObjectUtils.nullSafeToString((Object)rejectedValue) + "] message [ " + defaultMessage + " ];";
                stringBuilder.append(message);
            }
            result = Results.failIllegalArgument((String)stringBuilder.toString());
            resultResponseEntity = ResponseEntity.badRequest().body((Object)result);
        }
        if (ex instanceof NoHandlerFoundException) {
            resultResponseEntity = ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)result);
        }
        log.error("request error, error result: " + result, (Throwable)ex);
        return resultResponseEntity;
    }
}

