/*
 * Decompiled with CFR 0.152.
 */
package top.osjf.filewatch.application.startup;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.osjf.filewatch.AmapleWatchEvent;
import top.osjf.filewatch.TriggerKind;
import top.osjf.filewatch.TriggerKindMatchedFileWatchListener;
import top.osjf.filewatch.application.startup.StartupJarElement;

public class ApplicationStartupFileWatchListener
extends TriggerKindMatchedFileWatchListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationStartupFileWatchListener.class);
    private Map<Path, Map<Path, StartupJarElement>> startupJarElementMap;

    public ApplicationStartupFileWatchListener(List<StartupJarElement> elements) {
        this.initStartupJarElementMap(elements);
    }

    void initStartupJarElementMap(List<StartupJarElement> elements) {
        if (elements == null || elements.isEmpty()) {
            throw new IllegalArgumentException("elements not be empty");
        }
        this.startupJarElementMap = elements.stream().collect(Collectors.groupingByConcurrent(startupJarElement -> Paths.get(startupJarElement.getBindPath(), new String[0]), Collectors.toMap(startupJarElement -> Paths.get(startupJarElement.getJarFileName(), new String[0]), Function.identity())));
    }

    public boolean supports(AmapleWatchEvent watchEvent) {
        Path parent = watchEvent.getParent();
        StartupJarElement jarElement = this.getEventJarElement(watchEvent);
        boolean bindPathEq = jarElement != null && parent.equals(Paths.get(jarElement.getBindPath(), new String[0]));
        return bindPathEq && super.supports(watchEvent);
    }

    protected List<TriggerKind> getSupportTriggerKinds(AmapleWatchEvent watchEvent) {
        StartupJarElement jarElement = this.getEventJarElement(watchEvent);
        return jarElement != null ? Arrays.asList(jarElement.getTriggerKinds()) : Collections.emptyList();
    }

    private StartupJarElement getEventJarElement(AmapleWatchEvent watchEvent) {
        Path parent = watchEvent.getParent();
        Path jarFilePath = watchEvent.context();
        Map<Path, StartupJarElement> jarGroup = this.startupJarElementMap.get(parent);
        return jarGroup != null ? jarGroup.get(jarFilePath) : null;
    }

    public void onWatchEvent(AmapleWatchEvent watchEvent) {
        Path parent = watchEvent.getParent();
        Path jarFilePath = watchEvent.context();
        StartupJarElement jarElement = this.startupJarElementMap.get(parent).get(jarFilePath);
        List<String> sortedStartupCommands = ApplicationStartupFileWatchListener.wrapWithBashShell(jarElement.getSortedStartupCommands());
        try {
            Process process = new ProcessBuilder(sortedStartupCommands).start();
            if (process.waitFor(jarElement.getTimeout(), jarElement.getUnit())) {
                String errorOutput = ApplicationStartupFileWatchListener.copyToString(process.getErrorStream());
                if (process.exitValue() == 0) {
                    LOGGER.info("Successfully launched {} via commands: {}", (Object)jarFilePath, sortedStartupCommands);
                } else {
                    LOGGER.info("Failed to start jar application {}, returning receipt error message {}.", (Object)jarFilePath, (Object)errorOutput);
                }
            } else {
                process.destroyForcibly().waitFor();
                LOGGER.error("Command {} execution timeout", sortedStartupCommands);
            }
        }
        catch (IOException ex) {
            LOGGER.error("IO error executing commands {}", sortedStartupCommands, (Object)ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            LOGGER.error("Command execution interrupted for {}", (Object)jarFilePath, (Object)ex);
        }
    }

    private static List<String> wrapWithBashShell(List<String> commands) {
        if (commands == null || commands.isEmpty()) {
            return commands;
        }
        ArrayList<String> shellCommands = new ArrayList<String>();
        shellCommands.add("/bin/bash");
        shellCommands.add("-c");
        shellCommands.add(String.join((CharSequence)" && ", commands));
        return shellCommands;
    }

    private static String copyToString(InputStream in) throws IOException {
        int charsRead;
        if (in == null) {
            return "";
        }
        StringBuilder out = new StringBuilder(4096);
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        char[] buffer = new char[4096];
        while ((charsRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, charsRead);
        }
        return out.toString();
    }
}

