/*
 * Decompiled with CFR 0.152.
 */
package top.plutoppppp.lock;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.plutoppppp.lock.ReentrantLockInfo;
import top.plutoppppp.lock.enumeration.ConcurrentType;

public abstract class AbsReentrantLockServer {
    private static final Logger log = LoggerFactory.getLogger(AbsReentrantLockServer.class);

    final boolean lock(ReentrantLockInfo lockInfo) {
        if (lockInfo.incrHoldCount() > 1) {
            return true;
        }
        try {
            boolean lockFlag;
            ConcurrentType concurrentType = lockInfo.getConcurrentType();
            switch (concurrentType) {
                case ONECE: {
                    lockFlag = this.concurrentOnece(lockInfo);
                    break;
                }
                case PREEMPTIVE: {
                    lockFlag = this.concurrentPreemptive(lockInfo);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u5e76\u53d1\u7c7b\u578b");
                }
            }
            if (!lockFlag) {
                lockInfo.decrHoldCount();
            }
            return lockFlag;
        }
        catch (Exception e) {
            log.error("\u9501\u5b9a\u65f6\u51fa\u9519", (Throwable)e);
            lockInfo.decrHoldCount();
            return false;
        }
    }

    protected abstract boolean concurrentOnece(ReentrantLockInfo var1) throws Exception;

    protected abstract boolean concurrentPreemptive(ReentrantLockInfo var1) throws Exception;

    final boolean unlock(ReentrantLockInfo lockInfo) {
        if (lockInfo.decrHoldCount() > 0) {
            return true;
        }
        try {
            return this.unlockRealize(lockInfo);
        }
        catch (Exception e) {
            log.error("\u89e3\u9501\u65f6\u51fa\u9519", (Throwable)e);
            return false;
        }
    }

    protected abstract boolean unlockRealize(ReentrantLockInfo var1) throws Exception;
}

