/*
 * Decompiled with CFR 0.152.
 */
package top.plutoppppp.lock;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import top.plutoppppp.lock.AbsReentrantLockServer;
import top.plutoppppp.lock.ReentrantLockInfo;
import top.plutoppppp.lock.exception.ReentrantLockException;

public final class LockActuator {
    public static final LockActuator INSTANCE = new LockActuator();
    private static ThreadLocal<Map<String, ReentrantLockInfo>> lockThreadLocal = new ThreadLocal();
    private AbsReentrantLockServer lockServer;

    private boolean trylock(ReentrantLockInfo lockInfo) {
        return this.lockServer.lock(lockInfo);
    }

    private boolean unlock(ReentrantLockInfo lockInfo) {
        return this.lockServer.unlock(lockInfo);
    }

    static boolean lock(ReentrantLockInfo lockInfo) {
        Map<String, ReentrantLockInfo> map = lockThreadLocal.get();
        if (map == null) {
            map = new HashMap<String, ReentrantLockInfo>();
            map.put(lockInfo.getLockKey(), lockInfo);
            lockThreadLocal.set(map);
        } else if (map.containsKey(lockInfo.getLockKey())) {
            lockInfo = map.get(lockInfo.getLockKey());
        } else {
            map.put(lockInfo.getLockKey(), lockInfo);
        }
        boolean trylock = INSTANCE.trylock(lockInfo);
        if (!trylock && lockInfo.emptyHold()) {
            map.remove(lockInfo.getLockKey());
            if (map.isEmpty()) {
                lockThreadLocal.remove();
            }
        }
        return trylock;
    }

    static boolean releaseLock(ReentrantLockInfo lockInfo) throws ReentrantLockException {
        Map<String, ReentrantLockInfo> map = lockThreadLocal.get();
        ReentrantLockInfo validLockInfo = map.get(lockInfo.getLockKey());
        if (Objects.isNull(validLockInfo)) {
            throw new ReentrantLockException("\u4e0d\u5b58\u5728\u7684lockKey[" + lockInfo.getLockKey() + "]");
        }
        boolean unlock = INSTANCE.unlock(validLockInfo);
        if (validLockInfo.emptyHold()) {
            map.remove(validLockInfo.getLockKey());
            if (map.isEmpty()) {
                lockThreadLocal.remove();
            }
        }
        return unlock;
    }

    private LockActuator() {
    }

    public void setLockServer(AbsReentrantLockServer lockServer) {
        this.lockServer = lockServer;
    }
}

