/*
 * Decompiled with CFR 0.152.
 */
package top.plutoppppp.lock;

import java.util.UUID;
import top.plutoppppp.lock.LockActuator;
import top.plutoppppp.lock.annotation.Lock;
import top.plutoppppp.lock.config.LockConstants;
import top.plutoppppp.lock.enumeration.ConcurrentType;
import top.plutoppppp.lock.exception.ReentrantLockException;

public final class ReentrantLockInfo {
    private String lockKey;
    private String lockValue;
    private ConcurrentType concurrentType;
    private long expire;
    private long overtime;
    private long waittime;
    private int holdCount = 0;

    int incrHoldCount() {
        ++this.holdCount;
        return this.holdCount;
    }

    int decrHoldCount() {
        --this.holdCount;
        return this.holdCount;
    }

    public boolean emptyHold() {
        return this.holdCount <= 0;
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public String getLockValue() {
        return this.lockValue;
    }

    public ConcurrentType getConcurrentType() {
        return this.concurrentType;
    }

    public long getExpire() {
        return this.expire;
    }

    public long getOvertime() {
        return this.overtime;
    }

    public long getWaittime() {
        return this.waittime;
    }

    public int getHoldCount() {
        return this.holdCount;
    }

    private ReentrantLockInfo(String lockKey, String lockValue, ConcurrentType concurrentType, long expire, long overtime, long waittime, int holdCount) {
        this.lockKey = lockKey;
        this.lockValue = lockValue;
        this.concurrentType = concurrentType;
        this.expire = expire;
        this.overtime = overtime;
        this.waittime = waittime;
        this.holdCount = holdCount;
    }

    public static final class CloseableLockHallows
    implements AutoCloseable {
        private boolean isLock = false;
        private boolean isUnlock = false;
        private ReentrantLockInfo lockInfo;

        private static CloseableLockHallows of(ReentrantLockInfo lockInfo) {
            CloseableLockHallows hallows = new CloseableLockHallows();
            hallows.lockInfo = lockInfo;
            return hallows;
        }

        void lock() throws ReentrantLockException {
            if (this.isLock) {
                throw new ReentrantLockException(String.format("\u9501[%s]\u5df2\u7ecf\u8fdb\u884c\u9501\u5b9a\uff0c\u4e0d\u5f97\u91cd\u590d\u6267\u884c", this.lockInfo.getLockKey()));
            }
            boolean lock = LockActuator.lock(this.lockInfo);
            if (!lock) {
                throw new ReentrantLockException(String.format("\u83b7\u53d6\u9501[%s]\u5931\u8d25", this.lockInfo.getLockKey()));
            }
            this.isLock = true;
        }

        public boolean unlock() throws ReentrantLockException {
            if (!this.isLock) {
                throw new ReentrantLockException(String.format("\u53ea\u80fd\u5bf9\u5df2\u9501\u5b9a\u7684\u9501[%s]\u8fdb\u884c\u89e3\u9501", this.lockInfo.getLockKey()));
            }
            if (this.isUnlock) {
                throw new ReentrantLockException(String.format("\u9501[%s]\u5df2\u7ecf\u8fdb\u884c\u8fc7\u89e3\u9501\uff0c\u4e0d\u5f97\u91cd\u590d\u6267\u884c", this.lockInfo.getLockKey()));
            }
            this.isUnlock = true;
            return LockActuator.releaseLock(this.lockInfo);
        }

        @Override
        public void close() throws ReentrantLockException {
            this.unlock();
        }

        private CloseableLockHallows() {
        }
    }

    public static final class ReentrantLockBuilder {
        private String lockKey;
        private ConcurrentType concurrentType = LockConstants.getConcurrentType();
        private long expire = LockConstants.getExpireMillis();
        private long overtime = LockConstants.getOvertimeMillis();
        private long waittime = LockConstants.getWaittimeMillis();

        public static ReentrantLockBuilder lockName(String lockName) {
            return ReentrantLockBuilder.lockKey(String.format("%s%s", LockConstants.getPrefixKey(), lockName));
        }

        public static ReentrantLockBuilder lockKey(String lockKey) {
            ReentrantLockBuilder builder = new ReentrantLockBuilder();
            builder.setLockKey(lockKey);
            return builder;
        }

        public static ReentrantLockBuilder lockAnno(Lock lock) {
            ReentrantLockBuilder builder = lock.lockKey().isEmpty() ? ReentrantLockBuilder.lockName(lock.value()) : ReentrantLockBuilder.lockKey(lock.lockKey());
            if (!ConcurrentType.DEFAULT.equals((Object)lock.concurrentType())) {
                builder.concurrentType(lock.concurrentType());
            }
            if (lock.expire() < 0L) {
                builder.expire(LockConstants.getExpireMillis());
            } else {
                builder.expire(lock.expire());
            }
            if (lock.overtimeMillis() < 0L) {
                builder.overtime(LockConstants.getOvertimeMillis());
            } else {
                builder.overtime(lock.overtimeMillis());
            }
            if (lock.waittimeMillis() < 0L) {
                builder.waittime(LockConstants.getWaittimeMillis());
            } else {
                builder.waittime(lock.waittimeMillis());
            }
            return builder;
        }

        public CloseableLockHallows trylock() throws ReentrantLockException {
            ReentrantLockInfo lockInfo = new ReentrantLockInfo(this.lockKey, UUID.randomUUID().toString(), this.concurrentType, this.expire, this.overtime, this.waittime, 0);
            CloseableLockHallows closeableLockHallows = CloseableLockHallows.of(lockInfo);
            closeableLockHallows.lock();
            return closeableLockHallows;
        }

        public String getLockKey() {
            return this.lockKey;
        }

        public ConcurrentType concurrentType() {
            return this.concurrentType;
        }

        public long expire() {
            return this.expire;
        }

        public long overtime() {
            return this.overtime;
        }

        public long waittime() {
            return this.waittime;
        }

        public ReentrantLockBuilder concurrentType(ConcurrentType concurrentType) {
            this.concurrentType = concurrentType;
            return this;
        }

        public ReentrantLockBuilder expire(long expire) {
            this.expire = expire;
            return this;
        }

        public ReentrantLockBuilder overtime(long overtime) {
            this.overtime = overtime;
            return this;
        }

        public ReentrantLockBuilder waittime(long waittime) {
            this.waittime = waittime;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReentrantLockBuilder)) {
                return false;
            }
            ReentrantLockBuilder other = (ReentrantLockBuilder)o;
            if (this.expire() != other.expire()) {
                return false;
            }
            if (this.overtime() != other.overtime()) {
                return false;
            }
            if (this.waittime() != other.waittime()) {
                return false;
            }
            String this$lockKey = this.getLockKey();
            String other$lockKey = other.getLockKey();
            if (this$lockKey == null ? other$lockKey != null : !this$lockKey.equals(other$lockKey)) {
                return false;
            }
            ConcurrentType this$concurrentType = this.concurrentType();
            ConcurrentType other$concurrentType = other.concurrentType();
            return !(this$concurrentType == null ? other$concurrentType != null : !((Object)((Object)this$concurrentType)).equals((Object)other$concurrentType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $expire = this.expire();
            result = result * 59 + (int)($expire >>> 32 ^ $expire);
            long $overtime = this.overtime();
            result = result * 59 + (int)($overtime >>> 32 ^ $overtime);
            long $waittime = this.waittime();
            result = result * 59 + (int)($waittime >>> 32 ^ $waittime);
            String $lockKey = this.getLockKey();
            result = result * 59 + ($lockKey == null ? 43 : $lockKey.hashCode());
            ConcurrentType $concurrentType = this.concurrentType();
            result = result * 59 + ($concurrentType == null ? 43 : ((Object)((Object)$concurrentType)).hashCode());
            return result;
        }

        public String toString() {
            return "ReentrantLockInfo.ReentrantLockBuilder(lockKey=" + this.getLockKey() + ", concurrentType=" + (Object)((Object)this.concurrentType()) + ", expire=" + this.expire() + ", overtime=" + this.overtime() + ", waittime=" + this.waittime() + ")";
        }

        private ReentrantLockBuilder() {
        }

        private ReentrantLockBuilder setLockKey(String lockKey) {
            this.lockKey = lockKey;
            return this;
        }
    }
}

