/*
 * Decompiled with CFR 0.152.
 */
package top.plutoppppp.lock.config;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import top.plutoppppp.lock.AbsReentrantLockServer;
import top.plutoppppp.lock.LockActuator;
import top.plutoppppp.lock.aop.LockAspect;
import top.plutoppppp.lock.config.LockConstants;
import top.plutoppppp.lock.config.LockRedisConfig;
import top.plutoppppp.lock.server.impl.ReentrantRedisLockServerImpl;

@Configuration
@AutoConfigureAfter(value={LockRedisConfig.class})
public class LockConfiguration {
    public static final String lockConfigPrefix = "lock";

    @Bean
    @ConfigurationProperties(prefix="lock.default")
    public LockConstants lockConstants() {
        return LockConstants.INSTANCE;
    }

    @Bean
    public AbsReentrantLockServer reentrantLockServer(RedisTemplate<String, ?> redisLockTemplate) {
        ReentrantRedisLockServerImpl impl = new ReentrantRedisLockServerImpl();
        impl.setRedisTemplate(redisLockTemplate);
        return impl;
    }

    @Bean
    public LockActuator lockActuator(AbsReentrantLockServer lockServer) {
        LockActuator.INSTANCE.setLockServer(lockServer);
        return LockActuator.INSTANCE;
    }

    @Bean
    public LockAspect lockAspect() {
        return new LockAspect();
    }
}

