/*
 * Decompiled with CFR 0.152.
 */
package top.plutoppppp.lock.config;

import java.time.Duration;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

@Configuration
@ConditionalOnProperty(prefix="lock.redis", name={"hostName"})
public class LockRedisConfig {
    public static final String lockRedisPrefix = "lock.redis";

    @Bean
    @Scope(value="prototype")
    @ConfigurationProperties(prefix="lock.redis.pool")
    public GenericObjectPoolConfig<?> redisLockPool() {
        return new GenericObjectPoolConfig();
    }

    @Bean
    @ConfigurationProperties(prefix="lock.redis")
    public RedisStandaloneConfiguration redisConfigLock() {
        return new RedisStandaloneConfiguration();
    }

    @Bean
    public LettuceConnectionFactory factoryLock(@Qualifier(value="redisLockPool") GenericObjectPoolConfig<?> redisPool, @Qualifier(value="redisConfigLock") RedisStandaloneConfiguration redisConfig) {
        LettucePoolingClientConfiguration clientConfiguration = LettucePoolingClientConfiguration.builder().poolConfig(redisPool).commandTimeout(Duration.ofMillis(redisPool.getMaxWaitMillis())).build();
        return new LettuceConnectionFactory(redisConfig, (LettuceClientConfiguration)clientConfiguration);
    }

    @Bean
    public RedisTemplate<String, ?> redisLockTemplate(@Qualifier(value="factoryLock") LettuceConnectionFactory factory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)factory);
        template.afterPropertiesSet();
        return template;
    }
}

