/*
 * Decompiled with CFR 0.152.
 */
package top.plutoppppp.lock.server.impl;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import top.plutoppppp.lock.AbsReentrantLockServer;
import top.plutoppppp.lock.ReentrantLockInfo;

public class ReentrantRedisLockServerImpl
extends AbsReentrantLockServer {
    private static final Logger log = LoggerFactory.getLogger(ReentrantRedisLockServerImpl.class);
    private static final RedisScript<String> SCRIPT_LOCK = new DefaultRedisScript("return redis.call('set',KEYS[1],ARGV[1],'NX','PX',ARGV[2])", String.class);
    private static final RedisScript<String> SCRIPT_UNLOCK = new DefaultRedisScript("if redis.call('get',KEYS[1]) == ARGV[1] then return tostring(redis.call('del', KEYS[1])==1) else return 'false' end", String.class);
    private static final String LOCK_SUCCESS = "OK";
    private RedisTemplate<String, ?> redisTemplate;

    private boolean acquireRedis(ReentrantLockInfo lockInfo) {
        String lockResult = (String)this.redisTemplate.execute(SCRIPT_LOCK, this.redisTemplate.getStringSerializer(), this.redisTemplate.getStringSerializer(), Collections.singletonList(lockInfo.getLockKey()), new Object[]{lockInfo.getLockValue(), String.valueOf(lockInfo.getExpire())});
        return LOCK_SUCCESS.equals(lockResult);
    }

    @Override
    protected boolean concurrentOnece(ReentrantLockInfo lockInfo) throws Exception {
        return this.acquireRedis(lockInfo);
    }

    @Override
    protected boolean concurrentPreemptive(ReentrantLockInfo lockInfo) throws Exception {
        String lockKey = lockInfo.getLockKey();
        long overtimeMillis = lockInfo.getOvertime();
        long waittimeMillis = lockInfo.getWaittime();
        long overtime = System.currentTimeMillis() + overtimeMillis;
        try {
            int queryCount = 0;
            while (System.currentTimeMillis() <= overtime) {
                boolean acquireRedis = this.acquireRedis(lockInfo);
                if (acquireRedis) {
                    log.trace("lockKey[{}] count[{}]", (Object)lockKey, (Object)queryCount);
                    return true;
                }
                TimeUnit.MILLISECONDS.sleep(waittimeMillis);
                ++queryCount;
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        return false;
    }

    @Override
    protected boolean unlockRealize(ReentrantLockInfo lockInfo) throws Exception {
        Object releaseResult = this.redisTemplate.execute(SCRIPT_UNLOCK, this.redisTemplate.getStringSerializer(), this.redisTemplate.getStringSerializer(), Collections.singletonList(lockInfo.getLockKey()), new Object[]{lockInfo.getLockValue()});
        return Boolean.valueOf(releaseResult.toString());
    }

    public void setRedisTemplate(RedisTemplate<String, ?> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

