/*
 * Decompiled with CFR 0.152.
 */
package top.potens.core.interceptor;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import top.potens.core.util.DateUtil;
import top.potens.log.AppLogger;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class MybatisLogInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        ResultHandler resultHandler = null;
        RowBounds rowBounds = null;
        if (args.length >= 3) {
            rowBounds = (RowBounds)args[2];
        }
        if (args.length >= 4) {
            resultHandler = (ResultHandler)args[3];
        }
        Executor executor = (Executor)invocation.getTarget();
        CacheKey cacheKey = null;
        BoundSql boundSql = null;
        if (args.length == 4) {
            boundSql = ms.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(ms, parameter, rowBounds, boundSql);
        } else if (args.length == 6) {
            cacheKey = (CacheKey)args[4];
            boundSql = (BoundSql)args[5];
        } else if (args.length == 2) {
            boundSql = ms.getBoundSql(parameter);
        }
        try {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            String sqlId = mappedStatement.getId();
            Configuration configuration = mappedStatement.getConfiguration();
            String sql = MybatisLogInterceptor.getSql(configuration, boundSql, sqlId);
            AppLogger.debug((String)"sqlId:[{}] sqlResult:[{}]", (Object[])new Object[]{sqlId, sql});
        }
        catch (Exception e) {
            AppLogger.error((String)("intercept error[" + e.getMessage() + "]"), (Throwable)e, (Object[])new Object[0]);
        }
        if ("update".equals(invocation.getMethod().getName())) {
            return invocation.proceed();
        }
        return executor.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
    }

    private static String getSql(Configuration configuration, BoundSql boundSql, String sqlId) {
        return MybatisLogInterceptor.showSql(configuration, boundSql);
    }

    private static String getParameterValue(Object obj) {
        String value = null;
        if (obj instanceof String) {
            value = "'" + obj.toString() + "'";
        } else if (obj instanceof Date) {
            DateUtil.getLocalDateStr((Date)obj);
            value = "'" + DateUtil.getLocalDateStr((Date)obj) + "'";
        } else {
            value = obj != null ? obj.toString() : "";
        }
        return value;
    }

    private static String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
        if (!parameterMappings.isEmpty() && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(MybatisLogInterceptor.getParameterValue(parameterObject)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(MybatisLogInterceptor.getParameterValue(obj)));
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        obj = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(MybatisLogInterceptor.getParameterValue(obj)));
                        continue;
                    }
                    sql = sql.replaceFirst("\\?", "\u7f3a\u5931");
                }
            }
        }
        return sql;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

