/*
 * Decompiled with CFR 0.152.
 */
package top.potens.core.util;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.function.Consumer;
import top.potens.core.model.DateScope;
import top.potens.core.util.StringUtil;

public class DateUtil {
    public static final DateTimeFormatter FORMATTER_DATETIMESTAMP = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
    public static final DateTimeFormatter FORMATTER_DATETIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    public static final DateTimeFormatter FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static LocalDate getLocalDate() {
        return LocalDate.now();
    }

    public static LocalTime getLocalTime() {
        return LocalTime.now();
    }

    public static LocalDateTime getLocalDateTime() {
        return LocalDateTime.now();
    }

    public static long getClockMillis() {
        Clock clock = Clock.systemDefaultZone();
        return clock.millis();
    }

    public static String getDateTimestamp() {
        return DateUtil.getLocalDateTime().format(FORMATTER_DATETIMESTAMP);
    }

    public static String getDate() {
        return DateUtil.getLocalDate().format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String getDateTime() {
        return DateUtil.getLocalDateTime().format(FORMATTER_DATETIME);
    }

    public static String getFirstDayOfMonth() {
        return DateUtil.getLocalDate().withDayOfMonth(1).format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String getLastDayOfMonth() {
        LocalDate localDate = DateUtil.getLocalDate();
        return localDate.withDayOfMonth(localDate.lengthOfMonth()).format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String formatDateTimestamp(String dateTimestamp) {
        return LocalDateTime.parse(dateTimestamp, FORMATTER_DATETIMESTAMP).format(FORMATTER_DATETIME);
    }

    public static String formatDateTime(String dateTime) {
        return DateUtil.parseLocalDateTime(dateTime).format(FORMATTER_DATETIMESTAMP);
    }

    public static LocalDateTime parseLocalDateTime(String dateTime) {
        return LocalDateTime.parse(dateTime, FORMATTER_DATETIME);
    }

    public static LocalDateTime parseLocalDateTimestamp(String dateTimestamp) {
        return LocalDateTime.parse(dateTimestamp, FORMATTER_DATETIMESTAMP);
    }

    public static LocalDate parseLocalDate(String dateString) {
        return LocalDate.parse(dateString, DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String plusDays(String date, int days) {
        LocalDate localDate = DateUtil.parseLocalDate(date);
        return localDate.plusDays(days).format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static int dateCompareTo(String startDate, String endDate) {
        LocalDate startLocalDate = LocalDate.parse(startDate, DateTimeFormatter.ISO_LOCAL_DATE);
        LocalDate endLocalDate = LocalDate.parse(endDate, DateTimeFormatter.ISO_LOCAL_DATE);
        Period period = Period.between(startLocalDate, endLocalDate);
        return period.getDays();
    }

    public static String getLocalDateStr(Date date) {
        return DateUtil.getLocalDateStr(date, FORMATTER_DATETIME);
    }

    public static String getLocalDateStr(Date date, String formatter) {
        return DateUtil.getLocalDateStr(date, DateTimeFormatter.ofPattern(formatter));
    }

    public static String getLocalDateStr(Date date, DateTimeFormatter dateTimeFormatter) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zoneId);
        return dateTimeFormatter.format(localDateTime);
    }

    public static Date getLocalDateTime(String date, DateTimeFormatter dateTimeFormatter) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime parse = LocalDateTime.parse(date, dateTimeFormatter);
        ZonedDateTime zdt = parse.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static Date getLocalDateTime(String date) {
        return DateUtil.getLocalDateTime(date, FORMATTER_DATETIME);
    }

    public static Date getDateByLocalDate(LocalDate localDate) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static Date getLocalDate(String date, DateTimeFormatter dateTimeFormatter) {
        LocalDate localDate = LocalDate.parse(date, dateTimeFormatter);
        return DateUtil.getDateByLocalDate(localDate);
    }

    public static Date getLocalDate(String date) {
        return DateUtil.getLocalDate(date, FORMATTER_DATE);
    }

    public static void setScopeDate(String scopeDate, Consumer<Date> start, Consumer<Date> end) {
        if (StringUtil.isNotBlank((CharSequence)scopeDate)) {
            String[] split = scopeDate.split(",");
            if (split.length == 1) {
                start.accept(DateUtil.getLocalDate(split[0]));
            } else if (split.length == 2) {
                start.accept(DateUtil.getLocalDate(split[0]));
                end.accept(DateUtil.getLocalDate(split[1]));
            }
        }
    }

    public static DateScope getDateScope(String scopeDate) {
        DateScope dateScope = new DateScope();
        if (StringUtil.isNotBlank((CharSequence)scopeDate)) {
            String[] split = scopeDate.split(",");
            if (split.length == 1) {
                dateScope.setStartDate(DateUtil.getLocalDate(split[0]));
            } else if (split.length == 2) {
                dateScope.setStartDate(DateUtil.getLocalDate(split[0]));
                dateScope.setEndDate(DateUtil.getLocalDate(split[1]));
            }
        }
        return dateScope;
    }
}

