/*
 * Decompiled with CFR 0.152.
 */
package top.potens.core.aop;

import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import top.potens.core.enums.CommonExceptionCodeEnums;
import top.potens.core.exception.ApiException;
import top.potens.core.model.TokenUser;
import top.potens.log.HttpContext;

@Aspect
@Component
@Order(value=1000)
public class ControllerTokenAspect {
    private static final Logger log = LoggerFactory.getLogger(ControllerTokenAspect.class);

    @Pointcut(value="@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object handle(ProceedingJoinPoint joinPoint) throws Throwable {
        HttpServletRequest request = HttpContext.getRequest();
        if (request == null) {
            throw new ApiException(CommonExceptionCodeEnums.REQUEST_IS_NULL);
        }
        Object[] args = joinPoint.getArgs();
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        String[] parameterNames = methodSignature.getParameterNames();
        Class[] parameterTypes = methodSignature.getParameterTypes();
        int len = parameterNames.length;
        for (int i = 0; i < len; ++i) {
            Class parameterType = parameterTypes[i];
            if (!TokenUser.class.equals((Object)parameterType)) continue;
            TokenUser tokenUser = (TokenUser)request.getSession().getAttribute("REQUEST_CURRENT_KEY");
            if (tokenUser == null) {
                throw new ApiException("500", "controller define tokenUser, but session not found tokenUser");
            }
            args[i] = tokenUser;
        }
        return joinPoint.proceed(args);
    }
}

